/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.HttpResponse;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.io.DuplicatableInputStream;
import com.oracle.bmc.http.client.jersey.JerseyHttpClient;
import com.oracle.bmc.http.client.jersey.JerseyHttpResponse;
import com.oracle.bmc.http.client.jersey.internal.ApacheDuplicatableInputStreamEntity;
import com.oracle.bmc.http.client.jersey.internal.ApacheInputStreamEntity;
import com.oracle.bmc.http.client.jersey.io.internal.LengthLimitedInputStream;
import com.oracle.bmc.serialization.jackson.JacksonSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JerseyHttpRequest
implements HttpRequest {
    static final boolean isExtraStreamLogsEnabled = JerseyHttpRequest.isExtraStreamLogsEnabledViaSystemProperty();
    private static final Logger LOG = LoggerFactory.getLogger(JerseyHttpRequest.class);
    private final JerseyHttpClient client;
    private final Method method;
    private Object processedBody;
    private MediaType requestBodyType;
    private Locale requestBodyLanguage;
    private String requestBodyEncoding;
    private WebTarget webTarget;
    private final MultivaluedMap<String, String> headers;
    private final Map<String, Object> attributes;

    private static boolean isExtraStreamLogsEnabledViaSystemProperty() {
        String trimmedValue;
        String streamLogsEnabledString = System.getProperty("oci.javasdk.extra.stream.logs.enabled");
        return streamLogsEnabledString == null || streamLogsEnabledString.isEmpty() || !"false".equalsIgnoreCase(trimmedValue = streamLogsEnabledString.trim());
    }

    JerseyHttpRequest(JerseyHttpClient client, Method method, WebTarget webTarget) {
        this.client = client;
        this.method = method;
        this.webTarget = webTarget;
        this.attributes = new HashMap<String, Object>();
        this.headers = new MultivaluedHashMap();
    }

    private JerseyHttpRequest(JerseyHttpRequest from) {
        this.client = from.client;
        this.method = from.method;
        this.processedBody = from.processedBody;
        this.requestBodyType = from.requestBodyType;
        this.requestBodyLanguage = from.requestBodyLanguage;
        this.requestBodyEncoding = from.requestBodyEncoding;
        this.webTarget = from.webTarget;
        this.headers = new MultivaluedHashMap(from.headers);
        this.attributes = new HashMap<String, Object>(from.attributes);
    }

    public Method method() {
        return this.method;
    }

    private void logAvailable(InputStream body) {
        if (isExtraStreamLogsEnabled) {
            try {
                int bytesAvailable = body.available();
                if (bytesAvailable == 0) {
                    LOG.warn("Stream size to upload is 0 bytes, this could potentially lead to data corruption. If this is not intended, please make sure all the OCI SDK dependencies point to the same version");
                }
            }
            catch (IOException e) {
                LOG.warn("Error calling available on the stream to get the available number of bytes");
            }
        }
    }

    public HttpRequest body(Object body) {
        if (body instanceof String) {
            this.processedBody = body;
        } else if (body instanceof InputStream) {
            this.logAvailable((InputStream)body);
            this.processedBody = body;
        } else if (body == null) {
            this.processedBody = "";
        } else {
            try {
                this.processedBody = JacksonSerializer.getDefaultObjectMapper().writeValueAsString(body);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Unable to process JSON body", e);
            }
        }
        return this;
    }

    public HttpRequest body(InputStream body, long contentLength) {
        this.logAvailable(body);
        LengthLimitedInputStream limitedStream = new LengthLimitedInputStream(body, contentLength);
        this.processedBody = this.client.isApacheNonBufferingClient && contentLength > 0L ? (body instanceof DuplicatableInputStream ? new ApacheDuplicatableInputStreamEntity((DuplicatableInputStream)body, (Long)contentLength) : new ApacheInputStreamEntity(limitedStream, contentLength)) : body;
        return this;
    }

    public Object body() {
        return this.processedBody;
    }

    public HttpRequest appendPathPart(String encodedPathPart) {
        this.webTarget = this.webTarget.path(encodedPathPart);
        return this;
    }

    public HttpRequest query(String name, String value) {
        this.webTarget = this.webTarget.queryParam(name, new Object[]{value});
        return this;
    }

    public URI uri() {
        return this.webTarget.getUri();
    }

    public HttpRequest header(String name, String value) {
        this.headers.add((Object)name, (Object)value);
        if (name.equalsIgnoreCase("Content-Type")) {
            this.requestBodyType = MediaType.valueOf((String)value);
        }
        if (name.equalsIgnoreCase("Content-Language")) {
            this.requestBodyLanguage = Locale.forLanguageTag(value);
        }
        if (name.equalsIgnoreCase("Content-Encoding")) {
            this.requestBodyEncoding = value;
        }
        return this;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Object attribute(String name) {
        return this.attributes.get(name);
    }

    public HttpRequest removeAttribute(String name) {
        this.attributes.remove(name);
        return this;
    }

    public HttpRequest attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public HttpRequest offloadExecutor(Executor executor) {
        return this;
    }

    public HttpRequest copy() {
        return new JerseyHttpRequest(this);
    }

    public void discard() {
    }

    public CompletionStage<HttpResponse> execute() {
        CompletionStage stage;
        for (RequestInterceptor interceptor : this.client.requestInterceptors) {
            interceptor.intercept((HttpRequest)this);
        }
        CompletionStageRxInvoker invoker = this.webTarget.request().headers((MultivaluedMap)new MultivaluedHashMap(this.headers)).rx();
        if (this.processedBody == null) {
            stage = invoker.method(this.method.name());
        } else {
            Variant variant = new Variant(this.requestBodyType, this.requestBodyLanguage, this.requestBodyEncoding);
            stage = invoker.method(this.method.name(), Entity.entity((Object)this.processedBody, (Variant)variant));
        }
        return stage.thenApply(JerseyHttpResponse::new);
    }
}

