/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.artifact;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.artifact.GavCalculator;

@Singleton
@Named(value="maven2")
public class M2GavCalculator
implements GavCalculator {
    @Override
    public Gav pathToGav(String str) {
        try {
            String s = str.startsWith("/") ? str.substring(1) : str;
            int vEndPos = s.lastIndexOf(47);
            if (vEndPos == -1) {
                return null;
            }
            int aEndPos = s.lastIndexOf(47, vEndPos - 1);
            if (aEndPos == -1) {
                return null;
            }
            int gEndPos = s.lastIndexOf(47, aEndPos - 1);
            if (gEndPos == -1) {
                return null;
            }
            String groupId = s.substring(0, gEndPos).replace('/', '.');
            String artifactId = s.substring(gEndPos + 1, aEndPos);
            String version = s.substring(aEndPos + 1, vEndPos);
            String fileName = s.substring(vEndPos + 1);
            boolean checksum = false;
            boolean signature = false;
            Gav.HashType checksumType = null;
            Gav.SignatureType signatureType = null;
            if (s.endsWith(".md5")) {
                checksum = true;
                checksumType = Gav.HashType.md5;
                s = s.substring(0, s.length() - 4);
            } else if (s.endsWith(".sha1")) {
                checksum = true;
                checksumType = Gav.HashType.sha1;
                s = s.substring(0, s.length() - 5);
            } else if (s.endsWith(".sha256")) {
                checksum = true;
                checksumType = Gav.HashType.sha256;
                s = s.substring(0, s.length() - 7);
            } else if (s.endsWith(".sha512")) {
                checksum = true;
                checksumType = Gav.HashType.sha512;
                s = s.substring(0, s.length() - 7);
            }
            if (s.endsWith(".asc")) {
                signature = true;
                signatureType = Gav.SignatureType.gpg;
                s = s.substring(0, s.length() - 4);
            }
            if (s.endsWith("maven-metadata.xml") || fileName.startsWith("maven-metadata-") && fileName.contains(".xml") || fileName.startsWith("_") && fileName.endsWith(".repositories")) {
                return null;
            }
            boolean snapshot = version.endsWith("SNAPSHOT");
            if (snapshot) {
                return this.getSnapshotGav(s, vEndPos, groupId, artifactId, version, fileName, checksum, signature, checksumType, signatureType);
            }
            return this.getReleaseGav(s, vEndPos, groupId, artifactId, version, fileName, checksum, signature, checksumType, signatureType);
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            return null;
        }
    }

    private Gav getReleaseGav(String s, int vEndPos, String groupId, String artifactId, String version, String fileName, boolean checksum, boolean signature, Gav.HashType checksumType, Gav.SignatureType signatureType) {
        if (!fileName.startsWith(artifactId + "-" + version + ".") && !fileName.startsWith(artifactId + "-" + version + "-")) {
            return null;
        }
        int nTailPos = vEndPos + artifactId.length() + version.length() + 2;
        String tail = s.substring(nTailPos);
        int nExtPos = tail.indexOf(46);
        if (nExtPos == -1) {
            return null;
        }
        String ext = tail.substring(nExtPos + 1);
        String classifier = tail.charAt(0) == '-' ? tail.substring(1, nExtPos) : null;
        return new Gav(groupId, artifactId, version, classifier, ext, null, null, fileName, checksum, checksumType, signature, signatureType);
    }

    private Gav getSnapshotGav(String s, int vEndPos, String groupId, String artifactId, String version, String fileName, boolean checksum, boolean signature, Gav.HashType checksumType, Gav.SignatureType signatureType) {
        String classifier;
        String ext;
        Integer snapshotBuildNo = null;
        Long snapshotTimestamp = null;
        int vSnapshotStart = vEndPos + artifactId.length() + ((String)version).length() - 9 + 3;
        String vSnapshot = s.substring(vSnapshotStart, vSnapshotStart + 8);
        if ("SNAPSHOT".equals(vSnapshot)) {
            int nTailPos = vEndPos + artifactId.length() + ((String)version).length() + 2;
            String tail = s.substring(nTailPos);
            int nExtPos = tail.indexOf(46);
            if (nExtPos == -1) {
                return null;
            }
            ext = tail.substring(nExtPos + 1);
            classifier = tail.charAt(0) == '-' ? tail.substring(1, nExtPos) : null;
        } else {
            StringBuilder sb = new StringBuilder(vSnapshot);
            sb.append(s, vSnapshotStart + sb.length(), vSnapshotStart + sb.length() + 8);
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd.HHmmss");
                snapshotTimestamp = df.parse(sb.toString()).getTime();
            }
            catch (ParseException df) {
                // empty catch block
            }
            int buildNumberPos = vSnapshotStart + sb.length();
            StringBuilder bnr = new StringBuilder();
            while (s.charAt(buildNumberPos) >= '0' && s.charAt(buildNumberPos) <= '9') {
                sb.append(s.charAt(buildNumberPos));
                bnr.append(s.charAt(buildNumberPos));
                ++buildNumberPos;
            }
            String snapshotBuildNumber = sb.toString();
            snapshotBuildNo = Integer.parseInt(bnr.toString());
            int n = ((String)version).length() > 9 ? ((String)version).length() - 9 + 1 : 0;
            String tail = s.substring(vEndPos + artifactId.length() + n + snapshotBuildNumber.length() + 2);
            int nExtPos = tail.indexOf(46);
            if (nExtPos == -1) {
                return null;
            }
            ext = tail.substring(nExtPos + 1);
            classifier = tail.charAt(0) == '-' ? tail.substring(1, nExtPos) : null;
            version = ((String)version).substring(0, ((String)version).length() - 8) + snapshotBuildNumber;
        }
        return new Gav(groupId, artifactId, (String)version, classifier, ext, snapshotBuildNo, snapshotTimestamp, fileName, checksum, checksumType, signature, signatureType);
    }

    @Override
    public String gavToPath(Gav gav) {
        return "/" + gav.getGroupId().replaceAll("(?m)(.)\\.", "$1/") + "/" + gav.getArtifactId() + "/" + gav.getBaseVersion() + "/" + this.calculateArtifactName(gav);
    }

    public String calculateArtifactName(Gav gav) {
        if (gav.getName() != null && !gav.getName().isBlank()) {
            return gav.getName();
        }
        StringBuilder path = new StringBuilder(gav.getArtifactId());
        path.append("-");
        path.append(gav.getVersion());
        if (gav.getClassifier() != null && !gav.getClassifier().isBlank()) {
            path.append("-");
            path.append(gav.getClassifier());
        }
        if (gav.getExtension() != null) {
            path.append(".");
            path.append(gav.getExtension());
        }
        if (gav.isSignature()) {
            path.append(".");
            path.append(gav.getSignatureType().toString());
        }
        if (gav.isHash()) {
            path.append(".");
            path.append(gav.getHashType().toString());
        }
        return path.toString();
    }
}

