/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.event.KeyEvent;
import java.util.Stack;
import org.netbeans.lib.terminalemulator.AbstractInterp;
import org.netbeans.lib.terminalemulator.Ops;

public class InterpDumb
extends AbstractInterp {
    private final Stack<AbstractInterp.State> stack = new Stack();
    private StringBuilder ctlSequence;
    private final InterpTypeDumb type;
    private static final InterpTypeDumb type_singleton = new InterpTypeDumb();

    protected void push_state(AbstractInterp.State s) {
        this.stack.push(s);
    }

    protected AbstractInterp.State pop_state() {
        return this.stack.pop();
    }

    protected void pop_all_states() {
        while (!this.stack.empty()) {
            this.stack.pop();
        }
    }

    public InterpDumb(Ops ops) {
        super(ops);
        this.type = type_singleton;
        this.setup();
        this.ctlSequence = new StringBuilder();
    }

    protected InterpDumb(Ops ops, InterpTypeDumb type) {
        super(ops);
        this.type = type;
        this.setup();
        this.ctlSequence = new StringBuilder();
    }

    @Override
    public String name() {
        return "dumb";
    }

    @Override
    public void reset() {
        super.reset();
        this.pop_all_states();
        this.state = this.type.st_base;
        this.ctlSequence = new StringBuilder();
    }

    private void setup() {
        this.state = this.type.st_base;
    }

    private void reset_state_bad() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processChar(char c) {
        this.ctlSequence.append(c);
        try {
            AbstractInterp.State.Action a = this.state.getAction(c);
            String err_str = a.actor.action(this, c);
            if (err_str != null) {
                this.ops.logUnrecognizedSequence(this.ctlSequence.toString());
                this.reset_state_bad();
                return;
            }
            if (a.new_state != null) {
                this.state = a.new_state;
            }
        }
        finally {
            if (this.state == this.type.st_base) {
                this.ops.logCompletedSequence(this.ctlSequence.toString());
                this.ctlSequence = new StringBuilder();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public char mapACS(char inChar) {
        return '\u0000';
    }

    @Override
    public void softReset() {
    }

    protected static class InterpTypeDumb {
        public final AbstractInterp.State st_base = new AbstractInterp.State("base");
        protected final AbstractInterp.Actor act_nop = new ACT_NOP();
        protected final AbstractInterp.Actor act_pause = new ACT_PAUSE();
        protected final AbstractInterp.Actor act_err = new ACT_ERR();
        protected final AbstractInterp.Actor act_regular = new ACT_REGULAR();
        protected final AbstractInterp.Actor act_cr = new ACT_CR();
        protected final AbstractInterp.Actor act_lf = new ACT_LF();
        protected final AbstractInterp.Actor act_bs = new ACT_BS();
        protected final AbstractInterp.Actor act_tab = new ACT_TAB();
        protected final AbstractInterp.Actor act_beL = new ACT_BEL();

        protected InterpTypeDumb() {
            this.st_base.setRegular(this.st_base, this.act_regular);
            for (char c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
                this.st_base.setAction(c, this.st_base, this.act_regular);
            }
            this.st_base.setAction('\u0000', this.st_base, this.act_pause);
            this.st_base.setAction('\r', this.st_base, this.act_cr);
            this.st_base.setAction('\n', this.st_base, this.act_lf);
            this.st_base.setAction('\b', this.st_base, this.act_bs);
            this.st_base.setAction('\t', this.st_base, this.act_tab);
            this.st_base.setAction('\u0007', this.st_base, this.act_beL);
        }

        private static final class ACT_NOP
        implements AbstractInterp.Actor {
            private ACT_NOP() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                return null;
            }
        }

        private static final class ACT_PAUSE
        implements AbstractInterp.Actor {
            private ACT_PAUSE() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_pause();
                return null;
            }
        }

        private static final class ACT_ERR
        implements AbstractInterp.Actor {
            private ACT_ERR() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                return "ACT ERROR";
            }
        }

        private static final class ACT_REGULAR
        implements AbstractInterp.Actor {
            private ACT_REGULAR() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_char(c);
                return null;
            }
        }

        private static final class ACT_CR
        implements AbstractInterp.Actor {
            private ACT_CR() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_carriage_return();
                return null;
            }
        }

        private static final class ACT_LF
        implements AbstractInterp.Actor {
            private ACT_LF() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_line_feed();
                return null;
            }
        }

        private static final class ACT_BS
        implements AbstractInterp.Actor {
            private ACT_BS() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_back_space();
                return null;
            }
        }

        private static final class ACT_TAB
        implements AbstractInterp.Actor {
            private ACT_TAB() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_tab();
                return null;
            }
        }

        private static final class ACT_BEL
        implements AbstractInterp.Actor {
            private ACT_BEL() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_bel();
                return null;
            }
        }
    }
}

