/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.DeleteStatement;
import liquibase.structure.core.Column;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;
import org.keycloak.migration.ModelVersion;

public class JpaUpdate26_2_6_RemoveDuplicateMigrationModelTime
extends CustomKeycloakTask {
    private static final String MIGRATION_MODEL_TABLE = "MIGRATION_MODEL";

    @Override
    protected String getTaskId() {
        return "Delete duplicated records for DB update time in MIGRATION_MODEL table";
    }

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        HashMap<String, ModelVersion> itemsToDelete = new HashMap<String, ModelVersion>();
        String tableName = this.getTableName(MIGRATION_MODEL_TABLE);
        String colId = this.database.correctObjectName("ID", Column.class);
        String colVersion = this.database.correctObjectName("VERSION", Column.class);
        String colUpdateTime = this.database.correctObjectName("UPDATE_TIME", Column.class);
        String GET_DUPLICATED_RECORDS = "SELECT m1.%s, m1.%s\nFROM %s m1\nWHERE EXISTS (\n    SELECT m2.%s\n    FROM %s m2\n    WHERE m2.%s = m1.%s AND m2.%s <> m1.%s\n)\n".formatted(colId, colVersion, tableName, colId, tableName, colUpdateTime, colUpdateTime, colId, colId);
        try (PreparedStatement ps = this.connection.prepareStatement(GET_DUPLICATED_RECORDS);){
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                String id2 = resultSet.getString(1);
                ModelVersion version = new ModelVersion(resultSet.getString(2));
                itemsToDelete.put(id2, version);
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Failed to detect duplicate MIGRATION_MODEL rows", (Throwable)e);
        }
        String highestVersionId = itemsToDelete.entrySet().stream().reduce((e1, e2) -> ((ModelVersion)e1.getValue()).lessThan((ModelVersion)e2.getValue()) ? e2 : e1).map(Map.Entry::getKey).orElse(null);
        AtomicInteger i = new AtomicInteger();
        itemsToDelete.keySet().stream().filter(f -> !f.equals(highestVersionId)).collect(Collectors.groupingByConcurrent(id -> i.getAndIncrement() / 20, Collectors.toList())).values().stream().map(ids -> new DeleteStatement(null, null, MIGRATION_MODEL_TABLE).setWhere(":name IN (" + ids.stream().map(id -> "?").collect(Collectors.joining(",")) + ")").addWhereColumnName(colId).addWhereParameters(ids.toArray())).forEach(this.statements::add);
    }
}

