/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.List;
import org.keycloak.common.profile.ProfileException;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractAutoBuildCommand;
import org.keycloak.quarkus.runtime.cli.command.ImportRealmMixin;
import org.keycloak.quarkus.runtime.cli.command.OptimizedMixin;
import picocli.CommandLine;

@CommandLine.Command(name="start", header={"Start the server."}, description={"%nUse this command to run the server in production."}, footer={"%nBy default, this command tries to update the server configuration by running a 'build' before starting the server. You can disable this behavior by using the '--optimized' option:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} '--optimized'%n%nBy doing that, the server should start faster based on any previous configuration you have set when manually running the 'build' command."})
public final class Start
extends AbstractAutoBuildCommand {
    public static final String NAME = "start";
    @CommandLine.Mixin
    OptimizedMixin optimizedMixin = new OptimizedMixin();
    @CommandLine.Mixin
    ImportRealmMixin importRealmMixin;

    @Override
    protected void doBeforeRun() {
        if (Environment.isDevProfile()) {
            throw new PropertyException(Messages.devProfileNotAllowedError(NAME));
        }
    }

    @Override
    public boolean includeRuntime() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static void fastStart(Picocli picocli, boolean dryRun) {
        try {
            Start start = new Start();
            start.optimizedMixin.optimized = true;
            start.dryRunMixin.dryRun = dryRun;
            start.setPicocli(picocli);
            picocli.initConfig(List.of("--optimized"), start);
            picocli.exit(start.call());
        }
        catch (ProfileException | PropertyException e) {
            picocli.usageException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public boolean isServing() {
        return true;
    }
}

