/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.IntSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.primitive.i.BoxedIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.DistinctIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FilterIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FlatMapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.LimitIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToDoubleIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToLongIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToObjIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.PeekIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.SkipIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.SortedIntOperation;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.local.LocalDoubleCacheStream;
import org.infinispan.stream.impl.local.LocalLongCacheStream;

public class LocalIntCacheStream
extends AbstractLocalCacheStream<Integer, IntStream, IntCacheStream>
implements IntCacheStream {
    public LocalIntCacheStream(AbstractLocalCacheStream.StreamSupplier<Integer, IntStream> streamSupplier, boolean parallel, ComponentRegistry registry) {
        super(streamSupplier, parallel, registry);
    }

    LocalIntCacheStream(AbstractLocalCacheStream<?, ?, ?> original) {
        super(original);
    }

    @Override
    public LocalIntCacheStream filter(IntPredicate predicate) {
        this.registry.wireDependencies(predicate);
        this.intermediateOperations.add(new FilterIntOperation(predicate));
        return this;
    }

    @Override
    public LocalIntCacheStream map(IntUnaryOperator mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapIntOperation(mapper));
        return this;
    }

    public <U> LocalCacheStream<U> mapToObj(IntFunction<? extends U> mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapToObjIntOperation<U>(mapper));
        return new LocalCacheStream(this);
    }

    @Override
    public LocalLongCacheStream mapToLong(IntToLongFunction mapper) {
        this.intermediateOperations.add(new MapToLongIntOperation(mapper));
        return new LocalLongCacheStream(this);
    }

    @Override
    public LocalDoubleCacheStream mapToDouble(IntToDoubleFunction mapper) {
        this.intermediateOperations.add(new MapToDoubleIntOperation(mapper));
        return new LocalDoubleCacheStream(this);
    }

    @Override
    public LocalIntCacheStream flatMap(IntFunction<? extends IntStream> mapper) {
        this.intermediateOperations.add(new FlatMapIntOperation(mapper));
        return this;
    }

    @Override
    public LocalIntCacheStream distinct() {
        this.intermediateOperations.add(DistinctIntOperation.getInstance());
        return this;
    }

    @Override
    public LocalIntCacheStream sorted() {
        this.intermediateOperations.add(SortedIntOperation.getInstance());
        return this;
    }

    @Override
    public LocalIntCacheStream peek(IntConsumer action) {
        this.intermediateOperations.add(new PeekIntOperation(action));
        return this;
    }

    @Override
    public LocalIntCacheStream limit(long maxSize) {
        this.intermediateOperations.add(new LimitIntOperation(maxSize));
        return this;
    }

    @Override
    public LocalIntCacheStream skip(long n) {
        this.intermediateOperations.add(new SkipIntOperation(n));
        return this;
    }

    @Override
    public void forEach(IntConsumer action) {
        this.injectCache(action);
        try (IntStream stream = (IntStream)this.createStream();){
            stream.forEach(action);
        }
    }

    @Override
    public <K, V> void forEach(ObjIntConsumer<Cache<K, V>> action) {
        Cache cache = this.registry.getComponent(Cache.class);
        try (IntStream stream = (IntStream)this.createStream();){
            stream.forEach((int i) -> action.accept(cache, i));
        }
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        this.injectCache(action);
        try (IntStream stream = (IntStream)this.createStream();){
            stream.forEachOrdered(action);
        }
    }

    private void injectCache(IntConsumer cacheAware) {
        if (cacheAware instanceof CacheAware) {
            ((CacheAware)((Object)cacheAware)).injectCache(this.registry.getComponent(Cache.class));
        }
    }

    @Override
    public int[] toArray() {
        try (IntStream stream = (IntStream)this.createStream();){
            int[] nArray = stream.toArray();
            return nArray;
        }
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        try (IntStream stream = (IntStream)this.createStream();){
            int n = stream.reduce(identity, op);
            return n;
        }
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        try (IntStream stream = (IntStream)this.createStream();){
            OptionalInt optionalInt = stream.reduce(op);
            return optionalInt;
        }
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        try (IntStream stream = (IntStream)this.createStream();){
            R r = stream.collect(supplier, accumulator, combiner);
            return r;
        }
    }

    @Override
    public int sum() {
        try (IntStream stream = (IntStream)this.createStream();){
            int n = stream.sum();
            return n;
        }
    }

    @Override
    public OptionalInt min() {
        try (IntStream stream = (IntStream)this.createStream();){
            OptionalInt optionalInt = stream.min();
            return optionalInt;
        }
    }

    @Override
    public OptionalInt max() {
        try (IntStream stream = (IntStream)this.createStream();){
            OptionalInt optionalInt = stream.max();
            return optionalInt;
        }
    }

    @Override
    public long count() {
        try (IntStream stream = (IntStream)this.createStream();){
            long l = stream.count();
            return l;
        }
    }

    @Override
    public OptionalDouble average() {
        try (IntStream stream = (IntStream)this.createStream();){
            OptionalDouble optionalDouble = stream.average();
            return optionalDouble;
        }
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        try (IntStream stream = (IntStream)this.createStream();){
            IntSummaryStatistics intSummaryStatistics = stream.summaryStatistics();
            return intSummaryStatistics;
        }
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        try (IntStream stream = (IntStream)this.createStream();){
            boolean bl = stream.anyMatch(predicate);
            return bl;
        }
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        try (IntStream stream = (IntStream)this.createStream();){
            boolean bl = stream.allMatch(predicate);
            return bl;
        }
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        try (IntStream stream = (IntStream)this.createStream();){
            boolean bl = stream.noneMatch(predicate);
            return bl;
        }
    }

    @Override
    public OptionalInt findFirst() {
        try (IntStream stream = (IntStream)this.createStream();){
            OptionalInt optionalInt = stream.findFirst();
            return optionalInt;
        }
    }

    @Override
    public OptionalInt findAny() {
        try (IntStream stream = (IntStream)this.createStream();){
            OptionalInt optionalInt = stream.findAny();
            return optionalInt;
        }
    }

    @Override
    public LongCacheStream asLongStream() {
        return this.mapToLong(i -> i);
    }

    @Override
    public DoubleCacheStream asDoubleStream() {
        return this.mapToDouble(i -> i);
    }

    @Override
    public LocalCacheStream<Integer> boxed() {
        this.intermediateOperations.add(BoxedIntOperation.getInstance());
        return new LocalCacheStream<Integer>(this);
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        IntStream stream = (IntStream)this.createStream();
        this.onCloseRunnables.add(stream::close);
        return stream.iterator();
    }

    @Override
    public Spliterator.OfInt spliterator() {
        IntStream stream = (IntStream)this.createStream();
        this.onCloseRunnables.add(stream::close);
        return stream.spliterator();
    }

    @Override
    public LocalIntCacheStream sequentialDistribution() {
        return this;
    }

    @Override
    public LocalIntCacheStream parallelDistribution() {
        return this;
    }

    @Override
    public LocalIntCacheStream filterKeySegments(IntSet segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public LocalIntCacheStream filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public LocalIntCacheStream distributedBatchSize(int batchSize) {
        return this;
    }

    @Override
    public LocalIntCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        return this;
    }

    @Override
    public LocalIntCacheStream disableRehashAware() {
        return this;
    }

    @Override
    public LocalIntCacheStream timeout(long timeout, TimeUnit unit) {
        return this;
    }
}

