/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.metrics.spi;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.quarkus.opentelemetry.runtime.exporter.otlp.metrics.NoopMetricExporter;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

public class MetricsExporterCDIProvider
implements ConfigurableMetricExporterProvider {
    private static final Logger LOG = Logger.getLogger((String)MetricsExporterCDIProvider.class.getName());

    public MetricExporter createExporter(ConfigProperties configProperties) {
        Instance exporters = CDI.current().select(MetricExporter.class, new Annotation[]{Any.Literal.INSTANCE});
        if (LOG.isDebugEnabled()) {
            LOG.debugf("available exporters: %s", (Object)exporters.stream().map(e -> e.getClass().getName()).reduce((a, b) -> a + ", " + b).orElse("none"));
        }
        if (exporters.isUnsatisfied()) {
            return NoopMetricExporter.INSTANCE;
        }
        return (MetricExporter)exporters.get();
    }

    public String getName() {
        return "cdi";
    }
}

