/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPathParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.TrustStoreManager;
import sun.security.ssl.X509TrustManagerImpl;
import sun.security.validator.TrustStoreUtil;

abstract class TrustManagerFactoryImpl
extends TrustManagerFactorySpi {
    private X509TrustManager trustManager = null;
    private boolean isInitialized = false;

    TrustManagerFactoryImpl() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void engineInit(KeyStore var1_1) throws KeyStoreException {
        if (var1_1 == null) {
            try {
                this.trustManager = this.getInstance(TrustStoreManager.getTrustedCerts());
            }
            catch (SecurityException var2_2) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("trustmanager")) ** GOTO lbl22
                SSLLogger.fine("SunX509: skip default keystore", new Object[]{var2_2});
            }
            catch (Error var2_3) {
                if (SSLLogger.isOn && SSLLogger.isOn("trustmanager")) {
                    SSLLogger.fine("SunX509: skip default keystore", new Object[]{var2_3});
                }
                throw var2_3;
            }
            catch (RuntimeException var2_4) {
                if (SSLLogger.isOn && SSLLogger.isOn("trustmanager")) {
                    SSLLogger.fine("SunX509: skip default keystor", new Object[]{var2_4});
                }
                throw var2_4;
            }
            catch (Exception var2_5) {
                if (SSLLogger.isOn && SSLLogger.isOn("trustmanager")) {
                    SSLLogger.fine("SunX509: skip default keystore", new Object[]{var2_5});
                }
                throw new KeyStoreException("problem accessing trust store", var2_5);
            }
        } else {
            this.trustManager = this.getInstance(TrustStoreUtil.getTrustedCerts(var1_1));
        }
lbl22:
        // 4 sources

        this.isInitialized = true;
    }

    abstract X509TrustManager getInstance(Collection<X509Certificate> var1);

    abstract X509TrustManager getInstance(ManagerFactoryParameters var1) throws InvalidAlgorithmParameterException;

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.trustManager = this.getInstance(managerFactoryParameters);
        this.isInitialized = true;
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        if (!this.isInitialized) {
            throw new IllegalStateException("TrustManagerFactoryImpl is not initialized");
        }
        return new TrustManager[]{this.trustManager};
    }

    private static FileInputStream getFileInputStream(final File file) throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                try {
                    if (file.exists()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        });
    }

    public static final class PKIXFactory
    extends TrustManagerFactoryImpl {
        @Override
        X509TrustManager getInstance(Collection<X509Certificate> collection) {
            return new X509TrustManagerImpl("PKIX", collection);
        }

        @Override
        X509TrustManager getInstance(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            if (!(managerFactoryParameters instanceof CertPathTrustManagerParameters)) {
                throw new InvalidAlgorithmParameterException("Parameters must be CertPathTrustManagerParameters");
            }
            CertPathParameters certPathParameters = ((CertPathTrustManagerParameters)managerFactoryParameters).getParameters();
            if (!(certPathParameters instanceof PKIXBuilderParameters)) {
                throw new InvalidAlgorithmParameterException("Encapsulated parameters must be PKIXBuilderParameters");
            }
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)certPathParameters;
            return new X509TrustManagerImpl("PKIX", pKIXBuilderParameters);
        }
    }

    public static final class SimpleFactory
    extends TrustManagerFactoryImpl {
        @Override
        X509TrustManager getInstance(Collection<X509Certificate> collection) {
            return new X509TrustManagerImpl("Simple", collection);
        }

        @Override
        X509TrustManager getInstance(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("SunX509 TrustManagerFactory does not use ManagerFactoryParameters");
        }
    }
}

