/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class PNavigationEventHandler
extends PBasicInputEventHandler {
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int IN = 4;
    public static final int OUT = 5;
    private static Hashtable NODE_TO_GLOBAL_NODE_CENTER_MAPPING = new Hashtable();
    private PNode focusNode;
    private PActivity navigationActivity;

    public PNavigationEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    public void keyPressed(PInputEvent pInputEvent) {
        PNode pNode = this.focusNode;
        switch (pInputEvent.getKeyCode()) {
            case 37: {
                this.moveFocusLeft(pInputEvent);
                break;
            }
            case 39: {
                this.moveFocusRight(pInputEvent);
                break;
            }
            case 33: 
            case 38: {
                if (pInputEvent.isAltDown()) {
                    this.moveFocusOut(pInputEvent);
                    break;
                }
                this.moveFocusUp(pInputEvent);
                break;
            }
            case 34: 
            case 40: {
                if (pInputEvent.isAltDown()) {
                    this.moveFocusIn(pInputEvent);
                    break;
                }
                this.moveFocusDown(pInputEvent);
            }
        }
        if (this.focusNode != null && pNode != this.focusNode) {
            this.directCameraViewToFocus(pInputEvent.getCamera(), this.focusNode, 500);
        }
    }

    public void mousePressed(PInputEvent pInputEvent) {
        this.moveFocusToMouseOver(pInputEvent);
        if (this.focusNode != null) {
            this.directCameraViewToFocus(pInputEvent.getCamera(), this.focusNode, 500);
            pInputEvent.getInputManager().setKeyboardFocus(pInputEvent.getPath());
        }
    }

    public void moveFocusDown(PInputEvent pInputEvent) {
        PNode pNode = this.getNeighborInDirection(1);
        if (pNode != null) {
            this.focusNode = pNode;
        }
    }

    public void moveFocusIn(PInputEvent pInputEvent) {
        PNode pNode = this.getNeighborInDirection(4);
        if (pNode != null) {
            this.focusNode = pNode;
        }
    }

    public void moveFocusLeft(PInputEvent pInputEvent) {
        PNode pNode = this.getNeighborInDirection(3);
        if (pNode != null) {
            this.focusNode = pNode;
        }
    }

    public void moveFocusOut(PInputEvent pInputEvent) {
        PNode pNode = this.getNeighborInDirection(5);
        if (pNode != null) {
            this.focusNode = pNode;
        }
    }

    public void moveFocusRight(PInputEvent pInputEvent) {
        PNode pNode = this.getNeighborInDirection(2);
        if (pNode != null) {
            this.focusNode = pNode;
        }
    }

    public void moveFocusUp(PInputEvent pInputEvent) {
        PNode pNode = this.getNeighborInDirection(0);
        if (pNode != null) {
            this.focusNode = pNode;
        }
    }

    public void moveFocusToMouseOver(PInputEvent pInputEvent) {
        PNode pNode = pInputEvent.getPickedNode();
        if (!(pNode instanceof PCamera)) {
            this.focusNode = pNode;
        }
    }

    public PNode getNeighborInDirection(int n) {
        if (this.focusNode == null) {
            return null;
        }
        NODE_TO_GLOBAL_NODE_CENTER_MAPPING.clear();
        Point2D point2D = this.focusNode.getGlobalFullBounds().getCenter2D();
        NODE_TO_GLOBAL_NODE_CENTER_MAPPING.put(this.focusNode, point2D);
        List list = this.getNeighbors();
        this.sortNodesByDistanceFromPoint(list, point2D);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PNode pNode = (PNode)iterator.next();
            if (!this.nodeIsNeighborInDirection(pNode, n)) continue;
            return pNode;
        }
        return null;
    }

    public List getNeighbors() {
        ArrayList<PNode> arrayList = new ArrayList<PNode>();
        if (this.focusNode == null) {
            return arrayList;
        }
        if (this.focusNode.getParent() == null) {
            return arrayList;
        }
        PNode pNode = this.focusNode.getParent();
        ListIterator listIterator = pNode.getChildrenIterator();
        while (listIterator.hasNext()) {
            PNode pNode2 = (PNode)listIterator.next();
            if (pNode2 == this.focusNode || !pNode2.getPickable()) continue;
            arrayList.add(pNode2);
        }
        arrayList.add(pNode);
        listIterator = this.focusNode.getChildrenIterator();
        while (listIterator.hasNext()) {
            arrayList.add((PNode)listIterator.next());
        }
        return arrayList;
    }

    public boolean nodeIsNeighborInDirection(PNode pNode, int n) {
        switch (n) {
            case 4: {
                return pNode.isDescendentOf(this.focusNode);
            }
            case 5: {
                return pNode.isAncestorOf(this.focusNode);
            }
        }
        if (pNode.isAncestorOf(this.focusNode) || pNode.isDescendentOf(this.focusNode)) {
            return false;
        }
        Point2D point2D = (Point2D)NODE_TO_GLOBAL_NODE_CENTER_MAPPING.get(this.focusNode);
        Point2D point2D2 = (Point2D)NODE_TO_GLOBAL_NODE_CENTER_MAPPING.get(pNode);
        double d = point2D2.getX() - point2D.getX() + point2D.getY();
        double d2 = -point2D2.getX() + point2D.getX() + point2D.getY();
        switch (n) {
            case 0: {
                if (!(point2D2.getY() < point2D.getY()) || !(point2D2.getY() < d) || !(point2D2.getY() < d2)) break;
                return true;
            }
            case 2: {
                if (!(point2D2.getX() > point2D.getX()) || !(point2D2.getY() < d) || !(point2D2.getY() > d2)) break;
                return true;
            }
            case 1: {
                if (!(point2D2.getY() > point2D.getY()) || !(point2D2.getY() > d) || !(point2D2.getY() > d2)) break;
                return true;
            }
            case 3: {
                if (!(point2D2.getX() < point2D.getX()) || !(point2D2.getY() > d) || !(point2D2.getY() < d2)) break;
                return true;
            }
        }
        return false;
    }

    public void sortNodesByDistanceFromPoint(List list, final Point2D point2D) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                PNode pNode = (PNode)object;
                PNode pNode2 = (PNode)object2;
                Point2D point2D3 = pNode.getGlobalFullBounds().getCenter2D();
                Point2D point2D2 = pNode2.getGlobalFullBounds().getCenter2D();
                NODE_TO_GLOBAL_NODE_CENTER_MAPPING.put(pNode, point2D3);
                NODE_TO_GLOBAL_NODE_CENTER_MAPPING.put(pNode2, point2D2);
                double d = point2D.distance(point2D3);
                double d2 = point2D.distance(point2D2);
                if (d < d2) {
                    return -1;
                }
                if (d == d2) {
                    return 0;
                }
                return 1;
            }
        });
    }

    protected PActivity animateCameraViewTransformTo(PCamera pCamera, AffineTransform affineTransform, int n) {
        boolean bl = false;
        if (this.navigationActivity != null) {
            this.navigationActivity.terminate();
            bl = true;
        }
        if (n == 0) {
            pCamera.setViewTransform(affineTransform);
            return null;
        }
        PAffineTransform pAffineTransform = pCamera.getViewTransformReference();
        if (!pAffineTransform.equals(affineTransform)) {
            this.navigationActivity = pCamera.animateViewToTransform(affineTransform, n);
            ((PTransformActivity)this.navigationActivity).setSlowInSlowOut(!bl);
            return this.navigationActivity;
        }
        return null;
    }

    public PActivity directCameraViewToFocus(PCamera pCamera, PNode pNode, int n) {
        this.focusNode = pNode;
        PAffineTransform pAffineTransform = pCamera.getViewTransform();
        PDimension pDimension = new PDimension(1.0, 0.0);
        this.focusNode.globalToLocal(pDimension);
        double d = pDimension.getWidth() / pCamera.getViewScale();
        Point2D point2D = this.focusNode.getGlobalFullBounds().getCenter2D();
        if (d != 1.0) {
            pCamera.scaleViewAboutPoint(d, point2D.getX(), point2D.getY());
        }
        pCamera.animateViewToPanToBounds(this.focusNode.getGlobalFullBounds(), 0L);
        PAffineTransform pAffineTransform2 = pCamera.getViewTransform();
        pCamera.setViewTransform(pAffineTransform);
        return this.animateCameraViewTransformTo(pCamera, pAffineTransform2, n);
    }

    protected void fillViewWhiteSpace(PCamera pCamera) {
        PBounds pBounds = pCamera.getRoot().getFullBoundsReference();
        PBounds pBounds2 = pCamera.getViewBounds();
        if (!pBounds.contains(pCamera.getViewBounds())) {
            double d;
            double d2;
            pCamera.animateViewToPanToBounds(pBounds, 0L);
            pCamera.animateViewToPanToBounds(this.focusNode.getGlobalFullBounds(), 0L);
            double d3 = 0.0;
            double d4 = 0.0;
            pBounds2 = pCamera.getViewBounds();
            if (pBounds2.getWidth() > pBounds.getWidth()) {
                d2 = pBounds.getMinX() + pBounds.getWidth() / 2.0;
                d = pBounds2.getMinX() + pBounds2.getWidth() / 2.0;
                d3 = d - d2;
            }
            if (pBounds2.getHeight() > pBounds.getHeight()) {
                d2 = pBounds.getMinY() + pBounds.getHeight() / 2.0;
                d = pBounds2.getMinY() + pBounds2.getHeight() / 2.0;
                d4 = d - d2;
            }
            pCamera.translateView(d3, d4);
        }
    }
}

