/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import java.util.LinkedHashSet;
import java.util.Set;

public class MinMaxContainsValidator
extends BaseKeywordValidator {
    private final Set<Analysis> analysis;

    public MinMaxContainsValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.MAX_CONTAINS, schemaNode, schemaLocation, parentSchema, schemaContext);
        JsonNode maxNode;
        LinkedHashSet<Analysis> analysis = null;
        int min = 1;
        int max = Integer.MAX_VALUE;
        JsonNode minNode = parentSchema.getSchemaNode().get("minContains");
        if (null != minNode) {
            if (!minNode.isNumber() || !minNode.canConvertToExactIntegral() || minNode.intValue() < 0) {
                if (analysis == null) {
                    analysis = new LinkedHashSet<Analysis>();
                }
                analysis.add(new Analysis("minContains", schemaLocation));
            } else {
                min = minNode.intValue();
            }
        }
        if (null != (maxNode = parentSchema.getSchemaNode().get("maxContains"))) {
            if (!maxNode.isNumber() || !maxNode.canConvertToExactIntegral() || maxNode.intValue() < 0) {
                if (analysis == null) {
                    analysis = new LinkedHashSet();
                }
                analysis.add(new Analysis("maxContains", schemaLocation));
            } else {
                max = maxNode.intValue();
            }
        }
        if (max < min) {
            if (analysis == null) {
                analysis = new LinkedHashSet();
            }
            analysis.add(new Analysis("minContainsVsMaxContains", schemaLocation));
        }
        this.analysis = analysis;
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (this.analysis != null) {
            this.analysis.stream().map(analysis -> ((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).messageKey(analysis.getMessageKey())).locale(executionContext.getExecutionConfig().getLocale())).keyword(analysis.getMessageKey())).arguments(this.parentSchema.getSchemaNode().toString())).build()).forEach(executionContext::addError);
        }
    }

    public static class Analysis {
        private final String messageKey;
        private final SchemaLocation schemaLocation;

        public String getMessageKey() {
            return this.messageKey;
        }

        public SchemaLocation getSchemaLocation() {
            return this.schemaLocation;
        }

        public Analysis(String messageKey, SchemaLocation schemaLocation) {
            this.messageKey = messageKey;
            this.schemaLocation = schemaLocation;
        }
    }
}

