/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class UproProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_HEADER = new PatternBuilder().text("*").expression("(..20)").expression("([01])").number("(d+),").expression("(.)").expression("(.)").any().compile();
    private static final Pattern PATTERN_LOCATION = new PatternBuilder().number("(dd)(dd)(dd)").number("(dd)(dd)(dddd)").number("(ddd)(dd)(dddd)").number("(d)").number("(dd)").number("(dd)").number("(dd)(dd)(dd)").compile();

    public UproProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeLocation(Position position, String data) {
        Parser parser = new Parser(PATTERN_LOCATION, data);
        if (parser.matches()) {
            DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN));
            int flags = parser.nextInt(0);
            position.setValid(!BitUtil.check(flags, 0));
            if (!BitUtil.check(flags, 1)) {
                position.setLatitude(-position.getLatitude());
            }
            if (!BitUtil.check(flags, 2)) {
                position.setLongitude(-position.getLongitude());
            }
            position.setSpeed(parser.nextInt(0) * 2);
            position.setCourse(parser.nextInt(0) * 10);
            dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setTime(dateBuilder.getDate());
        }
    }

    private void decodeTransparent(ByteBuf buf, Position position) {
        int dataType = buf.readUnsignedShort();
        int dataLength = buf.readUnsignedShort();
        if (dataType == 16393) {
            position.set("driverUniqueId", buf.readCharSequence(dataLength, StandardCharsets.US_ASCII).toString());
        } else {
            position.set("data", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(dataLength)));
        }
    }

    private void decodeRegular(String head, ByteBuf buf, Position position) {
        Network network = new Network();
        block29: while (buf.readableBytes() > 1) {
            buf.readByte();
            byte dataType = buf.readByte();
            int delimiterIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)38);
            if (delimiterIndex < 0 && (delimiterIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)35)) < 0) {
                delimiterIndex = buf.writerIndex();
            }
            ByteBuf data = buf.readSlice(delimiterIndex - buf.readerIndex());
            int mcc = 0;
            int mnc = 0;
            switch (dataType) {
                case 65: {
                    this.decodeLocation(position, data.toString(StandardCharsets.US_ASCII));
                    break;
                }
                case 66: {
                    int i;
                    String status = data.toString(StandardCharsets.US_ASCII);
                    int[] s = new int[5];
                    for (int i2 = 0; i2 < 5; ++i2) {
                        s[i2] = status.charAt(i2) - 48;
                    }
                    position.set("ignition", BitUtil.check(s[1], 0));
                    int[] a = new int[5];
                    for (i = 0; i < 5; ++i) {
                        a[i] = status.charAt(i + 5) - 48;
                    }
                    position.addAlarm(BitUtil.check(a[0], 0) ? "sos" : null);
                    position.addAlarm(BitUtil.check(a[0], 2) ? "vibration" : null);
                    position.addAlarm(BitUtil.check(a[0], 3) ? "movement" : null);
                    position.addAlarm(BitUtil.check(a[1], 2) ? "overspeed" : null);
                    position.addAlarm(BitUtil.check(a[3], 1) ? "tampering" : null);
                    position.addAlarm(BitUtil.check(a[3], 2) ? "lowPower" : null);
                    position.set("status", status);
                    break;
                }
                case 67: {
                    long odometer = 0L;
                    while (data.isReadable()) {
                        odometer <<= 4;
                        odometer += (long)(data.readByte() - 48);
                    }
                    position.set("odometer", odometer * 2L * 1852L / 3600L);
                    break;
                }
                case 70: {
                    position.setSpeed((double)Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)) * 0.1);
                    break;
                }
                case 71: {
                    position.setAltitude((double)Integer.parseInt(data.readSlice(6).toString(StandardCharsets.US_ASCII)) * 0.1);
                    break;
                }
                case 73: {
                    String stringValue = data.toString(StandardCharsets.US_ASCII);
                    int count = Integer.parseInt(stringValue.substring(0, 1));
                    if (stringValue.length() != 6 + count * 10) break;
                    mcc = Integer.parseInt(stringValue.substring(1, 4));
                    mnc = Integer.parseInt(stringValue.substring(4, 6));
                    for (int i = 0; i < count; ++i) {
                        int offset = 6 + i * 10;
                        network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(stringValue.substring(offset, offset + 4), 16), Integer.parseInt(stringValue.substring(offset + 4, offset + 8), 16), Integer.parseInt(stringValue.substring(offset + 8, offset + 10))));
                    }
                    continue block29;
                }
                case 74: {
                    if (data.readableBytes() != 6) break;
                    char index = (char)data.readUnsignedByte();
                    short status = data.readUnsignedByte();
                    double value = (double)Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)) * 0.1;
                    if (BitUtil.check(status, 0)) {
                        value = -value;
                    }
                    position.set("temp" + index, value);
                    break;
                }
                case 75: {
                    position.set("statusExtended", data.toString(StandardCharsets.US_ASCII));
                    break;
                }
                case 77: {
                    if (data.readableBytes() == 3) {
                        position.set("batteryLevel", (double)Integer.parseInt(data.readSlice(3).toString(StandardCharsets.US_ASCII)) * 0.1);
                        break;
                    }
                    if (data.readableBytes() != 4) break;
                    char index = (char)data.readUnsignedByte();
                    data.readUnsignedByte();
                    position.set("humidity" + index, Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                    break;
                }
                case 78: {
                    position.set("rssi", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                    break;
                }
                case 79: {
                    position.set("sat", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                    break;
                }
                case 80: {
                    if (data.readableBytes() < 16) break;
                    position.setNetwork(new Network(CellTower.from(Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)), Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)), Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII), 16), Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII), 16))));
                    break;
                }
                case 81: {
                    if (head.startsWith("HQ")) break;
                    position.set("obdPid", ByteBufUtil.hexDump((ByteBuf)data));
                    break;
                }
                case 82: {
                    if (head.startsWith("HQ")) {
                        position.set("rssi", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                        position.set("sat", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                        break;
                    }
                    position.set("odbTravel", ByteBufUtil.hexDump((ByteBuf)data));
                    break;
                }
                case 83: {
                    position.set("obdTraffic", ByteBufUtil.hexDump((ByteBuf)data));
                    break;
                }
                case 84: {
                    if (data.readableBytes() != 2) break;
                    position.set("batteryLevel", Integer.parseInt(data.toString(StandardCharsets.US_ASCII)));
                    break;
                }
                case 86: {
                    position.set("power", (double)Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)) * 0.1);
                    break;
                }
                case 87: {
                    int alarms = Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII));
                    position.addAlarm(BitUtil.check(alarms, 2) ? "tampering" : null);
                    break;
                }
                case 88: {
                    int i;
                    String stringData = data.toString(StandardCharsets.US_ASCII);
                    if (stringData.startsWith("(")) {
                        String[] parameters;
                        String[] value = parameters = stringData.substring(1, stringData.length() - 1).split("\\)\\(");
                        i = value.length;
                        block34: for (int j = 0; j < i; ++j) {
                            String parameter = value[j];
                            char type = parameter.charAt(0);
                            String value2 = parameter.substring(1);
                            switch (type) {
                                case 'J': {
                                    position.set("timezone", value2);
                                    continue block34;
                                }
                                case 'k': {
                                    position.set("iccid", value2);
                                }
                            }
                        }
                        continue block29;
                    }
                    String[] cells = stringData.split(";");
                    for (int i3 = 0; i3 < cells.length; ++i3) {
                        String[] values = cells[i3].split(",");
                        int index = 0;
                        if (i3 == 0) {
                            mcc = Integer.parseInt(values[index++]);
                            mnc = Integer.parseInt(values[index++]);
                        }
                        network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(values[index++]), Integer.parseInt(values[index++]), Integer.parseInt(values[index])));
                    }
                    position.setNetwork(network);
                    break;
                }
                case 89: {
                    String stringValue = data.toString(StandardCharsets.US_ASCII);
                    int count = Integer.parseInt(stringValue.substring(0, 1));
                    if (stringValue.length() == 6 + count * 14) {
                        mcc = Integer.parseInt(stringValue.substring(1, 4));
                        mnc = Integer.parseInt(stringValue.substring(4, 6));
                        for (int i = 0; i < count; ++i) {
                            int offset = 6 + i * 14;
                            network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(stringValue.substring(offset, offset + 4), 16), Long.parseLong(stringValue.substring(offset + 4, offset + 12), 16), Integer.parseInt(stringValue.substring(offset + 12, offset + 14), 16)));
                        }
                        continue block29;
                    }
                    position.set("power", (double)Integer.parseInt(data.readSlice(5).toString(StandardCharsets.US_ASCII)) * 0.001);
                    break;
                }
                case 98: {
                    if (data.readableBytes() <= 3) break;
                    position.set("serial", data.toString(StandardCharsets.US_ASCII).substring(3));
                    break;
                }
                case 100: {
                    position.set("adc1", (double)Integer.parseInt(data.toString(StandardCharsets.US_ASCII)) / 100.0);
                    break;
                }
                case 108: {
                    String status = data.toString(StandardCharsets.US_ASCII);
                    int[] s = new int[4];
                    for (int i = 0; i < 4; ++i) {
                        s[i] = status.charAt(i) - 48;
                    }
                    position.set("logisticsLock", BitUtil.to(s[0], 3));
                }
            }
        }
        if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
            position.setNetwork(network);
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        int headerIndex;
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex()) != 42) {
            return null;
        }
        for (headerIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), 44) + 1; headerIndex < buf.writerIndex() && Character.isLetterOrDigit(buf.getByte(headerIndex)); ++headerIndex) {
        }
        String header = buf.readSlice(headerIndex - buf.readerIndex()).toString(StandardCharsets.US_ASCII);
        Parser parser = new Parser(PATTERN_HEADER, header);
        if (!parser.matches()) {
            return null;
        }
        String head = parser.next();
        boolean reply = parser.next().equals("1");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String type = parser.next();
        String subtype = parser.next();
        if (reply && channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("*" + head + "Y" + type + subtype + "#", remoteAddress));
        }
        if (type.equals("G") && subtype.equals("Y")) {
            this.decodeTransparent(buf, position);
        } else {
            this.decodeRegular(head, buf, position);
        }
        if (position.getLatitude() == 0.0 || position.getLongitude() == 0.0) {
            if (position.getAttributes().isEmpty()) {
                return null;
            }
            this.getLastLocation(position, position.getDeviceTime());
        }
        return position;
    }
}

