/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.utilities;

import java.util.Random;

public class PushIdGenerator {
    private static final String PUSH_CHARS = "-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";
    private static final Random randGen = new Random();
    private static final int[] lastRandChars = new int[12];
    private static long lastPushTime = 0L;

    public static synchronized String generatePushChildName(long now) {
        int i;
        boolean duplicateTime = now == lastPushTime;
        lastPushTime = now;
        char[] timeStampChars = new char[8];
        StringBuilder result = new StringBuilder(20);
        for (i = 7; i >= 0; --i) {
            timeStampChars[i] = PUSH_CHARS.charAt((int)(now % 64L));
            now /= 64L;
        }
        assert (now == 0L);
        result.append(timeStampChars);
        if (!duplicateTime) {
            for (i = 0; i < 12; ++i) {
                PushIdGenerator.lastRandChars[i] = randGen.nextInt(64);
            }
        } else {
            PushIdGenerator.incrementArray();
        }
        for (i = 0; i < 12; ++i) {
            result.append(PUSH_CHARS.charAt(lastRandChars[i]));
        }
        assert (result.length() == 20);
        return result.toString();
    }

    private static void incrementArray() {
        for (int i = 11; i >= 0; --i) {
            if (lastRandChars[i] != 63) {
                PushIdGenerator.lastRandChars[i] = lastRandChars[i] + 1;
                return;
            }
            PushIdGenerator.lastRandChars[i] = 0;
        }
    }
}

