/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured.assertion;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CachedFile;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionJwtTemplate;

public class FileAssertionJwtTemplate
implements AssertionJwtTemplate {
    private static final CachedFile.Transformer<CachedJwtTemplate> JSON_TRANSFORMER = (file, json) -> {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(json, Map.class);
            Map header = (Map)map.computeIfAbsent("header", k -> Map.of());
            Map payload = (Map)map.computeIfAbsent("payload", k -> Map.of());
            return new CachedJwtTemplate(header, payload);
        }
        catch (Exception e) {
            throw new KafkaException("An error occurred parsing the OAuth assertion template file from " + file.getPath(), e);
        }
    };
    private final CachedFile<CachedJwtTemplate> jsonFile;

    public FileAssertionJwtTemplate(File jsonFile) {
        this.jsonFile = new CachedFile<CachedJwtTemplate>(jsonFile, JSON_TRANSFORMER, CachedFile.RefreshPolicy.lastModifiedPolicy());
    }

    @Override
    public Map<String, Object> header() {
        return this.jsonFile.transformed().header;
    }

    @Override
    public Map<String, Object> payload() {
        return this.jsonFile.transformed().payload;
    }

    private static class CachedJwtTemplate {
        private final Map<String, Object> header;
        private final Map<String, Object> payload;

        private CachedJwtTemplate(Map<String, Object> header, Map<String, Object> payload) {
            this.header = Collections.unmodifiableMap(header);
            this.payload = Collections.unmodifiableMap(payload);
        }
    }
}

