/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.mutable.Builder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public interface StrictOptimizedIterableOps<A, CC, C>
extends IterableOps<A, CC, C> {
    public static void $init$(StrictOptimizedIterableOps $this) {
    }

    public static Tuple2 partition$(StrictOptimizedIterableOps $this, Function1 p) {
        return $this.partition(p);
    }

    @Override
    default public Tuple2<C, C> partition(Function1<A, Object> p) {
        Builder l = this.newSpecificBuilder();
        Builder r = this.newSpecificBuilder();
        this.iterator().foreach((Function1<Object, Builder> & Serializable)x -> (Builder)(BoxesRunTime.unboxToBoolean(p.apply(x)) ? l : r).$plus$eq(x));
        return Tuple2$.MODULE$.apply(l.result(), r.result());
    }

    public static Tuple2 span$(StrictOptimizedIterableOps $this, Function1 p) {
        return $this.span(p);
    }

    @Override
    default public Tuple2<C, C> span(Function1<A, Object> p) {
        Builder first = this.newSpecificBuilder();
        Builder second = this.newSpecificBuilder();
        Iterator it = this.iterator();
        boolean inFirst = true;
        while (it.hasNext() && inFirst) {
            Object a = it.next();
            if (BoxesRunTime.unboxToBoolean(p.apply(a))) {
                first.$plus$eq(a);
                continue;
            }
            second.$plus$eq(a);
            inFirst = false;
        }
        while (it.hasNext()) {
            second.$plus$eq(it.next());
        }
        return Tuple2$.MODULE$.apply(first.result(), second.result());
    }

    public static Tuple2 unzip$(StrictOptimizedIterableOps $this, Function1 asPair) {
        return $this.unzip(asPair);
    }

    @Override
    default public <A1, A2> Tuple2<CC, CC> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        Builder first = this.iterableFactory().newBuilder();
        Builder second = this.iterableFactory().newBuilder();
        this.foreach((Function1<Object, Builder> & Serializable)a -> {
            Tuple2 pair = (Tuple2)asPair.apply(a);
            first.$plus$eq(pair._1());
            return (Builder)second.$plus$eq(pair._2());
        });
        return Tuple2$.MODULE$.apply(first.result(), second.result());
    }

    public static Tuple3 unzip3$(StrictOptimizedIterableOps $this, Function1 asTriple) {
        return $this.unzip3(asTriple);
    }

    @Override
    default public <A1, A2, A3> Tuple3<CC, CC, CC> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        Builder b1 = this.iterableFactory().newBuilder();
        Builder b2 = this.iterableFactory().newBuilder();
        Builder b3 = this.iterableFactory().newBuilder();
        this.foreach((Function1<Object, Builder> & Serializable)xyz -> {
            Tuple3 triple = (Tuple3)asTriple.apply(xyz);
            b1.$plus$eq(triple._1());
            b2.$plus$eq(triple._2());
            return (Builder)b3.$plus$eq(triple._3());
        });
        return Tuple3$.MODULE$.apply(b1.result(), b2.result(), b3.result());
    }

    public static Object map$(StrictOptimizedIterableOps $this, Function1 f) {
        return $this.map(f);
    }

    @Override
    default public <B> CC map(Function1<A, B> f) {
        return this.strictOptimizedMap(this.iterableFactory().newBuilder(), f);
    }

    public static Object strictOptimizedMap$(StrictOptimizedIterableOps $this, Builder b, Function1 f) {
        return $this.strictOptimizedMap(b, f);
    }

    default public <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            b.$plus$eq(f.apply(it.next()));
        }
        return b.result();
    }

    public static Object flatMap$(StrictOptimizedIterableOps $this, Function1 f) {
        return $this.flatMap(f);
    }

    @Override
    default public <B> CC flatMap(Function1<A, IterableOnce<B>> f) {
        return this.strictOptimizedFlatMap(this.iterableFactory().newBuilder(), f);
    }

    public static Object strictOptimizedFlatMap$(StrictOptimizedIterableOps $this, Builder b, Function1 f) {
        return $this.strictOptimizedFlatMap(b, f);
    }

    default public <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            b.$plus$plus$eq(f.apply(it.next()));
        }
        return b.result();
    }

    public static Object strictOptimizedConcat$(StrictOptimizedIterableOps $this, IterableOnce that, Builder b) {
        return $this.strictOptimizedConcat(that, b);
    }

    default public <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        b.$plus$plus$eq(this);
        b.$plus$plus$eq(that);
        return b.result();
    }

    public static Object collect$(StrictOptimizedIterableOps $this, PartialFunction pf) {
        return $this.collect(pf);
    }

    @Override
    default public <B> CC collect(PartialFunction<A, B> pf) {
        return this.strictOptimizedCollect(this.iterableFactory().newBuilder(), pf);
    }

    public static Object strictOptimizedCollect$(StrictOptimizedIterableOps $this, Builder b, PartialFunction pf) {
        return $this.strictOptimizedCollect(b, pf);
    }

    default public <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        Object marker = Statics.pfMarker;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            Object v = pf.applyOrElse(elem, (Function1<Object, Object> & Serializable)x -> marker);
            if (marker == v) continue;
            b.$plus$eq(v);
        }
        return b.result();
    }

    public static Object flatten$(StrictOptimizedIterableOps $this, Function1 toIterableOnce) {
        return $this.flatten(toIterableOnce);
    }

    @Override
    default public <B> CC flatten(Function1<A, IterableOnce<B>> toIterableOnce) {
        return this.strictOptimizedFlatten(this.iterableFactory().newBuilder(), toIterableOnce);
    }

    public static Object strictOptimizedFlatten$(StrictOptimizedIterableOps $this, Builder b, Function1 toIterableOnce) {
        return $this.strictOptimizedFlatten(b, toIterableOnce);
    }

    default public <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            b.$plus$plus$eq(toIterableOnce.apply(it.next()));
        }
        return b.result();
    }

    public static Object zip$(StrictOptimizedIterableOps $this, IterableOnce that) {
        return $this.zip(that);
    }

    @Override
    default public <B> CC zip(IterableOnce<B> that) {
        return this.strictOptimizedZip(that, this.iterableFactory().newBuilder());
    }

    public static Object strictOptimizedZip$(StrictOptimizedIterableOps $this, IterableOnce that, Builder b) {
        return $this.strictOptimizedZip(that, b);
    }

    default public <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        Iterator it1 = this.iterator();
        Iterator<B> it2 = that.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            b.$plus$eq(Tuple2$.MODULE$.apply(it1.next(), it2.next()));
        }
        return b.result();
    }

    public static Object zipWithIndex$(StrictOptimizedIterableOps $this) {
        return $this.zipWithIndex();
    }

    @Override
    default public CC zipWithIndex() {
        Builder b = this.iterableFactory().newBuilder();
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            b.$plus$eq(Tuple2$.MODULE$.apply(it.next(), BoxesRunTime.boxToInteger(i)));
            ++i;
        }
        return b.result();
    }

    public static Object scanLeft$(StrictOptimizedIterableOps $this, Object z, Function2 op) {
        return $this.scanLeft(z, op);
    }

    @Override
    default public <B> CC scanLeft(B z, Function2<B, A, B> op) {
        Builder b = this.iterableFactory().newBuilder();
        b.sizeHint(this, 0);
        B acc = z;
        b.$plus$eq(acc);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            acc = op.apply(acc, it.next());
            b.$plus$eq(acc);
        }
        return b.result();
    }

    public static Object filter$(StrictOptimizedIterableOps $this, Function1 pred) {
        return $this.filter(pred);
    }

    @Override
    default public C filter(Function1<A, Object> pred) {
        return this.filterImpl(pred, false);
    }

    public static Object filterNot$(StrictOptimizedIterableOps $this, Function1 pred) {
        return $this.filterNot(pred);
    }

    @Override
    default public C filterNot(Function1<A, Object> pred) {
        return this.filterImpl(pred, true);
    }

    public static Object filterImpl$(StrictOptimizedIterableOps $this, Function1 pred, boolean isFlipped) {
        return $this.filterImpl(pred, isFlipped);
    }

    default public C filterImpl(Function1<A, Object> pred, boolean isFlipped) {
        Builder b = this.newSpecificBuilder();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            if (BoxesRunTime.unboxToBoolean(pred.apply(elem)) == isFlipped) continue;
            b.$plus$eq(elem);
        }
        return b.result();
    }

    public static Tuple2 partitionMap$(StrictOptimizedIterableOps $this, Function1 f) {
        return $this.partitionMap(f);
    }

    @Override
    default public <A1, A2> Tuple2<CC, CC> partitionMap(Function1<A, Either<A1, A2>> f) {
        Builder l = this.iterableFactory().newBuilder();
        Builder r = this.iterableFactory().newBuilder();
        this.foreach((Function1<Object, Builder> & Serializable)x -> {
            Either either = (Either)f.apply(x);
            if (either instanceof Left) {
                Left left = (Left)either;
                Object x1 = left.value();
                return (Builder)l.$plus$eq(x1);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Object x2 = right.value();
                return (Builder)r.$plus$eq(x2);
            }
            throw new MatchError(either);
        });
        return Tuple2$.MODULE$.apply(l.result(), r.result());
    }

    public static Object tapEach$(StrictOptimizedIterableOps $this, Function1 f) {
        return $this.tapEach(f);
    }

    @Override
    default public <U> C tapEach(Function1<A, U> f) {
        this.foreach(f);
        return this.coll();
    }

    public static Object takeRight$(StrictOptimizedIterableOps $this, int n) {
        return $this.takeRight(n);
    }

    @Override
    default public C takeRight(int n) {
        Builder b = this.newSpecificBuilder();
        b.sizeHintBounded(n, this.toIterable());
        Iterator lead = this.iterator().drop(n);
        Iterator it = this.iterator();
        while (lead.hasNext()) {
            lead.next();
            it.next();
        }
        while (it.hasNext()) {
            b.$plus$eq(it.next());
        }
        return b.result();
    }

    public static Object dropRight$(StrictOptimizedIterableOps $this, int n) {
        return $this.dropRight(n);
    }

    @Override
    default public C dropRight(int n) {
        Builder b = this.newSpecificBuilder();
        if (n >= 0) {
            b.sizeHint(this, -n);
        }
        Iterator lead = this.iterator().drop(n);
        Iterator it = this.iterator();
        while (lead.hasNext()) {
            b.$plus$eq(it.next());
            lead.next();
        }
        return b.result();
    }
}

