/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist.internal;

import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItem;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.CoreNodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TaskListNodeRenderer
implements NodeRenderer {
    public static final AttributablePart TASK_ITEM_PARAGRAPH = new AttributablePart("TASK_ITEM_PARAGRAPH");
    final String doneMarker;
    final String notDoneMarker;
    private final String tightItemClass;
    private final String looseItemClass;
    private final String itemDoneClass;
    private final String itemNotDoneClass;
    final String paragraphClass;
    private final ListOptions listOptions;

    public TaskListNodeRenderer(DataHolder options) {
        this.doneMarker = (String)TaskListExtension.ITEM_DONE_MARKER.get(options);
        this.notDoneMarker = (String)TaskListExtension.ITEM_NOT_DONE_MARKER.get(options);
        this.tightItemClass = (String)TaskListExtension.TIGHT_ITEM_CLASS.get(options);
        this.looseItemClass = (String)TaskListExtension.LOOSE_ITEM_CLASS.get(options);
        this.itemDoneClass = (String)TaskListExtension.ITEM_DONE_CLASS.get(options);
        this.itemNotDoneClass = (String)TaskListExtension.ITEM_NOT_DONE_CLASS.get(options);
        this.paragraphClass = (String)TaskListExtension.PARAGRAPH_CLASS.get(options);
        this.listOptions = ListOptions.get((DataHolder)options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(TaskListItem.class, this::render));
        return set;
    }

    void render(TaskListItem node, NodeRendererContext context, HtmlWriter html) {
        String itemDoneStatusClass;
        BasedSequence sourceText = context.getHtmlOptions().sourcePositionParagraphLines || node.getFirstChild() == null ? node.getChars() : node.getFirstChild().getChars();
        String string = itemDoneStatusClass = node.isItemDoneMarker() ? this.itemDoneClass : this.itemNotDoneClass;
        if (this.listOptions.isTightListItem((ListItem)node)) {
            if (!this.tightItemClass.isEmpty()) {
                html.attr((CharSequence)"class", (CharSequence)this.tightItemClass);
            }
            if (!itemDoneStatusClass.isEmpty() && !itemDoneStatusClass.equals(this.tightItemClass)) {
                html.attr((CharSequence)"class", (CharSequence)itemDoneStatusClass);
            }
            ((HtmlWriter)html.srcPos(sourceText.getStartOffset(), sourceText.getEndOffset()).withAttr(CoreNodeRenderer.TIGHT_LIST_ITEM).withCondIndent()).tagLine((CharSequence)"li", () -> {
                html.raw((CharSequence)(node.isItemDoneMarker() ? this.doneMarker : this.notDoneMarker));
                context.renderChildren((Node)node);
            });
        } else {
            if (!this.looseItemClass.isEmpty()) {
                html.attr((CharSequence)"class", (CharSequence)this.looseItemClass);
            }
            if (!itemDoneStatusClass.isEmpty() && !itemDoneStatusClass.equals(this.looseItemClass)) {
                html.attr((CharSequence)"class", (CharSequence)itemDoneStatusClass);
            }
            html.withAttr(CoreNodeRenderer.LOOSE_LIST_ITEM).tagIndent((CharSequence)"li", () -> {
                if (!this.paragraphClass.isEmpty()) {
                    html.attr((CharSequence)"class", (CharSequence)this.paragraphClass);
                }
                html.srcPos(sourceText.getStartOffset(), sourceText.getEndOffset()).withAttr(TASK_ITEM_PARAGRAPH).tagLine((CharSequence)"p", () -> {
                    html.raw((CharSequence)(node.isItemDoneMarker() ? this.doneMarker : this.notDoneMarker));
                    context.renderChildren((Node)node);
                });
            });
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new TaskListNodeRenderer(options);
        }
    }
}

