/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.merlin;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.merlin.Row;

class MapRow
implements Row {
    protected Map<String, Object> m_map;
    private static final long TIMESTAMP_EPOCH = 978307200000L;
    private static final long DATE_EPOCH = 978825600000L;

    public MapRow(Map<String, Object> map) {
        this.m_map = map;
    }

    @Override
    public String getString(String string) {
        Object object = this.getObject(string);
        String string2 = object instanceof byte[] ? new String((byte[])object) : (String)object;
        return string2;
    }

    @Override
    public Integer getInteger(String string) {
        Object object = this.getObject(string);
        if (object != null && !(object instanceof Integer)) {
            object = ((Number)object).intValue();
        }
        return (Integer)object;
    }

    @Override
    public Double getDouble(String string) {
        Object object = this.getObject(string);
        if (object != null && !(object instanceof Double)) {
            object = object instanceof byte[] ? Double.valueOf(new String((byte[])object)) : Double.valueOf(((Number)object).doubleValue());
        }
        return (Double)object;
    }

    @Override
    public Double getCurrency(String string) {
        Double d = this.getDouble(string);
        if (d != null) {
            d = d / 100.0;
        }
        return d;
    }

    @Override
    public boolean getBoolean(String string) {
        boolean bl = false;
        Object object = this.getObject(string);
        if (object != null) {
            bl = object instanceof Boolean ? BooleanHelper.getBoolean((Boolean)object) : ((Number)object).intValue() == 1;
        }
        return bl;
    }

    @Override
    public int getInt(String string) {
        return NumberHelper.getInt((Number)this.getObject(string));
    }

    @Override
    public Date getTimestamp(String string) {
        Integer n = this.getInteger(string);
        Date date = n == null ? null : new Date(978307200000L + n.longValue() * 1000L);
        return date;
    }

    @Override
    public Date getDate(String string) {
        Date date;
        Integer n = this.getInteger(string);
        if (n == null) {
            date = null;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(978825600000L);
            calendar.add(6, n);
            date = calendar.getTime();
        }
        return date;
    }

    @Override
    public Duration getDuration(String string) {
        String string2 = this.getString(string);
        Duration duration = string2 == null ? null : this.parseDuration(string2);
        return duration;
    }

    @Override
    public Duration getWork(String string) {
        String string2 = this.getString(string);
        Duration duration = string2 == null ? null : this.parseDuration(string2);
        return duration;
    }

    public Object getObject(String string) {
        Object object = this.m_map.get(string);
        return object;
    }

    @Override
    public UUID getUUID(String string) {
        int n;
        String string2 = this.getString(string);
        string2 = string2.replace("-", "+").replace("_", "/");
        byte[] byArray = DatatypeConverter.parseBase64Binary(string2 + "==");
        long l = 0L;
        long l2 = 0L;
        for (n = 0; n < 8; ++n) {
            l = l << 8 | (long)(byArray[n] & 0xFF);
        }
        for (n = 8; n < 16; ++n) {
            l2 = l2 << 8 | (long)(byArray[n] & 0xFF);
        }
        return new UUID(l, l2);
    }

    @Override
    public RelationType getRelationType(String string) {
        int n = this.getInt(string);
        return switch (n) {
            case 1 -> RelationType.START_START;
            case 2 -> RelationType.FINISH_FINISH;
            case 3 -> RelationType.START_FINISH;
            default -> RelationType.FINISH_START;
        };
    }

    @Override
    public ResourceType getResourceType(String string) {
        Integer n = this.getInteger(string);
        ResourceType resourceType = n == null ? ResourceType.WORK : (n == 1 ? ResourceType.MATERIAL : ResourceType.WORK);
        return resourceType;
    }

    public Map<String, Object> getMap() {
        return this.m_map;
    }

    private Duration parseDuration(String string) {
        TimeUnit timeUnit;
        int n = 1;
        char c = string.charAt(string.length() - n);
        if (c == '?') {
            n = 2;
            c = string.charAt(string.length() - n);
        }
        double d = Double.parseDouble(string.substring(0, string.length() - n));
        switch (c) {
            case 's': {
                timeUnit = TimeUnit.MINUTES;
                d /= 60.0;
                break;
            }
            case 'm': {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case 'h': {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case 'w': {
                timeUnit = TimeUnit.WEEKS;
                break;
            }
            case 'M': {
                timeUnit = TimeUnit.MONTHS;
                break;
            }
            case 'q': {
                timeUnit = TimeUnit.MONTHS;
                d *= 3.0;
                break;
            }
            case 'y': {
                timeUnit = TimeUnit.YEARS;
                break;
            }
            case 'f': {
                timeUnit = TimeUnit.PERCENT;
                break;
            }
            default: {
                timeUnit = TimeUnit.DAYS;
            }
        }
        return Duration.getInstance(d, timeUnit);
    }

    @Override
    public Day getDay(String string) {
        Day day = null;
        Integer n = this.getInteger(string);
        if (n != null) {
            day = Day.getInstance(n + 1);
        }
        return day;
    }
}

