/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 ^ (~ ivec4(-64, 72, 88, -76))) => ivec4(51, -69, -85, 71)
 * (12 ^ (~ ivec4(64, 72, 88, 76))) => ivec4(-77, -69, -85, -65)
 * (12 ^ (~ ivec4(-24, 40, -23, 64))) => ivec4(27, -37, 26, -77)
 * (12 ^ (~ ivec4(24, 40, 23, 64))) => ivec4(-21, -37, -28, -77)
 * (-6 ^ (~ ivec4(-64, 72, 88, -76))) => ivec4(-59, 77, 93, -79)
 * (-6 ^ (~ ivec4(64, 72, 88, 76))) => ivec4(69, 77, 93, 73)
 * (-6 ^ (~ ivec4(-24, 40, -23, 64))) => ivec4(-19, 45, -20, 69)
 * (-6 ^ (~ ivec4(24, 40, 23, 64))) => ivec4(29, 45, 18, 69)
 * (76 ^ (~ ivec4(-64, 72, 88, -76))) => ivec4(115, -5, -21, 7)
 * (76 ^ (~ ivec4(64, 72, 88, 76))) => ivec4(-13, -5, -21, -1)
 * (76 ^ (~ ivec4(-24, 40, -23, 64))) => ivec4(91, -101, 90, -13)
 * (76 ^ (~ ivec4(24, 40, 23, 64))) => ivec4(-85, -101, -92, -13)
 * (-32 ^ (~ ivec4(-64, 72, 88, -76))) => ivec4(-33, 87, 71, -85)
 * (-32 ^ (~ ivec4(64, 72, 88, 76))) => ivec4(95, 87, 71, 83)
 * (-32 ^ (~ ivec4(-24, 40, -23, 64))) => ivec4(-9, 55, -10, 95)
 * (-32 ^ (~ ivec4(24, 40, 23, 64))) => ivec4(7, 55, 8, 95)
 * (0 ^ (~ ivec4(-64, 72, 88, -76))) => ivec4(63, -73, -89, 75)
 * (0 ^ (~ ivec4(64, 72, 88, 76))) => ivec4(-65, -73, -89, -77)
 * (0 ^ (~ ivec4(-24, 40, -23, 64))) => ivec4(23, -41, 22, -65)
 * (0 ^ (~ ivec4(24, 40, 23, 64))) => ivec4(-25, -41, -24, -65)
 */
#version 150

void main()
{
  float[all(equal((12 ^ (~ ivec4(-64, 72, 88, -76))), ivec4(51, -69, -85, 71))) ? 1 : -1] array0;
  float[all(equal((12 ^ (~ ivec4(64, 72, 88, 76))), ivec4(-77, -69, -85, -65))) ? 1 : -1] array1;
  float[all(equal((12 ^ (~ ivec4(-24, 40, -23, 64))), ivec4(27, -37, 26, -77))) ? 1 : -1] array2;
  float[all(equal((12 ^ (~ ivec4(24, 40, 23, 64))), ivec4(-21, -37, -28, -77))) ? 1 : -1] array3;
  float[all(equal((-6 ^ (~ ivec4(-64, 72, 88, -76))), ivec4(-59, 77, 93, -79))) ? 1 : -1] array4;
  float[all(equal((-6 ^ (~ ivec4(64, 72, 88, 76))), ivec4(69, 77, 93, 73))) ? 1 : -1] array5;
  float[all(equal((-6 ^ (~ ivec4(-24, 40, -23, 64))), ivec4(-19, 45, -20, 69))) ? 1 : -1] array6;
  float[all(equal((-6 ^ (~ ivec4(24, 40, 23, 64))), ivec4(29, 45, 18, 69))) ? 1 : -1] array7;
  float[all(equal((76 ^ (~ ivec4(-64, 72, 88, -76))), ivec4(115, -5, -21, 7))) ? 1 : -1] array8;
  float[all(equal((76 ^ (~ ivec4(64, 72, 88, 76))), ivec4(-13, -5, -21, -1))) ? 1 : -1] array9;
  float[all(equal((76 ^ (~ ivec4(-24, 40, -23, 64))), ivec4(91, -101, 90, -13))) ? 1 : -1] array10;
  float[all(equal((76 ^ (~ ivec4(24, 40, 23, 64))), ivec4(-85, -101, -92, -13))) ? 1 : -1] array11;
  float[all(equal((-32 ^ (~ ivec4(-64, 72, 88, -76))), ivec4(-33, 87, 71, -85))) ? 1 : -1] array12;
  float[all(equal((-32 ^ (~ ivec4(64, 72, 88, 76))), ivec4(95, 87, 71, 83))) ? 1 : -1] array13;
  float[all(equal((-32 ^ (~ ivec4(-24, 40, -23, 64))), ivec4(-9, 55, -10, 95))) ? 1 : -1] array14;
  float[all(equal((-32 ^ (~ ivec4(24, 40, 23, 64))), ivec4(7, 55, 8, 95))) ? 1 : -1] array15;
  float[all(equal((0 ^ (~ ivec4(-64, 72, 88, -76))), ivec4(63, -73, -89, 75))) ? 1 : -1] array16;
  float[all(equal((0 ^ (~ ivec4(64, 72, 88, 76))), ivec4(-65, -73, -89, -77))) ? 1 : -1] array17;
  float[all(equal((0 ^ (~ ivec4(-24, 40, -23, 64))), ivec4(23, -41, 22, -65))) ? 1 : -1] array18;
  float[all(equal((0 ^ (~ ivec4(24, 40, 23, 64))), ivec4(-25, -41, -24, -65))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
