/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l >> 0) => 0l
 * (0l >> 1) => 0l
 * (0l >> 2) => 0l
 * (0l >> 5) => 0l
 * (0l >> 25) => 0l
 * (0l >> 31) => 0l
 * (3l >> 0) => 3l
 * (3l >> 1) => 1l
 * (3l >> 2) => 0l
 * (3l >> 5) => 0l
 * (3l >> 25) => 0l
 * (3l >> 31) => 0l
 * (-1192l >> 0) => -1192l
 * (-1192l >> 1) => -596l
 * (-1192l >> 2) => -298l
 * (-1192l >> 5) => -38l
 * (-1192l >> 25) => -1l
 * (-1192l >> 31) => -1l
 * (1048576l >> 0) => 1048576l
 * (1048576l >> 1) => 524288l
 * (1048576l >> 2) => 262144l
 * (1048576l >> 5) => 32768l
 * (1048576l >> 25) => 0l
 * (1048576l >> 31) => 0l
 * (4251475l >> 0) => 4251475l
 * (4251475l >> 1) => 2125737l
 * (4251475l >> 2) => 1062868l
 * (4251475l >> 5) => 132858l
 * (4251475l >> 25) => 0l
 * (4251475l >> 31) => 0l
 * (29852643761l >> 0) => 29852643761l
 * (29852643761l >> 1) => 14926321880l
 * (29852643761l >> 2) => 7463160940l
 * (29852643761l >> 5) => 932895117l
 * (29852643761l >> 25) => 889l
 * (29852643761l >> 31) => 13l
 * (-4398046511104l >> 0) => -4398046511104l
 * (-4398046511104l >> 1) => -2199023255552l
 * (-4398046511104l >> 2) => -1099511627776l
 * (-4398046511104l >> 5) => -137438953472l
 * (-4398046511104l >> 25) => -131072l
 * (-4398046511104l >> 31) => -2048l
 * (-3948976685146l >> 0) => -3948976685146l
 * (-3948976685146l >> 1) => -1974488342573l
 * (-3948976685146l >> 2) => -987244171287l
 * (-3948976685146l >> 5) => -123405521411l
 * (-3948976685146l >> 25) => -117689l
 * (-3948976685146l >> 31) => -1839l
 * (-135763469567146206l >> 0) => -135763469567146206l
 * (-135763469567146206l >> 1) => -67881734783573103l
 * (-135763469567146206l >> 2) => -33940867391786552l
 * (-135763469567146206l >> 5) => -4242608423973319l
 * (-135763469567146206l >> 25) => -4046066689l
 * (-135763469567146206l >> 31) => -63219793l
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[(0l >> 0) == 0l ? 1 : -1] array0;
  float[(0l >> 1) == 0l ? 1 : -1] array1;
  float[(0l >> 2) == 0l ? 1 : -1] array2;
  float[(0l >> 5) == 0l ? 1 : -1] array3;
  float[(0l >> 25) == 0l ? 1 : -1] array4;
  float[(0l >> 31) == 0l ? 1 : -1] array5;
  float[(3l >> 0) == 3l ? 1 : -1] array6;
  float[(3l >> 1) == 1l ? 1 : -1] array7;
  float[(3l >> 2) == 0l ? 1 : -1] array8;
  float[(3l >> 5) == 0l ? 1 : -1] array9;
  float[(3l >> 25) == 0l ? 1 : -1] array10;
  float[(3l >> 31) == 0l ? 1 : -1] array11;
  float[(-1192l >> 0) == -1192l ? 1 : -1] array12;
  float[(-1192l >> 1) == -596l ? 1 : -1] array13;
  float[(-1192l >> 2) == -298l ? 1 : -1] array14;
  float[(-1192l >> 5) == -38l ? 1 : -1] array15;
  float[(-1192l >> 25) == -1l ? 1 : -1] array16;
  float[(-1192l >> 31) == -1l ? 1 : -1] array17;
  float[(1048576l >> 0) == 1048576l ? 1 : -1] array18;
  float[(1048576l >> 1) == 524288l ? 1 : -1] array19;
  float[(1048576l >> 2) == 262144l ? 1 : -1] array20;
  float[(1048576l >> 5) == 32768l ? 1 : -1] array21;
  float[(1048576l >> 25) == 0l ? 1 : -1] array22;
  float[(1048576l >> 31) == 0l ? 1 : -1] array23;
  float[(4251475l >> 0) == 4251475l ? 1 : -1] array24;
  float[(4251475l >> 1) == 2125737l ? 1 : -1] array25;
  float[(4251475l >> 2) == 1062868l ? 1 : -1] array26;
  float[(4251475l >> 5) == 132858l ? 1 : -1] array27;
  float[(4251475l >> 25) == 0l ? 1 : -1] array28;
  float[(4251475l >> 31) == 0l ? 1 : -1] array29;
  float[(29852643761l >> 0) == 29852643761l ? 1 : -1] array30;
  float[(29852643761l >> 1) == 14926321880l ? 1 : -1] array31;
  float[(29852643761l >> 2) == 7463160940l ? 1 : -1] array32;
  float[(29852643761l >> 5) == 932895117l ? 1 : -1] array33;
  float[(29852643761l >> 25) == 889l ? 1 : -1] array34;
  float[(29852643761l >> 31) == 13l ? 1 : -1] array35;
  float[(-4398046511104l >> 0) == -4398046511104l ? 1 : -1] array36;
  float[(-4398046511104l >> 1) == -2199023255552l ? 1 : -1] array37;
  float[(-4398046511104l >> 2) == -1099511627776l ? 1 : -1] array38;
  float[(-4398046511104l >> 5) == -137438953472l ? 1 : -1] array39;
  float[(-4398046511104l >> 25) == -131072l ? 1 : -1] array40;
  float[(-4398046511104l >> 31) == -2048l ? 1 : -1] array41;
  float[(-3948976685146l >> 0) == -3948976685146l ? 1 : -1] array42;
  float[(-3948976685146l >> 1) == -1974488342573l ? 1 : -1] array43;
  float[(-3948976685146l >> 2) == -987244171287l ? 1 : -1] array44;
  float[(-3948976685146l >> 5) == -123405521411l ? 1 : -1] array45;
  float[(-3948976685146l >> 25) == -117689l ? 1 : -1] array46;
  float[(-3948976685146l >> 31) == -1839l ? 1 : -1] array47;
  float[(-135763469567146206l >> 0) == -135763469567146206l ? 1 : -1] array48;
  float[(-135763469567146206l >> 1) == -67881734783573103l ? 1 : -1] array49;
  float[(-135763469567146206l >> 2) == -33940867391786552l ? 1 : -1] array50;
  float[(-135763469567146206l >> 5) == -4242608423973319l ? 1 : -1] array51;
  float[(-135763469567146206l >> 25) == -4046066689l ? 1 : -1] array52;
  float[(-135763469567146206l >> 31) == -63219793l ? 1 : -1] array53;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length() + array40.length() + array41.length() + array42.length() + array43.length() + array44.length() + array45.length() + array46.length() + array47.length() + array48.length() + array49.length() + array50.length() + array51.length() + array52.length() + array53.length());
}
