/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * roundEven(dvec2(-2.0lf, -1.8333333333333333lf)) => dvec2(-2.0lf, -2.0lf)
 * roundEven(dvec2(-1.6666666666666667lf, -1.5lf)) => dvec2(-2.0lf, -2.0lf)
 * roundEven(dvec2(-1.3333333333333335lf, -1.1666666666666667lf)) => dvec2(-1.0lf, -1.0lf)
 * roundEven(dvec2(-1.0lf, -0.8333333333333335lf)) => dvec2(-1.0lf, -1.0lf)
 * roundEven(dvec2(-0.6666666666666667lf, -0.5lf)) => dvec2(-1.0lf, -0.0lf)
 * roundEven(dvec2(-0.3333333333333335lf, -0.16666666666666674lf)) => dvec2(-0.0lf, -0.0lf)
 * roundEven(dvec2(0.0lf, 0.16666666666666652lf)) => dvec2(0.0lf, 0.0lf)
 * roundEven(dvec2(0.33333333333333304lf, 0.5lf)) => dvec2(0.0lf, 0.0lf)
 * roundEven(dvec2(0.6666666666666665lf, 0.833333333333333lf)) => dvec2(1.0lf, 1.0lf)
 * roundEven(dvec2(1.0lf, 1.1666666666666665lf)) => dvec2(1.0lf, 1.0lf)
 * roundEven(dvec2(1.333333333333333lf, 1.5lf)) => dvec2(1.0lf, 2.0lf)
 * roundEven(dvec2(1.6666666666666665lf, 1.833333333333333lf)) => dvec2(2.0lf, 2.0lf)
 * roundEven(dvec2(2.0lf, -2.0lf)) => dvec2(2.0lf, -2.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(roundEven(dvec2(-2.0lf, -1.8333333333333333lf)), dvec2(-2.0lf, -2.0lf)) <= 2.8284271247461902e-05lf ? 1 : -1] array0;
  double[distance(roundEven(dvec2(-1.6666666666666667lf, -1.5lf)), dvec2(-2.0lf, -2.0lf)) <= 2.8284271247461902e-05lf ? 1 : -1] array1;
  double[distance(roundEven(dvec2(-1.3333333333333335lf, -1.1666666666666667lf)), dvec2(-1.0lf, -1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array2;
  double[distance(roundEven(dvec2(-1.0lf, -0.8333333333333335lf)), dvec2(-1.0lf, -1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array3;
  double[distance(roundEven(dvec2(-0.6666666666666667lf, -0.5lf)), dvec2(-1.0lf, -0.0lf)) <= 1e-05lf ? 1 : -1] array4;
  double[distance(roundEven(dvec2(-0.3333333333333335lf, -0.16666666666666674lf)), dvec2(-0.0lf, -0.0lf)) <= 0.0lf ? 1 : -1] array5;
  double[distance(roundEven(dvec2(0.0lf, 0.16666666666666652lf)), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array6;
  double[distance(roundEven(dvec2(0.33333333333333304lf, 0.5lf)), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array7;
  double[distance(roundEven(dvec2(0.6666666666666665lf, 0.833333333333333lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array8;
  double[distance(roundEven(dvec2(1.0lf, 1.1666666666666665lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array9;
  double[distance(roundEven(dvec2(1.333333333333333lf, 1.5lf)), dvec2(1.0lf, 2.0lf)) <= 2.23606797749979e-05lf ? 1 : -1] array10;
  double[distance(roundEven(dvec2(1.6666666666666665lf, 1.833333333333333lf)), dvec2(2.0lf, 2.0lf)) <= 2.8284271247461902e-05lf ? 1 : -1] array11;
  double[distance(roundEven(dvec2(2.0lf, -2.0lf)), dvec2(2.0lf, -2.0lf)) <= 2.8284271247461902e-05lf ? 1 : -1] array12;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length());
}
