/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning.tree;

import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.learning.tree.Split;
import ciir.umass.edu.utilities.MyThreadPool;
import ciir.umass.edu.utilities.WorkerThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class FeatureHistogram {
    public static float samplingRate = 1.0f;
    public float[] accumFeatureImpact = null;
    public int[] features = null;
    public float[][] thresholds = null;
    public double[][] sum = null;
    public double sumResponse = 0.0;
    public double sqSumResponse = 0.0;
    public int[][] count = null;
    public int[][] sampleToThresholdMap = null;
    public double[] impacts;
    private boolean reuseParent = false;

    public void construct(DataPoint[] samples, double[] labels, int[][] sampleSortedIdx, int[] features, float[][] thresholds, double[] impacts) {
        this.features = features;
        this.thresholds = thresholds;
        this.impacts = impacts;
        this.sumResponse = 0.0;
        this.sqSumResponse = 0.0;
        this.sum = new double[features.length][];
        this.count = new int[features.length][];
        this.sampleToThresholdMap = new int[features.length][];
        MyThreadPool p = MyThreadPool.getInstance();
        if (p.size() == 1) {
            this.construct(samples, labels, sampleSortedIdx, thresholds, 0, features.length - 1);
        } else {
            p.execute(new Worker(this, samples, labels, sampleSortedIdx, thresholds), features.length);
        }
    }

    protected void construct(DataPoint[] samples, double[] labels, int[][] sampleSortedIdx, float[][] thresholds, int start, int end) {
        for (int i = start; i <= end; ++i) {
            int fid = this.features[i];
            int[] idx = sampleSortedIdx[i];
            double sumLeft = 0.0;
            float[] threshold = thresholds[i];
            double[] sumLabel = new double[threshold.length];
            int[] c = new int[threshold.length];
            int[] stMap = new int[samples.length];
            int last = -1;
            for (int t = 0; t < threshold.length; ++t) {
                int k;
                int j;
                for (j = last + 1; j < idx.length && !(samples[k = idx[j]].getFeatureValue(fid) > threshold[t]); ++j) {
                    sumLeft += labels[k];
                    if (i == 0) {
                        this.sumResponse += labels[k];
                        this.sqSumResponse += labels[k] * labels[k];
                    }
                    stMap[k] = t;
                }
                last = j - 1;
                sumLabel[t] = sumLeft;
                c[t] = last + 1;
            }
            this.sampleToThresholdMap[i] = stMap;
            this.sum[i] = sumLabel;
            this.count[i] = c;
        }
    }

    protected void update(double[] labels) {
        this.sumResponse = 0.0;
        this.sqSumResponse = 0.0;
        MyThreadPool p = MyThreadPool.getInstance();
        if (p.size() == 1) {
            this.update(labels, 0, this.features.length - 1);
        } else {
            p.execute(new Worker(this, labels), this.features.length);
        }
    }

    protected void update(double[] labels, int start, int end) {
        int f;
        for (f = start; f <= end; ++f) {
            Arrays.fill(this.sum[f], 0.0);
        }
        for (int k = 0; k < labels.length; ++k) {
            for (int f2 = start; f2 <= end; ++f2) {
                int t = this.sampleToThresholdMap[f2][k];
                double[] dArray = this.sum[f2];
                int n = t;
                dArray[n] = dArray[n] + labels[k];
                if (f2 != 0) continue;
                this.sumResponse += labels[k];
                this.sqSumResponse += labels[k] * labels[k];
            }
        }
        for (f = start; f <= end; ++f) {
            for (int t = 1; t < this.thresholds[f].length; ++t) {
                double[] dArray = this.sum[f];
                int n = t;
                dArray[n] = dArray[n] + this.sum[f][t - 1];
            }
        }
    }

    public void construct(FeatureHistogram parent, int[] soi, double[] labels) {
        this.features = parent.features;
        this.thresholds = parent.thresholds;
        this.impacts = parent.impacts;
        this.sumResponse = 0.0;
        this.sqSumResponse = 0.0;
        this.sum = new double[this.features.length][];
        this.count = new int[this.features.length][];
        this.sampleToThresholdMap = parent.sampleToThresholdMap;
        MyThreadPool p = MyThreadPool.getInstance();
        if (p.size() == 1) {
            this.construct(parent, soi, labels, 0, this.features.length - 1);
        } else {
            p.execute(new Worker(this, parent, soi, labels), this.features.length);
        }
    }

    protected void construct(FeatureHistogram parent, int[] soi, double[] labels, int start, int end) {
        int i;
        for (i = start; i <= end; ++i) {
            float[] threshold = this.thresholds[i];
            this.sum[i] = new double[threshold.length];
            this.count[i] = new int[threshold.length];
            Arrays.fill(this.sum[i], 0.0);
            Arrays.fill(this.count[i], 0);
        }
        for (i = 0; i < soi.length; ++i) {
            int k = soi[i];
            for (int f = start; f <= end; ++f) {
                int t = this.sampleToThresholdMap[f][k];
                double[] dArray = this.sum[f];
                int n = t;
                dArray[n] = dArray[n] + labels[k];
                int[] nArray = this.count[f];
                int n2 = t;
                nArray[n2] = nArray[n2] + 1;
                if (f != 0) continue;
                this.sumResponse += labels[k];
                this.sqSumResponse += labels[k] * labels[k];
            }
        }
        for (int f = start; f <= end; ++f) {
            for (int t = 1; t < this.thresholds[f].length; ++t) {
                double[] dArray = this.sum[f];
                int n = t;
                dArray[n] = dArray[n] + this.sum[f][t - 1];
                int[] nArray = this.count[f];
                int n3 = t;
                nArray[n3] = nArray[n3] + this.count[f][t - 1];
            }
        }
    }

    public void construct(FeatureHistogram parent, FeatureHistogram leftSibling, boolean reuseParent) {
        this.reuseParent = reuseParent;
        this.features = parent.features;
        this.thresholds = parent.thresholds;
        this.impacts = parent.impacts;
        this.sumResponse = parent.sumResponse - leftSibling.sumResponse;
        this.sqSumResponse = parent.sqSumResponse - leftSibling.sqSumResponse;
        if (reuseParent) {
            this.sum = parent.sum;
            this.count = parent.count;
        } else {
            this.sum = new double[this.features.length][];
            this.count = new int[this.features.length][];
        }
        this.sampleToThresholdMap = parent.sampleToThresholdMap;
        MyThreadPool p = MyThreadPool.getInstance();
        if (p.size() == 1) {
            this.construct(parent, leftSibling, 0, this.features.length - 1);
        } else {
            p.execute(new Worker(this, parent, leftSibling), this.features.length);
        }
    }

    protected void construct(FeatureHistogram parent, FeatureHistogram leftSibling, int start, int end) {
        for (int f = start; f <= end; ++f) {
            float[] threshold = this.thresholds[f];
            if (!this.reuseParent) {
                this.sum[f] = new double[threshold.length];
                this.count[f] = new int[threshold.length];
            }
            for (int t = 0; t < threshold.length; ++t) {
                this.sum[f][t] = parent.sum[f][t] - leftSibling.sum[f][t];
                this.count[f][t] = parent.count[f][t] - leftSibling.count[f][t];
            }
        }
    }

    protected Config findBestSplit(int[] usedFeatures, int minLeafSupport, int start, int end) {
        Config cfg = new Config();
        int totalCount = this.count[start][this.count[start].length - 1];
        for (int f = start; f <= end; ++f) {
            int i = usedFeatures[f];
            float[] threshold = this.thresholds[i];
            for (int t = 0; t < threshold.length; ++t) {
                int countLeft = this.count[i][t];
                int countRight = totalCount - countLeft;
                if (countLeft < minLeafSupport || countRight < minLeafSupport) continue;
                double sumLeft = this.sum[i][t];
                double sumRight = this.sumResponse - sumLeft;
                double S = sumLeft * sumLeft / (double)countLeft + sumRight * sumRight / (double)countRight;
                double errST = this.sqSumResponse / (double)totalCount * (S / (double)totalCount);
                if (!(cfg.S < S)) continue;
                cfg.S = S;
                cfg.featureIdx = i;
                cfg.thresholdIdx = t;
                cfg.errReduced = errST;
            }
        }
        return cfg;
    }

    public boolean findBestSplit(Split sp, double[] labels, int minLeafSupport) {
        int i;
        if (sp.getDeviance() >= 0.0 && sp.getDeviance() <= 0.0) {
            return false;
        }
        int[] usedFeatures = null;
        if (samplingRate < 1.0f) {
            int size = (int)(samplingRate * (float)this.features.length);
            usedFeatures = new int[size];
            ArrayList<Integer> fpool = new ArrayList<Integer>();
            for (int i2 = 0; i2 < this.features.length; ++i2) {
                fpool.add(i2);
            }
            Random r = new Random();
            for (i = 0; i < size; ++i) {
                int sel = r.nextInt(fpool.size());
                usedFeatures[i] = (Integer)fpool.get(sel);
                fpool.remove(sel);
            }
        } else {
            usedFeatures = new int[this.features.length];
            for (int i3 = 0; i3 < this.features.length; ++i3) {
                usedFeatures[i3] = i3;
            }
        }
        Config best = new Config();
        MyThreadPool p = MyThreadPool.getInstance();
        if (p.size() == 1) {
            best = this.findBestSplit(usedFeatures, minLeafSupport, 0, usedFeatures.length - 1);
        } else {
            WorkerThread[] workers = p.execute(new Worker(this, usedFeatures, minLeafSupport), usedFeatures.length);
            for (i = 0; i < workers.length; ++i) {
                Worker wk = (Worker)workers[i];
                if (!(best.S < wk.cfg.S)) continue;
                best = wk.cfg;
            }
        }
        if (best.S == -1.0) {
            return false;
        }
        double[] bestFeaturesHist = this.sum[best.featureIdx];
        int[] sampleCount = this.count[best.featureIdx];
        double s = bestFeaturesHist[bestFeaturesHist.length - 1];
        int c = sampleCount[bestFeaturesHist.length - 1];
        double sumLeft = bestFeaturesHist[best.thresholdIdx];
        int countLeft = sampleCount[best.thresholdIdx];
        double sumRight = s - sumLeft;
        int countRight = c - countLeft;
        int[] left = new int[countLeft];
        int[] right = new int[countRight];
        int l = 0;
        int r = 0;
        int k = 0;
        int[] idx = sp.getSamples();
        for (int j = 0; j < idx.length; ++j) {
            k = idx[j];
            if (this.sampleToThresholdMap[best.featureIdx][k] <= best.thresholdIdx) {
                left[l++] = k;
                continue;
            }
            right[r++] = k;
        }
        int n = best.featureIdx;
        this.impacts[n] = this.impacts[n] + best.errReduced;
        FeatureHistogram lh = new FeatureHistogram();
        lh.construct(sp.hist, left, labels);
        FeatureHistogram rh = new FeatureHistogram();
        rh.construct(sp.hist, lh, !sp.isRoot());
        double var = this.sqSumResponse - this.sumResponse * this.sumResponse / (double)idx.length;
        double varLeft = lh.sqSumResponse - lh.sumResponse * lh.sumResponse / (double)left.length;
        double varRight = rh.sqSumResponse - rh.sumResponse * rh.sumResponse / (double)right.length;
        sp.set(this.features[best.featureIdx], this.thresholds[best.featureIdx][best.thresholdIdx], var);
        sp.setLeft(new Split(left, lh, varLeft, sumLeft));
        sp.setRight(new Split(right, rh, varRight, sumRight));
        sp.clearSamples();
        return true;
    }

    class Worker
    extends WorkerThread {
        FeatureHistogram fh = null;
        int type = -1;
        int[] usedFeatures = null;
        int minLeafSup = -1;
        Config cfg = null;
        double[] labels = null;
        FeatureHistogram parent = null;
        int[] soi = null;
        FeatureHistogram leftSibling = null;
        DataPoint[] samples;
        int[][] sampleSortedIdx;
        float[][] thresholds;

        public Worker() {
        }

        public Worker(FeatureHistogram fh, int[] usedFeatures, int minLeafSup) {
            this.type = 0;
            this.fh = fh;
            this.usedFeatures = usedFeatures;
            this.minLeafSup = minLeafSup;
        }

        public Worker(FeatureHistogram fh, double[] labels) {
            this.type = 1;
            this.fh = fh;
            this.labels = labels;
        }

        public Worker(FeatureHistogram fh, FeatureHistogram parent, int[] soi, double[] labels) {
            this.type = 2;
            this.fh = fh;
            this.parent = parent;
            this.soi = soi;
            this.labels = labels;
        }

        public Worker(FeatureHistogram fh, FeatureHistogram parent, FeatureHistogram leftSibling) {
            this.type = 3;
            this.fh = fh;
            this.parent = parent;
            this.leftSibling = leftSibling;
        }

        public Worker(FeatureHistogram fh, DataPoint[] samples, double[] labels, int[][] sampleSortedIdx, float[][] thresholds) {
            this.type = 4;
            this.fh = fh;
            this.samples = samples;
            this.labels = labels;
            this.sampleSortedIdx = sampleSortedIdx;
            this.thresholds = thresholds;
        }

        @Override
        public void run() {
            if (this.type == 0) {
                this.cfg = this.fh.findBestSplit(this.usedFeatures, this.minLeafSup, this.start, this.end);
            } else if (this.type == 1) {
                this.fh.update(this.labels, this.start, this.end);
            } else if (this.type == 2) {
                this.fh.construct(this.parent, this.soi, this.labels, this.start, this.end);
            } else if (this.type == 3) {
                this.fh.construct(this.parent, this.leftSibling, this.start, this.end);
            } else if (this.type == 4) {
                this.fh.construct(this.samples, this.labels, this.sampleSortedIdx, this.thresholds, this.start, this.end);
            }
        }

        @Override
        public WorkerThread clone() {
            Worker wk = new Worker();
            wk.fh = this.fh;
            wk.type = this.type;
            wk.usedFeatures = this.usedFeatures;
            wk.minLeafSup = this.minLeafSup;
            wk.labels = this.labels;
            wk.parent = this.parent;
            wk.soi = this.soi;
            wk.leftSibling = this.leftSibling;
            wk.samples = this.samples;
            wk.sampleSortedIdx = this.sampleSortedIdx;
            wk.thresholds = this.thresholds;
            return wk;
        }
    }

    class Config {
        int featureIdx = -1;
        int thresholdIdx = -1;
        double S = -1.0;
        double errReduced = -1.0;

        Config() {
        }
    }
}

