/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class ECCPublicKey {
    private final ByteBuffer der;

    protected ECCPublicKey(BuilderImpl builder) {
        this.der = builder.der();
    }

    public ByteBuffer der() {
        return this.der;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer der;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ECCPublicKey model) {
            this.der = model.der();
        }

        @Override
        public Builder der(ByteBuffer der) {
            this.der = der;
            return this;
        }

        @Override
        public ByteBuffer der() {
            return this.der;
        }

        @Override
        public ECCPublicKey build() {
            if (Objects.isNull(this.der())) {
                throw new IllegalArgumentException("Missing value for required field `der`");
            }
            return new ECCPublicKey(this);
        }
    }

    public static interface Builder {
        public Builder der(ByteBuffer var1);

        public ByteBuffer der();

        public ECCPublicKey build();
    }
}

