/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.runtime.Field;
import io.protostuff.runtime.FieldMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ArrayFieldMap<T>
implements FieldMap<T> {
    private final List<Field<T>> fields;
    private final Field<T>[] fieldsByNumber;
    private final Map<String, Field<T>> fieldsByName = new HashMap<String, Field<T>>();

    public ArrayFieldMap(Collection<Field<T>> fields, int lastFieldNumber) {
        this.fieldsByNumber = new Field[lastFieldNumber + 1];
        for (Field<T> f : fields) {
            Field<T> last = this.fieldsByName.put(f.name, f);
            if (last != null) {
                throw new IllegalStateException(last + " and " + f + " cannot have the same name.");
            }
            if (this.fieldsByNumber[f.number] != null) {
                throw new IllegalStateException("Fields '" + this.fieldsByNumber[f.number].name + "' " + this.fieldsByNumber[f.number] + " and '" + f.name + "' " + f + " cannot have the same number: " + f.number);
            }
            this.fieldsByNumber[f.number] = f;
        }
        ArrayList<Field<T>> fieldList = new ArrayList<Field<T>>(fields.size());
        for (Field<T> field : this.fieldsByNumber) {
            if (field == null) continue;
            fieldList.add(field);
        }
        this.fields = Collections.unmodifiableList(fieldList);
    }

    @Override
    public Field<T> getFieldByNumber(int n) {
        return n < this.fieldsByNumber.length ? this.fieldsByNumber[n] : null;
    }

    @Override
    public Field<T> getFieldByName(String fieldName) {
        return this.fieldsByName.get(fieldName);
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public List<Field<T>> getFields() {
        return this.fields;
    }
}

