/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest;

import java.util.Locale;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.indices.pollingingest.BlockIngestionErrorStrategy;
import org.opensearch.indices.pollingingest.DropIngestionErrorStrategy;

@ExperimentalApi
public interface IngestionErrorStrategy {
    public void handleError(Throwable var1, ErrorStage var2);

    public boolean shouldIgnoreError(Throwable var1, ErrorStage var2);

    public static IngestionErrorStrategy create(ErrorStrategy errorStrategy, String ingestionSource) {
        switch (errorStrategy.ordinal()) {
            case 1: {
                return new BlockIngestionErrorStrategy(ingestionSource);
            }
        }
        return new DropIngestionErrorStrategy(ingestionSource);
    }

    public String getName();

    @ExperimentalApi
    public static enum ErrorStrategy {
        DROP,
        BLOCK;


        public static ErrorStrategy parseFromString(String errorStrategy) {
            try {
                return ErrorStrategy.valueOf(errorStrategy.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid ingestion errorStrategy: " + errorStrategy, e);
            }
        }
    }

    @ExperimentalApi
    public static enum ErrorStage {
        POLLING,
        PROCESSING;

    }
}

