/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.security.privileges.ExpressionEvaluationException;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.support.WildcardMatcher;

public class IndexPattern {
    private static final Logger log = LogManager.getLogger(IndexPattern.class);
    public static final IndexPattern EMPTY = new IndexPattern(WildcardMatcher.NONE, (ImmutableList<String>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of());
    private final WildcardMatcher staticPattern;
    private final ImmutableList<String> patternTemplates;
    private final ImmutableList<String> dateMathExpressions;
    private final int hashCode;

    private IndexPattern(WildcardMatcher staticPattern, ImmutableList<String> patternTemplates, ImmutableList<String> dateMathExpressions) {
        this.staticPattern = staticPattern;
        this.patternTemplates = patternTemplates;
        this.dateMathExpressions = dateMathExpressions;
        this.hashCode = staticPattern.hashCode() + patternTemplates.hashCode() + dateMathExpressions.hashCode();
    }

    public boolean matches(String index, PrivilegesEvaluationContext context, Map<String, IndexAbstraction> indexMetadata) throws PrivilegesEvaluationException {
        IndexAbstraction indexAbstraction;
        if (this.staticPattern != WildcardMatcher.NONE && this.staticPattern.test(index)) {
            return true;
        }
        if (!this.patternTemplates.isEmpty()) {
            for (String patternTemplate : this.patternTemplates) {
                try {
                    WildcardMatcher matcher = context.getRenderedMatcher(patternTemplate);
                    if (!matcher.test(index)) continue;
                    return true;
                }
                catch (ExpressionEvaluationException e) {
                    throw new PrivilegesEvaluationException("Error while evaluating dynamic index pattern: " + patternTemplate, e);
                }
            }
        }
        if (!this.dateMathExpressions.isEmpty()) {
            IndexNameExpressionResolver indexNameExpressionResolver = context.getIndexNameExpressionResolver();
            for (String dateMathExpression : this.dateMathExpressions) {
                try {
                    String resolvedExpression = indexNameExpressionResolver.resolveDateMathExpression(dateMathExpression);
                    WildcardMatcher matcher = WildcardMatcher.from(resolvedExpression);
                    if (!matcher.test(index)) continue;
                    return true;
                }
                catch (Exception e) {
                    throw new PrivilegesEvaluationException("Error while evaluating date math expression: " + dateMathExpression, e);
                }
            }
        }
        if ((indexAbstraction = indexMetadata.get(index)) instanceof IndexAbstraction.Index) {
            if (indexAbstraction.getParentDataStream() != null && this.matches(indexAbstraction.getParentDataStream().getName(), context, indexMetadata)) {
                return true;
            }
            for (String alias : indexAbstraction.getWriteIndex().getAliases().keySet()) {
                if (!this.matches(alias, context, indexMetadata)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.patternTemplates.size() == 0 && this.dateMathExpressions.size() == 0) {
            return this.staticPattern.toString();
        }
        StringBuilder result = new StringBuilder();
        if (this.staticPattern != WildcardMatcher.NONE) {
            result.append(this.staticPattern);
        }
        if (this.patternTemplates.size() != 0) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append(String.join((CharSequence)",", this.patternTemplates));
        }
        if (this.dateMathExpressions.size() != 0) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append(String.join((CharSequence)",", this.dateMathExpressions));
        }
        return result.toString();
    }

    public WildcardMatcher getStaticPattern() {
        return this.staticPattern;
    }

    public boolean hasStaticPattern() {
        return this.staticPattern != WildcardMatcher.NONE;
    }

    public boolean hasDynamicPattern() {
        return !this.patternTemplates.isEmpty() || !this.dateMathExpressions.isEmpty();
    }

    public IndexPattern dynamicOnly() {
        if (this.patternTemplates.isEmpty() && this.dateMathExpressions.isEmpty()) {
            return EMPTY;
        }
        return new IndexPattern(WildcardMatcher.NONE, this.patternTemplates, this.dateMathExpressions);
    }

    public boolean isEmpty() {
        return !this.hasStaticPattern() && !this.hasDynamicPattern();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexPattern)) {
            return false;
        }
        IndexPattern that = (IndexPattern)o;
        return Objects.equals(this.staticPattern, that.staticPattern) && Objects.equals(this.patternTemplates, that.patternTemplates) && Objects.equals(this.dateMathExpressions, that.dateMathExpressions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    static boolean containsPlaceholder(String indexPattern) {
        return indexPattern.indexOf("${") != -1;
    }

    public static IndexPattern from(List<String> source) {
        Builder builder = new Builder();
        builder.add(source);
        return builder.build();
    }

    public static IndexPattern from(String ... source) {
        return IndexPattern.from(Arrays.asList(source));
    }

    public static class Builder {
        private List<WildcardMatcher> constantPatterns = new ArrayList<WildcardMatcher>();
        private List<String> patternTemplates = new ArrayList<String>();
        private List<String> dateMathExpressions = new ArrayList<String>();

        public void add(List<String> source) {
            for (int i = 0; i < source.size(); ++i) {
                try {
                    String indexPattern = source.get(i);
                    if (indexPattern.startsWith("<") && indexPattern.endsWith(">")) {
                        this.dateMathExpressions.add(indexPattern);
                        continue;
                    }
                    if (!IndexPattern.containsPlaceholder(indexPattern)) {
                        this.constantPatterns.add(WildcardMatcher.from(indexPattern));
                        continue;
                    }
                    this.patternTemplates.add(indexPattern);
                    continue;
                }
                catch (Exception e) {
                    log.error("Error while creating index pattern for {}", source, (Object)e);
                }
            }
        }

        public IndexPattern build() {
            return new IndexPattern(this.constantPatterns.size() != 0 ? WildcardMatcher.from(this.constantPatterns) : WildcardMatcher.NONE, (ImmutableList<String>)ImmutableList.copyOf(this.patternTemplates), (ImmutableList<String>)ImmutableList.copyOf(this.dateMathExpressions));
        }
    }
}

