/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.breaker;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Optional;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.ml.breaker.ThresholdCircuitBreaker;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.settings.MLCommonsSettings;

public class DiskCircuitBreaker
extends ThresholdCircuitBreaker<ByteSizeValue> {
    private static final String ML_DISK_CB = "Disk Circuit Breaker";
    public static final ByteSizeValue DEFAULT_DISK_SHORTAGE_THRESHOLD = new ByteSizeValue(5L, ByteSizeUnit.GB);
    private final File diskDir;

    public DiskCircuitBreaker(Settings settings, ClusterService clusterService, File diskDir) {
        super(Optional.ofNullable((ByteSizeValue)MLCommonsSettings.ML_COMMONS_DISK_FREE_SPACE_THRESHOLD.get(settings)).orElse(DEFAULT_DISK_SHORTAGE_THRESHOLD));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_DISK_FREE_SPACE_THRESHOLD, x$0 -> super.setThreshold(x$0));
        this.diskDir = diskDir;
    }

    @Override
    public String getName() {
        return ML_DISK_CB;
    }

    @Override
    public boolean isOpen() {
        try {
            return AccessController.doPrivileged(() -> new ByteSizeValue(this.diskDir.getFreeSpace(), ByteSizeUnit.BYTES).compareTo((ByteSizeValue)this.getThreshold()) < 0);
        }
        catch (PrivilegedActionException e) {
            throw new MLException("Failed to run disk circuit breaker");
        }
    }
}

