/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.executors;

import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.lucene.search.TaskExecutor;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;

public final class HybridQueryExecutor {
    private static final String HYBRID_QUERY_EXEC_THREAD_POOL_NAME = "_plugin_neural_search_hybrid_query_executor";
    private static final Integer HYBRID_QUERY_EXEC_THREAD_POOL_QUEUE_SIZE = 1000;
    private static final Integer MAX_THREAD_SIZE = 1000;
    private static final Integer MIN_THREAD_SIZE = 2;
    private static final Integer PROCESSOR_COUNT_MULTIPLIER = 2;
    private static TaskExecutor taskExecutor;

    public static ExecutorBuilder getExecutorBuilder(Settings settings) {
        int numberOfThreads = HybridQueryExecutor.getFixedNumberOfThreadSize(settings);
        return new FixedExecutorBuilder(settings, HYBRID_QUERY_EXEC_THREAD_POOL_NAME, numberOfThreads, HYBRID_QUERY_EXEC_THREAD_POOL_QUEUE_SIZE.intValue(), HYBRID_QUERY_EXEC_THREAD_POOL_NAME);
    }

    public static void initialize(ThreadPool threadPool) {
        if (threadPool == null) {
            throw new IllegalArgumentException("Argument thread-pool to Hybrid Query Executor cannot be null. This is required to build executor to run actions in parallel");
        }
        taskExecutor = new TaskExecutor((Executor)threadPool.executor(HYBRID_QUERY_EXEC_THREAD_POOL_NAME));
    }

    public static TaskExecutor getExecutor() {
        return taskExecutor != null ? taskExecutor : new TaskExecutor(Runnable::run);
    }

    public static String getThreadPoolName() {
        return HYBRID_QUERY_EXEC_THREAD_POOL_NAME;
    }

    private static int getFixedNumberOfThreadSize(Settings settings) {
        int allocatedProcessors = OpenSearchExecutors.allocatedProcessors((Settings)settings);
        int threadSize = Math.max(PROCESSOR_COUNT_MULTIPLIER * allocatedProcessors, MIN_THREAD_SIZE);
        return Math.min(threadSize, MAX_THREAD_SIZE);
    }

    @Generated
    private HybridQueryExecutor() {
    }
}

