/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.processors.field;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tribuo.Feature;
import org.tribuo.data.columnar.ColumnarFeature;
import org.tribuo.data.columnar.FieldProcessor;
import org.tribuo.data.text.TextPipeline;

public class TextFieldProcessor
implements FieldProcessor {
    @Config(mandatory=true, description="The field name to read.")
    private String fieldName;
    @Config(mandatory=true, description="Text processing pipeline to use.")
    private TextPipeline pipeline;

    public TextFieldProcessor(String fieldName, TextPipeline pipeline) {
        this.fieldName = fieldName;
        this.pipeline = pipeline;
    }

    private TextFieldProcessor() {
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<ColumnarFeature> process(String value) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        return TextFieldProcessor.wrapFeatures(this.fieldName, this.pipeline.process("", value));
    }

    @Override
    public FieldProcessor.GeneratedFeatureType getFeatureType() {
        return FieldProcessor.GeneratedFeatureType.TEXT;
    }

    @Override
    public TextFieldProcessor copy(String newFieldName) {
        return new TextFieldProcessor(newFieldName, this.pipeline);
    }

    public static List<ColumnarFeature> wrapFeatures(String fieldName, List<Feature> inputFeatures) {
        if (inputFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ColumnarFeature> list = new ArrayList<ColumnarFeature>();
        for (Feature f : inputFeatures) {
            ColumnarFeature newF = new ColumnarFeature(fieldName, f.getName(), f.getValue());
            list.add(newF);
        }
        return list;
    }

    public String toString() {
        return "TextFieldProcessor(fieldName=" + this.getFieldName() + ",textPipeline=" + this.pipeline.toString() + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FieldProcessor");
    }
}

