/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazyMap;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.core.xml.XMLObject;

@NotThreadSafe
public class IDIndex {
    @Nonnull
    private final XMLObject owner;
    @Nonnull
    private Map<String, XMLObject> idMappings;

    public IDIndex(@Nonnull XMLObject newOwner) {
        Constraint.isNotNull(newOwner, "ID-owning XMLObject may not be null");
        this.owner = newOwner;
        this.idMappings = new LazyMap<String, XMLObject>();
    }

    public void registerIDMapping(@Nonnull @NotEmpty String id, @Nonnull XMLObject referent) {
        this.idMappings.put(id, referent);
        if (this.owner.hasParent()) {
            XMLObject parent = this.owner.getParent();
            assert (parent != null);
            parent.getIDIndex().registerIDMapping(id, referent);
        }
    }

    public void registerIDMappings(@Nonnull IDIndex idIndex) {
        if (idIndex == null || idIndex.isEmpty()) {
            return;
        }
        this.idMappings.putAll(idIndex.getIDMappings());
        if (this.owner.hasParent()) {
            XMLObject parent = this.owner.getParent();
            assert (parent != null);
            parent.getIDIndex().registerIDMappings(idIndex);
        }
    }

    public void deregisterIDMapping(@Nonnull @NotEmpty String id) {
        this.idMappings.remove(id);
        if (this.owner.hasParent()) {
            XMLObject parent = this.owner.getParent();
            assert (parent != null);
            parent.getIDIndex().deregisterIDMapping(id);
        }
    }

    public void deregisterIDMappings(@Nonnull IDIndex idIndex) {
        if (idIndex == null || idIndex.isEmpty()) {
            return;
        }
        for (String id : idIndex.getIDs()) {
            this.idMappings.remove(id);
        }
        if (this.owner.hasParent()) {
            XMLObject parent = this.owner.getParent();
            assert (parent != null);
            parent.getIDIndex().deregisterIDMappings(idIndex);
        }
    }

    @Nullable
    public XMLObject lookup(@Nonnull @NotEmpty String id) {
        return this.idMappings.get(id);
    }

    public boolean isEmpty() {
        return this.idMappings.isEmpty();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getIDs() {
        return CollectionSupport.copyToSet(this.idMappings.keySet());
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Map<String, XMLObject> getIDMappings() {
        return CollectionSupport.copyToMap(this.idMappings);
    }
}

