/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.util.Map;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.pipeline.common.BasicMap;
import org.opensearch.search.pipeline.common.SearchRequestMapProcessingException;

class SearchRequestMap
extends BasicMap
implements Map<String, Object> {
    private final SearchSourceBuilder source;

    public SearchRequestMap(SearchRequest searchRequest) {
        this.source = searchRequest.source();
    }

    @Override
    public boolean isEmpty() {
        return this.source == null;
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        switch ((String)key) {
            case "from": {
                return this.source.from();
            }
            case "size": {
                return this.source.size();
            }
            case "explain": {
                return this.source.explain();
            }
            case "version": {
                return this.source.version();
            }
            case "seq_no_primary_term": {
                return this.source.seqNoAndPrimaryTerm();
            }
            case "track_scores": {
                return this.source.trackScores();
            }
            case "track_total_hits": {
                return this.source.trackTotalHitsUpTo();
            }
            case "min_score": {
                return this.source.minScore();
            }
            case "terminate_after": {
                return this.source.terminateAfter();
            }
            case "profile": {
                return this.source.profile();
            }
        }
        throw new SearchRequestMapProcessingException("Unsupported key: " + String.valueOf(key), new Object[0]);
    }

    @Override
    public Object put(String key, Object value) {
        Object originalValue = this.get(key);
        try {
            switch (key) {
                case "from": {
                    this.source.from(((Integer)value).intValue());
                    break;
                }
                case "size": {
                    this.source.size(((Integer)value).intValue());
                    break;
                }
                case "explain": {
                    this.source.explain((Boolean)value);
                    break;
                }
                case "version": {
                    this.source.version((Boolean)value);
                    break;
                }
                case "seq_no_primary_term": {
                    this.source.seqNoAndPrimaryTerm((Boolean)value);
                    break;
                }
                case "track_scores": {
                    this.source.trackScores(((Boolean)value).booleanValue());
                    break;
                }
                case "track_total_hits": {
                    this.source.trackTotalHitsUpTo(((Integer)value).intValue());
                    break;
                }
                case "min_score": {
                    this.source.minScore(((Float)value).floatValue());
                    break;
                }
                case "terminate_after": {
                    this.source.terminateAfter(((Integer)value).intValue());
                    break;
                }
                case "profile": {
                    this.source.profile(((Boolean)value).booleanValue());
                    break;
                }
                default: {
                    throw new SearchRequestMapProcessingException("Unsupported SearchRequest source property: " + key, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new SearchRequestMapProcessingException("Error while setting value for SearchRequest source property: " + key, e, new Object[0]);
        }
        return originalValue;
    }
}

