/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.resource;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.resource.SchemaMapper;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class MapSchemaMapper
implements SchemaMapper {
    private final Function<String, String> mappings;

    public MapSchemaMapper(Map<String, String> mappings) {
        this(mappings::get);
    }

    public MapSchemaMapper(Function<String, String> mappings) {
        this.mappings = mappings;
    }

    public MapSchemaMapper(Predicate<String> test, Function<String, String> mappings) {
        this.mappings = iri -> {
            if (test.test((String)iri)) {
                return (String)mappings.apply((String)iri);
            }
            return null;
        };
    }

    @Override
    public AbsoluteIri map(AbsoluteIri absoluteIRI) {
        String mapped = this.mappings.apply(absoluteIRI.toString());
        if (mapped != null) {
            return AbsoluteIri.of(mapped);
        }
        return null;
    }
}

