/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.engine;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.LineAndColumn;

public final class ScriptError {
    private final int column;
    private final int length;
    private final int line;
    private final String message;

    public ScriptError(String message, int line, int column, int length) {
        this.message = message;
        this.line = line;
        this.column = column;
        this.length = length;
    }

    public ScriptError(String message, EObject atEObject) {
        this.message = message;
        ICompositeNode node = NodeModelUtils.getNode((EObject)atEObject);
        if (node == null) {
            this.line = 0;
            this.column = 0;
            this.length = -1;
        } else {
            LineAndColumn lac = NodeModelUtils.getLineAndColumn((INode)node, (int)node.getOffset());
            this.line = lac.getLine();
            this.column = lac.getColumn();
            this.length = node.getEndOffset() - node.getOffset();
        }
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder(this.message);
        if (this.line != -1) {
            sb.append("; line ");
            sb.append(this.line);
        }
        if (this.column != -1) {
            sb.append(", column ");
            sb.append(this.column);
        }
        if (this.length != -1) {
            sb.append(", length ");
            sb.append(this.length);
        }
        return sb.toString();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }
}

