/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtext.mwe.AbstractReader;
import org.eclipse.xtext.mwe.ContainersStateFactory;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.mwe.UriFilter;
import org.eclipse.xtext.resource.containers.DelegatingIAllContainerAdapter;
import org.eclipse.xtext.resource.containers.IAllContainersState;

public class Reader
extends AbstractReader {
    protected static final Logger log = Logger.getLogger((String)Reader.class.getName());
    protected List<String> pathes = Lists.newArrayList();
    private UriFilter filter;
    private ContainersStateFactory containersStateFactory = new ContainersStateFactory();

    public void addPath(String path) {
        String[] stringArray = path.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.pathes.add(p.trim());
            ++n2;
        }
    }

    public List<String> getPathes() {
        return this.pathes;
    }

    public void setUseJavaClassPath(boolean isUse) {
        if (isUse) {
            String[] strings;
            String classPath = System.getProperty("java.class.path");
            String separator = System.getProperty("path.separator");
            String[] stringArray = strings = classPath.split(separator);
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.addPath(path);
                ++n2;
            }
        }
    }

    public void setUriFilter(UriFilter filter) {
        this.filter = filter;
    }

    public UriFilter getUriFilter() {
        return this.filter;
    }

    public void setContainersStateFactory(ContainersStateFactory containersStateFactory) {
        this.containersStateFactory = containersStateFactory;
    }

    public ContainersStateFactory getContainersStateFactory() {
        return this.containersStateFactory;
    }

    @Override
    protected void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this.pathes.isEmpty()) {
            issues.addWarning("No path set, using java class path entries (useJavaClassPath='true').");
            this.setUseJavaClassPath(true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource Pathes : " + String.valueOf(this.pathes)));
        }
        for (String path : this.pathes) {
            if (new File(path).exists()) continue;
            issues.addWarning("Skipping the path '" + path + "', because it does not exist.");
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ResourceSet resourceSet = this.getResourceSet();
        Multimap<String, URI> uris = this.getPathTraverser().resolvePathes(this.pathes, new Predicate<URI>(){

            public boolean apply(URI input) {
                boolean result = true;
                if (Reader.this.getUriFilter() != null) {
                    result = Reader.this.getUriFilter().matches(input);
                }
                if (result) {
                    result = Reader.this.getRegistry().getResourceServiceProvider(input) != null;
                }
                return result;
            }
        });
        IAllContainersState containersState = this.containersStateFactory.getContainersState(this.pathes, uris);
        this.installAsAdapter(resourceSet, containersState);
        this.populateResourceSet(resourceSet, uris);
        this.getValidator().validate(resourceSet, this.getRegistry(), issues);
        this.addModelElementsToContext(ctx, resourceSet);
    }

    protected PathTraverser getPathTraverser() {
        return new PathTraverser();
    }

    protected void populateResourceSet(ResourceSet set, Multimap<String, URI> uris) {
        HashSet values = Sets.newHashSet((Iterable)uris.values());
        for (URI uri : values) {
            set.createResource(uri);
        }
    }

    protected void installAsAdapter(ResourceSet set, IAllContainersState containersState) throws WorkflowInterruptedException {
        set.eAdapters().add((Object)new DelegatingIAllContainerAdapter(containersState));
    }
}

