/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.ops4j.pax.web.service.MultiBundleWebContainerContext;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.internal.StoppableHttpService;
import org.ops4j.pax.web.service.internal.views.DirectWebContainerView;
import org.ops4j.pax.web.service.internal.views.ProcessingWebContainerView;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.context.UniqueMultiBundleWebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.context.UniqueWebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.context.WebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.ServiceModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModelAware;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.JspModel;
import org.ops4j.pax.web.service.spi.model.elements.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConstraintModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.model.events.WebContextEventListener;
import org.ops4j.pax.web.service.spi.model.events.WebElementEvent;
import org.ops4j.pax.web.service.spi.model.events.WebElementEventListener;
import org.ops4j.pax.web.service.spi.model.info.ServletInfo;
import org.ops4j.pax.web.service.spi.model.info.WebApplicationInfo;
import org.ops4j.pax.web.service.spi.model.views.DynamicJEEWebContainerView;
import org.ops4j.pax.web.service.spi.model.views.ReportViewPlugin;
import org.ops4j.pax.web.service.spi.model.views.ReportWebContainerView;
import org.ops4j.pax.web.service.spi.model.views.WebAppWebContainerView;
import org.ops4j.pax.web.service.spi.servlet.DefaultJspPropertyGroupDescriptor;
import org.ops4j.pax.web.service.spi.servlet.DefaultSessionCookieConfig;
import org.ops4j.pax.web.service.spi.servlet.DefaultTaglibDescriptor;
import org.ops4j.pax.web.service.spi.task.Batch;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.ContainerInitializerModelChange;
import org.ops4j.pax.web.service.spi.task.ContextParamsChange;
import org.ops4j.pax.web.service.spi.task.ContextStartChange;
import org.ops4j.pax.web.service.spi.task.ContextStopChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageModelChange;
import org.ops4j.pax.web.service.spi.task.EventListenerModelChange;
import org.ops4j.pax.web.service.spi.task.FilterModelChange;
import org.ops4j.pax.web.service.spi.task.OpCode;
import org.ops4j.pax.web.service.spi.task.SecurityConfigChange;
import org.ops4j.pax.web.service.spi.task.ServletModelChange;
import org.ops4j.pax.web.service.spi.task.TransactionStateChange;
import org.ops4j.pax.web.service.spi.task.WelcomeFileModelChange;
import org.ops4j.pax.web.service.spi.util.Path;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.ops4j.pax.web.service.views.PaxWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceEnabled
implements WebContainer,
StoppableHttpService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceEnabled.class);
    final Bundle serviceBundle;
    private final ServerModel serverModel;
    private final ServiceModel serviceModel;
    private final ServerController serverController;
    private final WebElementEventListener eventDispatcher;
    private final WhiteboardWebContainerView whiteboardWebContainer = new WhiteboardWebContainer();
    private final DirectWebContainerView directWebContainer = new DirectWebContainer();
    private final ProcessingWebContainerView processingWebContainer = new ProcessingWebContainer();
    private final WebAppWebContainerView webAppWebContainer = new WebAppWebContainer();
    private final ReportWebContainer reportWebContainer = new ReportWebContainer();
    private final Configuration configuration;
    private volatile boolean stopped = false;

    public HttpServiceEnabled(Bundle bundle, ServerController srvController, ServerModel serverModel, WebElementEventListener eventDispatcher, Configuration configuration) {
        LOG.debug("Creating active Http Service for: {}", (Object)bundle);
        this.serverModel = serverModel;
        this.serviceModel = new ServiceModel(serverModel, srvController, bundle, eventDispatcher);
        this.serviceBundle = bundle;
        this.serverController = srvController;
        this.eventDispatcher = eventDispatcher;
        this.configuration = configuration;
    }

    public ServiceModel getServiceModel() {
        return this.serviceModel;
    }

    @Override
    public void stop() {
        LOG.debug("Stopping http service for: " + this.serviceBundle);
        Batch b = new Batch("Stopping " + this);
        HashSet<String> contexts = new HashSet<String>();
        for (Object fm : this.serviceModel.getFilterModels()) {
            for (Object ocm : fm.getContextModels()) {
                contexts.add(ocm.getContextPath());
            }
        }
        if (!this.serviceModel.getFilterModels().isEmpty()) {
            b.removeFilterModels(new ArrayList(this.serviceModel.getFilterModels()));
        }
        HashMap<ServletModel, Boolean> servlets = new HashMap<ServletModel, Boolean>();
        for (ServletModel sm : this.serviceModel.getServletModels()) {
            servlets.put(sm, !this.serverModel.getDisabledServletModels().contains(sm));
            for (Object ocm : sm.getContextModels()) {
                contexts.add(ocm.getContextPath());
            }
        }
        if (!servlets.isEmpty()) {
            b.removeServletModels(servlets);
        }
        for (EventListenerModel elm : this.serviceModel.getEventListenerModels()) {
            for (Object ocm : elm.getContextModels()) {
                contexts.add(ocm.getContextPath());
            }
        }
        if (!this.serviceModel.getEventListenerModels().isEmpty()) {
            b.removeEventListenerModels(new ArrayList(this.serviceModel.getEventListenerModels()));
        }
        for (ErrorPageModel epm : this.serviceModel.getErrorPageModels()) {
            for (Object ocm : epm.getContextModels()) {
                contexts.add(ocm.getContextPath());
            }
        }
        if (!this.serviceModel.getErrorPageModels().isEmpty()) {
            b.removeErrorPageModels(new ArrayList(this.serviceModel.getErrorPageModels()));
        }
        for (ContainerInitializerModel cim : this.serviceModel.getContainerInitializerModels()) {
            for (Object ocm : cim.getContextModels()) {
                contexts.add(ocm.getContextPath());
            }
        }
        if (!this.serviceModel.getContainerInitializerModels().isEmpty()) {
            b.removeContainerInitializerModels(new ArrayList(this.serviceModel.getContainerInitializerModels()));
        }
        HashMap<WebSocketModel, Boolean> webSockets = new HashMap<WebSocketModel, Boolean>();
        for (WebSocketModel wsm : this.serviceModel.getWebSocketModels()) {
            webSockets.put(wsm, !this.serverModel.getDisabledWebSocketModels().contains(wsm));
            for (OsgiContextModel ocm : wsm.getContextModels()) {
                contexts.add(ocm.getContextPath());
            }
        }
        if (!webSockets.isEmpty()) {
            b.removeWebSocketModels(webSockets);
        }
        for (WelcomeFileModel wfm : this.serviceModel.getWelcomeFileModels()) {
            for (OsgiContextModel ocm : wfm.getContextModels()) {
                contexts.add(ocm.getContextPath());
            }
            b.removeWelcomeFileModel(wfm);
        }
        for (Object ocm : this.serverModel.getAllBundleOsgiContextModels(this.serviceBundle)) {
            SecurityConfigurationModel scm;
            if (ocm.hasDirectHttpContextInstance()) {
                b.disassociateOsgiContextModel(ocm.getDirectHttpContextInstance(), (OsgiContextModel)ocm);
                b.removeOsgiContextModel((OsgiContextModel)ocm);
                contexts.add(ocm.getContextPath());
            }
            if ((scm = ocm.getSecurityConfiguration()) == null || scm.getLoginConfig() == null && scm.getSecurityConstraints().isEmpty() && scm.getSecurityRoles().isEmpty()) continue;
            b.getOperations().add(new SecurityConfigChange(OpCode.DELETE, (OsgiContextModel)ocm, scm.getLoginConfig(), scm.getSecurityConstraints(), new ArrayList(scm.getSecurityRoles())));
        }
        for (String ctx : contexts) {
            b.getOperations().add(0, new TransactionStateChange(OpCode.ASSOCIATE, ctx));
            b.getOperations().add(new TransactionStateChange(OpCode.DISASSOCIATE, ctx));
        }
        this.serverModel.runSilently(() -> {
            this.serverController.sendBatch(b);
            b.accept((BatchVisitor)this.serviceModel);
            return null;
        }, true);
        this.stopped = true;
    }

    public <T extends PaxWebContainerView> T adapt(Class<T> type) {
        if (type == WhiteboardWebContainerView.class) {
            return (T)((PaxWebContainerView)type.cast(this.whiteboardWebContainer));
        }
        if (type == DirectWebContainerView.class) {
            return (T)((PaxWebContainerView)type.cast(this.directWebContainer));
        }
        if (type == DynamicJEEWebContainerView.class) {
            return (T)((PaxWebContainerView)type.cast(this.whiteboardWebContainer));
        }
        if (type == WebAppWebContainerView.class) {
            return (T)((PaxWebContainerView)type.cast(this.webAppWebContainer));
        }
        if (type == ReportWebContainerView.class) {
            return (T)((PaxWebContainerView)type.cast(this.reportWebContainer));
        }
        if (type == ProcessingWebContainerView.class) {
            return (T)((PaxWebContainerView)type.cast(this.processingWebContainer));
        }
        return null;
    }

    public WebContainerContext createDefaultHttpContext() {
        return this.createDefaultHttpContext("default");
    }

    public WebContainerContext createDefaultHttpContext(String contextId) {
        return new UniqueWebContainerContextWrapper(this.serviceModel.getOrCreateDefaultHttpContext(contextId));
    }

    public MultiBundleWebContainerContext createDefaultSharedHttpContext() {
        return this.createDefaultSharedHttpContext("shared");
    }

    public MultiBundleWebContainerContext createDefaultSharedHttpContext(String contextId) {
        return new UniqueMultiBundleWebContainerContextWrapper(this.serviceModel.getOrCreateDefaultSharedHttpContext(contextId));
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary<?, ?> initParams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.registerServlet(alias, servlet, initParams, null, null, httpContext);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary<?, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException, NamespaceException {
        ServletModel servletModel = new ServletModel(alias, servlet, initParams, loadOnStartup, asyncSupported);
        this.doRegisterServlet(Collections.singletonList(httpContext), servletModel);
    }

    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, null, urlPatterns, initParams, null, null, null, httpContext);
    }

    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, null, urlPatterns, initParams, loadOnStartup, asyncSupported, null, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, servletName, urlPatterns, initParams, null, null, null, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, servletName, urlPatterns, initParams, loadOnStartup, asyncSupported, null, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        ServletModel servletModel = new ServletModel(servletName, urlPatterns, servlet, initParams, loadOnStartup, asyncSupported, multiPartConfig);
        this.doRegisterServletWithoutAlias(httpContext, servletModel);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servletClass, urlPatterns, initParams, null, null, null, httpContext);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.registerServlet(servletClass, urlPatterns, initParams, loadOnStartup, asyncSupported, null, httpContext);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        ServletModel servletModel = new ServletModel(urlPatterns, servletClass, initParams, loadOnStartup, asyncSupported, multiPartConfig);
        this.doRegisterServletWithoutAlias(httpContext, servletModel);
    }

    private void doRegisterServletWithoutAlias(HttpContext httpContext, ServletModel model) throws ServletException {
        try {
            this.doRegisterServlet(Collections.singletonList(httpContext), model);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    private void doRegisterServlet(Collection<HttpContext> httpContexts, ServletModel model) throws ServletException, NamespaceException {
        LOG.debug("Passing registration of {} to configuration thread", (Object)model);
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        this.event(WebElementEvent.State.DEPLOYING, (ElementModel<?, ?>)model);
        Batch batch = new Batch("Registration of " + model);
        this.serverModel.run(() -> {
            try {
                this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                if (model.isJspServlet()) {
                    model.configureJspServlet(this.configuration.jsp());
                }
                try {
                    model.performValidation();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                LOG.info("Registering {}", (Object)model);
                this.serverModel.addServletModel(model, batch);
                Batch newBatch = batch;
                if (model.isJspServlet()) {
                    ContainerInitializerModel jspSCIModel = null;
                    for (ContainerInitializerModel cim : this.serverModel.getContainerInitializerModels()) {
                        if (!"org.ops4j.pax.web.jsp.JasperInitializer".equals(cim.getContainerInitializer().getClass().getName()) || !Utils.useSameContextPath((ElementModel)cim, (ElementModel)model)) continue;
                        jspSCIModel = cim;
                        break;
                    }
                    if (jspSCIModel == null) {
                        jspSCIModel = this.serverModel.createJSPServletContainerInitializerModel(this.serviceBundle);
                        jspSCIModel.setRegisteringBundle(model.getRegisteringBundle());
                        jspSCIModel.getRelatedServletModels().add(model);
                        model.getContextModels().forEach(arg_0 -> ((ContainerInitializerModel)jspSCIModel).addContextModel(arg_0));
                        newBatch = new Batch("JSP Configuration and registration of " + model);
                        newBatch.clearDynamicRegistrations(model.getContextModels());
                        this.serverModel.addContainerInitializerModel(jspSCIModel, newBatch);
                        for (Change operation : batch.getOperations()) {
                            newBatch.getOperations().add(operation);
                        }
                    } else {
                        jspSCIModel.getRelatedServletModels().add(model);
                    }
                }
                this.serverController.sendBatch(newBatch);
                newBatch.accept((BatchVisitor)this.serviceModel);
                this.event(WebElementEvent.State.DEPLOYED, (ElementModel<?, ?>)model);
                return null;
            }
            catch (RuntimeException | ServletException | NamespaceException e) {
                this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, (Exception)e);
                throw e;
            }
            catch (Exception e) {
                this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }, model.isAsynchronusRegistration());
    }

    public void unregister(String alias) {
        ServletModel model = new ServletModel(alias, null, null, null, (ServiceReference)null);
        this.doUnregisterServlet(model);
    }

    public void unregisterServlet(Servlet servlet) {
        ServletModel model = new ServletModel(null, null, servlet, null, null);
        this.doUnregisterServlet(model);
    }

    public void unregisterServlet(String servletName) {
        ServletModel model = new ServletModel(null, servletName, null, null, null);
        this.doUnregisterServlet(model);
    }

    public void unregisterServlets(Class<? extends Servlet> servletClass) {
        ServletModel model = new ServletModel(null, null, null, servletClass, null);
        this.doUnregisterServlet(model);
    }

    private void doUnregisterServlet(ServletModel model) {
        String alias = model.getAlias();
        String name = model.getName();
        Servlet instance = model.getServlet();
        Class servletClass = model.getServletClass();
        ServiceReference reference = model.getElementReference();
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        Bundle registeringBundle = model.getRegisteringBundle();
        this.event(WebElementEvent.State.UNDEPLOYING, (ElementModel<?, ?>)model);
        try {
            this.serverModel.run(() -> {
                try {
                    LinkedList<Object> toUnregister = new LinkedList<Object>();
                    for (Object existing : this.serviceModel.getServletModels()) {
                        if (existing != model) continue;
                        LOG.info("Unregistering servlet model \"{}\"", (Object)model);
                        toUnregister.add(existing);
                        break;
                    }
                    if (toUnregister.isEmpty()) {
                        if (alias != null) {
                            Map mapping;
                            LOG.info("Unregistering servlet by alias \"{}\"", (Object)alias);
                            ServletModel found = null;
                            for (ServletModel existing : this.serviceModel.getServletModels()) {
                                if (!alias.equals(existing.getAlias())) continue;
                                found = existing;
                                break;
                            }
                            if ((mapping = (Map)this.serviceModel.getAliasMapping().get(alias)) == null || mapping.size() == 0 || found == null) {
                                throw new IllegalArgumentException("Alias \"" + alias + "\" was never registered by " + registeringBundle);
                            }
                            toUnregister.add(found);
                        } else if (servletClass != null) {
                            LOG.info("Unregistering servlet by class \"{}\"", (Object)servletClass);
                            for (Object existing : this.serviceModel.getServletModels()) {
                                if (!existing.getServletClass().equals(servletClass)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Servlet of \"" + servletClass.getName() + "\" class was never registered by " + registeringBundle);
                            }
                        } else if (instance != null) {
                            LOG.info("Unregistering servlet \"{}\"", (Object)instance);
                            for (Object existing : this.serviceModel.getServletModels()) {
                                if (existing.getServlet() == null || !existing.getServlet().equals(instance)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Servlet \"" + instance + "\" was never registered by " + registeringBundle);
                            }
                        } else if (reference != null) {
                            LOG.info("Unregistering servlet by refernce \"{}\"", (Object)reference);
                            for (Object existing : this.serviceModel.getServletModels()) {
                                if (!existing.getElementReference().equals(reference)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Servlet with reference \"" + reference + "\" was never registered by " + registeringBundle);
                            }
                        } else if (name != null) {
                            LOG.info("Unregistering servlet by name \"{}\"", (Object)name);
                            for (Object existing : this.serviceModel.getServletModels()) {
                                if (!existing.getName().equals(name)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Servlet named \"" + name + "\" was never registered by " + registeringBundle);
                            }
                        }
                    }
                    if (toUnregister.isEmpty()) {
                        throw new IllegalArgumentException("Can't find a servlet to unregister using criteria from " + model);
                    }
                    Batch batch = new Batch("Unregistration of servlets: " + toUnregister);
                    if (model.isJspServlet()) {
                        for (ContainerInitializerModel cim : this.serverModel.getContainerInitializerModels()) {
                            if (!cim.getRelatedServletModels().remove(model) || !cim.getRelatedServletModels().isEmpty()) continue;
                            batch.removeContainerInitializerModels(Collections.singletonList(cim));
                        }
                    }
                    this.serverModel.removeServletModels(toUnregister, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.UNDEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, false);
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        ResourceServlet resourceServlet = this.createResourceServlet(new String[]{alias}, name);
        ServletModel servletModel = new ServletModel.Builder().withAlias(alias).withServletName("/".equals(alias) ? "default" : String.format("default-%s", UUID.randomUUID())).withServletSupplier(resourceServlet.supplier).withLoadOnStartup(Integer.valueOf(1)).withAsyncSupported(Boolean.valueOf(true)).resourceServlet(true).build();
        if (resourceServlet.urlBase != null) {
            LOG.debug("Configuring resource servlet to serve resources from {}", (Object)resourceServlet.urlBase);
            servletModel.setBaseFileUrl(resourceServlet.urlBase);
        } else {
            LOG.debug("Configuring resource servlet to serve resources from WebContainerContext");
            servletModel.setBasePath(resourceServlet.chrootBase);
        }
        try {
            this.doRegisterServlet(Collections.singletonList(context), servletModel);
        }
        catch (ServletException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ResourceServlet createResourceServlet(String[] urlPatterns, String rawBase) {
        URL urlBase = ServletModel.getFileUrlIfAccessible((String)rawBase);
        String chrootBase = Path.securePath((String)rawBase);
        if (urlBase == null) {
            if (chrootBase == null) {
                LOG.warn("Can't use {} as resource base, changed to root of the bundle providing resources", (Object)rawBase);
                chrootBase = "";
            } else {
                if (chrootBase.startsWith("/")) {
                    chrootBase = chrootBase.substring(1);
                }
                if (chrootBase.endsWith("/")) {
                    chrootBase = chrootBase.substring(0, chrootBase.length() - 1);
                }
            }
            LOG.info("Registering resources with {} mapping(s) and resource base \"{}\"", Arrays.asList(urlPatterns), (Object)chrootBase);
        } else {
            LOG.info("Registering resources with {} mapping(s) and absolute directory \"{}\"", Arrays.asList(urlPatterns), (Object)urlBase);
            chrootBase = null;
        }
        String chroot = chrootBase;
        return new ResourceServlet(() -> this.serverController.createResourceServlet(urlBase, chroot), urlBase, chrootBase);
    }

    public void registerFilter(Filter filter, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.registerFilter(filter, null, urlPatterns, servletNames, initParams, null, httpContext);
    }

    public void registerFilter(Filter filter, String filterName, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        FilterModel filterModel = new FilterModel(filterName, urlPatterns, servletNames, null, filter, initParams, asyncSupported);
        this.doRegisterFilter(Collections.singletonList(httpContext), filterModel);
    }

    public void registerFilter(Class<? extends Filter> filterClass, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, HttpContext httpContext) throws ServletException {
        this.registerFilter(filterClass, null, urlPatterns, servletNames, initParams, null, httpContext);
    }

    public void registerFilter(Class<? extends Filter> filterClass, String filterName, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        FilterModel filterModel = new FilterModel(filterName, urlPatterns, servletNames, null, filterClass, initParams, asyncSupported);
        this.doRegisterFilter(Collections.singletonList(httpContext), filterModel);
    }

    private void doRegisterFilter(Collection<HttpContext> httpContexts, FilterModel model) throws ServletException {
        LOG.debug("Passing registration of {} to configuration thread", (Object)model);
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        this.event(WebElementEvent.State.DEPLOYING, (ElementModel<?, ?>)model);
        Batch batch = new Batch("Registration of " + model);
        try {
            this.serverModel.run(() -> {
                try {
                    this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                    try {
                        model.performValidation();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    LOG.info("Registering {}", (Object)model);
                    this.serverModel.addFilterModel(model, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.DEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (RuntimeException e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw e;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, model.isAsynchronusRegistration());
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void unregisterFilter(Filter filter) {
        FilterModel model = new FilterModel(null, filter, null, null);
        this.doUnregisterFilter(model);
    }

    public void unregisterFilter(String filterName) {
        FilterModel model = new FilterModel(filterName, null, null, null);
        this.doUnregisterFilter(model);
    }

    public void unregisterFilters(Class<? extends Filter> filterClass) {
        FilterModel model = new FilterModel(null, null, filterClass, null);
        this.doUnregisterFilter(model);
    }

    private void doUnregisterFilter(FilterModel model) {
        String name = model.getName();
        Filter instance = model.getFilter();
        Class filterClass = model.getFilterClass();
        ServiceReference reference = model.getElementReference();
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        Bundle registeringBundle = model.getRegisteringBundle();
        this.event(WebElementEvent.State.UNDEPLOYING, (ElementModel<?, ?>)model);
        try {
            this.serverModel.run(() -> {
                try {
                    LinkedList<FilterModel> toUnregister = new LinkedList<FilterModel>();
                    for (FilterModel existing : this.serviceModel.getFilterModels()) {
                        if (existing != model) continue;
                        LOG.info("Unregistering filter model \"{}\"", (Object)model);
                        toUnregister.add(existing);
                        break;
                    }
                    if (toUnregister.isEmpty()) {
                        if (name != null) {
                            LOG.info("Unregistering filter by name \"{}\"", (Object)name);
                            for (FilterModel existing : this.serviceModel.getFilterModels()) {
                                if (!existing.getName().equals(name)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Filter named \"" + name + "\" was never registered by " + registeringBundle);
                            }
                        } else if (filterClass != null) {
                            LOG.info("Unregistering filter by class \"{}\"", (Object)filterClass);
                            for (FilterModel existing : this.serviceModel.getFilterModels()) {
                                if (!existing.getFilterClass().equals(filterClass)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Filter of \"" + filterClass.getName() + "\" class was never registered by " + registeringBundle);
                            }
                        } else if (reference != null) {
                            LOG.info("Unregistering filter by refernce \"{}\"", (Object)reference);
                            for (FilterModel existing : this.serviceModel.getFilterModels()) {
                                if (!existing.getElementReference().equals(reference)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Filter with reference \"" + reference + "\" was never registered by " + registeringBundle);
                            }
                        } else if (instance != null) {
                            LOG.info("Unregistering filter \"{}\"", (Object)instance);
                            for (FilterModel existing : this.serviceModel.getFilterModels()) {
                                if (!existing.getFilter().equals(instance)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Filter \"" + instance + "\" was never registered by " + registeringBundle);
                            }
                        }
                    }
                    if (toUnregister.isEmpty()) {
                        throw new IllegalArgumentException("Can't find a filter to unregister using criteria from " + model);
                    }
                    Batch batch = new Batch("Unregistration of filters: " + toUnregister);
                    this.serverModel.removeFilterModels(toUnregister, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.UNDEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, false);
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void registerEventListener(EventListener listener, HttpContext httpContext) {
        this.doRegisterEventListener(Collections.singletonList(httpContext), new EventListenerModel(listener));
    }

    private void doRegisterEventListener(Collection<HttpContext> httpContexts, EventListenerModel model) {
        LOG.debug("Passing registration of {} to configuration thread", (Object)model);
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        this.event(WebElementEvent.State.DEPLOYING, (ElementModel<?, ?>)model);
        Batch batch = new Batch("Registration of " + model);
        try {
            this.serverModel.run(() -> {
                try {
                    this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                    try {
                        model.performValidation();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    LOG.info("Registering {}", (Object)model);
                    this.serverModel.addEventListenerModel(model, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    Batch toSchedule = new Batch("After registration of " + model);
                    for (Change c : batch.getOperations()) {
                        if (c.getBatchCompletedAction() == null) continue;
                        toSchedule.getOperations().add(c.getBatchCompletedAction());
                    }
                    if (!toSchedule.getOperations().isEmpty()) {
                        LOG.info("Scheduling {}", (Object)toSchedule);
                        this.serverModel.runAsync(() -> {
                            this.serverController.sendBatch(toSchedule);
                            return null;
                        });
                    }
                    this.event(WebElementEvent.State.DEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, model.isAsynchronusRegistration());
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void unregisterEventListener(EventListener listener) {
        EventListenerModel model = new EventListenerModel(listener);
        this.doUnregisterEventListener(model);
    }

    private void doUnregisterEventListener(EventListenerModel model) {
        EventListener listener = model.getEventListener();
        ServiceReference reference = model.getElementReference();
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        Bundle registeringBundle = model.getRegisteringBundle();
        try {
            this.event(WebElementEvent.State.UNDEPLOYING, (ElementModel<?, ?>)model);
            this.serverModel.runAsync(() -> {
                LinkedList<EventListenerModel> toUnregister = new LinkedList<EventListenerModel>();
                for (EventListenerModel existing : this.serviceModel.getEventListenerModels()) {
                    if (existing != model) continue;
                    toUnregister.add(model);
                    break;
                }
                if (toUnregister.isEmpty()) {
                    if (listener != null) {
                        for (EventListenerModel existing : this.serviceModel.getEventListenerModels()) {
                            if (existing.getEventListener() != listener) continue;
                            toUnregister.add(existing);
                        }
                    } else if (reference != null) {
                        for (EventListenerModel existing : this.serviceModel.getEventListenerModels()) {
                            if (existing.getElementReference() != reference) continue;
                            toUnregister.add(existing);
                        }
                    }
                }
                if (toUnregister.isEmpty()) {
                    throw new IllegalArgumentException("Can't find an event listener to unregister using criteria from " + model);
                }
                Batch batch = new Batch("Unregistration of EventListener: " + toUnregister);
                this.serverModel.removeEventListenerModels(toUnregister, batch);
                this.serverController.sendBatch(batch);
                batch.accept((BatchVisitor)this.serviceModel);
                this.event(WebElementEvent.State.UNDEPLOYED, (ElementModel<?, ?>)model);
                return null;
            });
        }
        catch (Exception e) {
            this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void registerWelcomeFiles(String[] welcomeFiles, boolean redirect, HttpContext httpContext) {
        this.doRegisterWelcomeFiles(Collections.singletonList(httpContext), new WelcomeFileModel(welcomeFiles, redirect));
    }

    private void doRegisterWelcomeFiles(List<HttpContext> httpContexts, WelcomeFileModel model) {
        LOG.debug("Passing registration of {} to configuration thread", (Object)model);
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        this.event(WebElementEvent.State.DEPLOYING, (ElementModel<?, ?>)model);
        Batch batch = new Batch("Registration of " + model);
        try {
            this.serverModel.run(() -> {
                try {
                    this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                    try {
                        model.performValidation();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    LOG.info("Registering {}", (Object)model);
                    this.serverModel.addWelcomeFileModel(model, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.DEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, model.isAsynchronusRegistration());
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void unregisterWelcomeFiles(String[] welcomeFiles, HttpContext httpContext) {
        WelcomeFileModel model = null;
        for (WelcomeFileModel wfm : this.serviceModel.getWelcomeFileModels()) {
            if (!Arrays.equals(wfm.getWelcomeFiles(), welcomeFiles)) continue;
            model = wfm;
        }
        if (model == null) {
            model = new WelcomeFileModel(welcomeFiles, false);
        }
        this.doUnregisterWelcomeFiles(Collections.singletonList(httpContext), model);
    }

    private void doUnregisterWelcomeFiles(List<HttpContext> httpContexts, WelcomeFileModel model) {
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        Bundle registeringBundle = model.getRegisteringBundle();
        Batch batch = new Batch("Unregistration of " + model);
        this.event(WebElementEvent.State.UNDEPLOYING, (ElementModel<?, ?>)model);
        try {
            this.serverModel.run(() -> {
                try {
                    this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                    LOG.info("Unregistering {}", (Object)model);
                    this.serverModel.removeWelcomeFileModel(model, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.UNDEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, false);
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void registerErrorPage(String error, String location, HttpContext httpContext) {
        this.registerErrorPages(new String[]{error}, location, httpContext);
    }

    public void registerErrorPages(String[] errors, String location, HttpContext httpContext) {
        ErrorPageModel model = new ErrorPageModel(errors, location);
        this.doRegisterErrorPages(Collections.singletonList(httpContext), model);
    }

    private void doRegisterErrorPages(Collection<HttpContext> httpContexts, ErrorPageModel model) {
        LOG.debug("Passing registration of {} to configuration thread", (Object)model);
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        this.event(WebElementEvent.State.DEPLOYING, (ElementModel<?, ?>)model);
        Batch batch = new Batch("Registration of " + model);
        try {
            this.serverModel.run(() -> {
                try {
                    this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                    try {
                        model.performValidation();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    LOG.info("Registering {}", (Object)model);
                    this.serverModel.addErrorPageModel(model, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.DEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, model.isAsynchronusRegistration());
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void unregisterErrorPage(String error, HttpContext httpContext) {
        this.unregisterErrorPages(new String[]{error}, httpContext);
    }

    public void unregisterErrorPages(String[] errors, HttpContext httpContext) {
        ErrorPageModel model = new ErrorPageModel(errors);
        this.doUnregisterErrorPages(model);
    }

    private void doUnregisterErrorPages(ErrorPageModel model) {
        String[] errorPages = model.getErrorPages();
        HashSet<String> errorPagesSet = new HashSet<String>(Arrays.asList(errorPages));
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        Bundle registeringBundle = model.getRegisteringBundle();
        this.event(WebElementEvent.State.UNDEPLOYING, (ElementModel<?, ?>)model);
        try {
            this.serverModel.run(() -> {
                try {
                    LinkedList<ErrorPageModel> toUnregister = new LinkedList<ErrorPageModel>();
                    LOG.info("Unregistering error page models for pages \"{}\"", Arrays.asList(errorPages));
                    for (ErrorPageModel existing : this.serviceModel.getErrorPageModels()) {
                        if (existing != model) continue;
                        toUnregister.add(existing);
                        break;
                    }
                    if (toUnregister.isEmpty()) {
                        for (ErrorPageModel existing : this.serviceModel.getErrorPageModels()) {
                            if (existing == model) {
                                toUnregister.add(existing);
                                break;
                            }
                            HashSet<String> existingPages = new HashSet<String>(Arrays.asList(existing.getErrorPages()));
                            if (!existingPages.containsAll(errorPagesSet)) continue;
                            toUnregister.add(existing);
                        }
                    }
                    if (toUnregister.isEmpty()) {
                        throw new IllegalArgumentException("Can't find error pages to unregister using criteria from " + model);
                    }
                    Batch batch = new Batch("Unregistration of error pages: " + toUnregister);
                    this.serverModel.removeErrorPageModels(toUnregister, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.UNDEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, false);
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void registerJsps(String[] urlPatterns, Dictionary<String, String> initParams, HttpContext context) {
        try {
            ServletModel jspServletModel = this.serverModel.createJspServletModel(this.serviceBundle, "jsp", null, urlPatterns, Utils.toMap(initParams), this.configuration.jsp());
            this.doRegisterServlet(Collections.singletonList(context), jspServletModel);
        }
        catch (ServletException | NamespaceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void registerJspServlet(String jspFile, String[] urlPatterns, Dictionary<String, String> initParams, HttpContext context) {
        try {
            ServletModel model = this.serverModel.createJspServletModel(this.serviceBundle, jspFile, jspFile, urlPatterns, Utils.toMap(initParams), this.configuration.jsp());
            this.doRegisterServlet(Collections.singletonList(context), model);
        }
        catch (ServletException | NamespaceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void registerJspConfigTagLibs(String taglibLocation, String tagLibUri, HttpContext httpContext) {
        DefaultTaglibDescriptor descriptor = new DefaultTaglibDescriptor(tagLibUri, taglibLocation);
        this.registerJspConfigTagLibs(Collections.singletonList(descriptor), httpContext);
    }

    public void registerJspConfigTagLibs(Collection<TaglibDescriptor> tagLibs, HttpContext httpContext) {
        this.serverModel.runSilently(() -> {
            Batch batch = new Batch("Taglibs configuration");
            WebContainerContext ctx = this.unify(httpContext);
            OsgiContextModel contextModel = this.serverModel.getOrCreateOsgiContextModel(ctx, this.serviceBundle, "/", batch);
            contextModel.addTagLibs(tagLibs);
            this.serverController.sendBatch(batch);
            return null;
        }, false);
    }

    public void registerJspConfigPropertyGroup(List<String> includeCodas, List<String> includePreludes, List<String> urlPatterns, Boolean elIgnored, Boolean scriptingInvalid, Boolean isXml, HttpContext httpContext) {
        DefaultJspPropertyGroupDescriptor descriptor = new DefaultJspPropertyGroupDescriptor();
        descriptor.setIncludeCodas(includeCodas);
        descriptor.setIncludePreludes(includePreludes);
        descriptor.setUrlPatterns(urlPatterns);
        descriptor.setElIgnored(elIgnored == null ? "false" : elIgnored.toString());
        descriptor.setScriptingInvalid(scriptingInvalid == null ? "false" : scriptingInvalid.toString());
        descriptor.setScriptingInvalid(isXml == null ? "false" : isXml.toString());
        this.registerJspConfigPropertyGroup((JspPropertyGroupDescriptor)descriptor, httpContext);
    }

    public void registerJspConfigPropertyGroup(JspPropertyGroupDescriptor descriptor, HttpContext httpContext) {
        this.serverModel.runSilently(() -> {
            Batch batch = new Batch("JSP configuration");
            WebContainerContext ctx = this.unify(httpContext);
            OsgiContextModel contextModel = this.serverModel.getOrCreateOsgiContextModel(ctx, this.serviceBundle, "/", batch);
            contextModel.addJspPropertyGroupDescriptor(descriptor);
            this.serverController.sendBatch(batch);
            return null;
        }, false);
    }

    public void unregisterJsps(HttpContext httpContext) {
    }

    public void unregisterJspServlet(String jspFile, HttpContext httpContext) {
    }

    public void registerServletContainerInitializer(ServletContainerInitializer initializer, Class<?>[] classes, HttpContext httpContext) {
        ContainerInitializerModel model = new ContainerInitializerModel(initializer, (Class[])classes);
        this.doRegisterServletContainerInitializer(Collections.singletonList(httpContext), model);
    }

    private void doRegisterServletContainerInitializer(List<HttpContext> httpContexts, ContainerInitializerModel model) {
        LOG.debug("Passing registration of {} to configuration thread", (Object)model);
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        this.event(WebElementEvent.State.DEPLOYING, (ElementModel<?, ?>)model);
        Batch batch = new Batch("Registration of " + model);
        try {
            this.serverModel.run(() -> {
                try {
                    this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                    try {
                        model.performValidation();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    LOG.info("Registering {}", (Object)model);
                    batch.clearDynamicRegistrations(model.getContextModels());
                    this.serverModel.addContainerInitializerModel(model, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.DEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, model.isAsynchronusRegistration());
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void unregisterServletContainerInitializer(ServletContainerInitializer initializer, HttpContext httpContext) {
        this.doUnregisterServletContainerInitializer(new ContainerInitializerModel(initializer, null));
    }

    private void doUnregisterServletContainerInitializer(ContainerInitializerModel model) {
        ServletContainerInitializer initializer = model.getContainerInitializer();
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        Bundle registeringBundle = model.getRegisteringBundle();
        this.event(WebElementEvent.State.UNDEPLOYING, (ElementModel<?, ?>)model);
        try {
            this.serverModel.run(() -> {
                try {
                    LinkedList<ContainerInitializerModel> toUnregister = new LinkedList<ContainerInitializerModel>();
                    for (ContainerInitializerModel existing : this.serviceModel.getContainerInitializerModels()) {
                        if (existing != model) continue;
                        toUnregister.add(existing);
                        break;
                    }
                    if (toUnregister.isEmpty() && initializer != null) {
                        for (ContainerInitializerModel existing : this.serviceModel.getContainerInitializerModels()) {
                            if (existing.getContainerInitializer() != initializer) continue;
                            toUnregister.add(existing);
                        }
                    }
                    if (toUnregister.isEmpty()) {
                        throw new IllegalArgumentException("Can't find an servlet container initializer to unregister using criteria from " + model);
                    }
                    Batch batch = new Batch("Unregistration of ServletContainerInitializer: " + toUnregister);
                    batch.removeContainerInitializerModels(toUnregister);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.UNDEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, false);
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void setSessionTimeout(Integer minutes, HttpContext httpContext) {
        this.serverModel.runSilently(() -> {
            Batch batch = new Batch("Session timeout configuration");
            WebContainerContext ctx = this.unify(httpContext);
            OsgiContextModel contextModel = this.serverModel.getOrCreateOsgiContextModel(ctx, this.serviceBundle, "/", batch);
            LOG.info("Setting session timeout for {}", (Object)contextModel);
            contextModel.setSessionTimeout(minutes);
            this.serverController.sendBatch(batch);
            return null;
        }, false);
    }

    public void setSessionCookieConfig(String domain, String name, Boolean httpOnly, Boolean secure, String path, Integer maxAge, HttpContext httpContext) {
        DefaultSessionCookieConfig config = new DefaultSessionCookieConfig();
        config.setDomain(domain);
        config.setName(name);
        config.setHttpOnly(httpOnly.booleanValue());
        config.setSecure(secure.booleanValue());
        config.setPath(path);
        config.setMaxAge(maxAge.intValue());
        this.setSessionCookieConfig((SessionCookieConfig)config, httpContext);
    }

    public void setSessionCookieConfig(SessionCookieConfig config, HttpContext httpContext) {
        this.serverModel.runSilently(() -> {
            Batch batch = new Batch("Session Cookie configuration");
            WebContainerContext ctx = this.unify(httpContext);
            OsgiContextModel contextModel = this.serverModel.getOrCreateOsgiContextModel(ctx, this.serviceBundle, "/", batch);
            LOG.info("Setting session cookie configuration for {}", (Object)contextModel);
            contextModel.setSessionCookieConfig(config);
            this.serverController.sendBatch(batch);
            return null;
        }, false);
    }

    public void setContextParams(Dictionary<String, Object> params, HttpContext httpContext) {
        this.serverModel.runSilently(() -> {
            Batch batch = new Batch("Context init parameters configuration");
            WebContainerContext ctx = this.unify(httpContext);
            OsgiContextModel contextModel = this.serverModel.getOrCreateOsgiContextModel(ctx, this.serviceBundle, "/", batch);
            LOG.info("Setting context init parameters in {}", (Object)contextModel);
            batch.getOperations().add(new ContextParamsChange(OpCode.ADD, contextModel, Utils.toMap((Dictionary)params)));
            this.serverController.sendBatch(batch);
            return null;
        }, false);
    }

    public void registerWebSocket(Object webSocket, HttpContext httpContext) {
        if (Class.class == webSocket.getClass()) {
            this.doRegisterWebSocket(Collections.singletonList(httpContext), new WebSocketModel(null, (Class)webSocket));
        } else {
            this.doRegisterWebSocket(Collections.singletonList(httpContext), new WebSocketModel(webSocket, null));
        }
    }

    private void doRegisterWebSocket(List<HttpContext> httpContexts, WebSocketModel model) {
        LOG.debug("Passing registration of {} to configuration thread", (Object)model);
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        this.event(WebElementEvent.State.DEPLOYING, (ElementModel<?, ?>)model);
        Batch batch = new Batch("Registration of " + model);
        try {
            this.serverModel.run(() -> {
                try {
                    this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                    try {
                        model.performValidation();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    LOG.info("Registering {}", (Object)model);
                    batch.clearDynamicRegistrations(model.getContextModels());
                    Bundle paxWebWS = Utils.getPaxWebWebSocketsBundle((Bundle)this.serviceBundle);
                    if (paxWebWS == null) {
                        throw new IllegalStateException("pax-web-websocket bundle is not installed. Can't register WebSocket endpoint.");
                    }
                    Bundle jettyWebSocketBundle = Utils.getJettyWebSocketBundle((Bundle)this.serviceBundle);
                    Bundle tomcatWebSocketBundle = Utils.getTomcatWebSocketBundle((Bundle)this.serviceBundle);
                    Bundle undertowWebSocketBundle = Utils.getUndertowWebSocketBundle((Bundle)this.serviceBundle);
                    ContainerInitializerModel cimForGenericWSSupport = null;
                    ContainerInitializerModel cimForJettyWSSupport = null;
                    ContainerInitializerModel cimForTomcatWSSupport = null;
                    ContainerInitializerModel cimForUndertowWSSupport = null;
                    for (ContainerInitializerModel cim : this.serverModel.getContainerInitializerModels()) {
                        if (!Utils.useSameContextPath((ElementModel)cim, (ElementModel)model)) continue;
                        switch (cim.getContainerInitializer().getClass().getName()) {
                            case "org.ops4j.pax.web.websocket.internal.PaxWebWebSocketsServletContainerInitializer": {
                                cimForGenericWSSupport = cim;
                                break;
                            }
                            case "org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer": {
                                cimForJettyWSSupport = cim;
                                break;
                            }
                            case "org.apache.tomcat.websocket.server.WsSci": {
                                cimForTomcatWSSupport = cim;
                                break;
                            }
                            case "org.ops4j.pax.web.service.undertow.websocket.internal.WebSocketsInitializer": {
                                cimForUndertowWSSupport = cim;
                                break;
                            }
                        }
                    }
                    if (jettyWebSocketBundle != null) {
                        if (cimForJettyWSSupport == null) {
                            cimForJettyWSSupport = this.createContainerSpecificWsSCIModel(jettyWebSocketBundle, model, "org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer", "Jetty");
                            cimForJettyWSSupport.setForJetty(true);
                            batch.addContainerInitializerModel(cimForJettyWSSupport, new OsgiContextModel[0]);
                        }
                        cimForJettyWSSupport.getRelatedWebSocketModels().add(model);
                    }
                    if (tomcatWebSocketBundle != null) {
                        if (cimForTomcatWSSupport == null) {
                            cimForTomcatWSSupport = this.createContainerSpecificWsSCIModel(tomcatWebSocketBundle, model, "org.apache.tomcat.websocket.server.WsSci", "Tomcat");
                            cimForTomcatWSSupport.setForTomcat(true);
                            batch.addContainerInitializerModel(cimForTomcatWSSupport, new OsgiContextModel[0]);
                        }
                        cimForTomcatWSSupport.getRelatedWebSocketModels().add(model);
                    }
                    if (undertowWebSocketBundle != null) {
                        if (cimForUndertowWSSupport == null) {
                            cimForUndertowWSSupport = this.createContainerSpecificWsSCIModel(undertowWebSocketBundle, model, "org.ops4j.pax.web.service.undertow.websocket.internal.WebSocketsInitializer", "Undertow");
                            cimForUndertowWSSupport.setForUndertow(true);
                            batch.addContainerInitializerModel(cimForUndertowWSSupport, new OsgiContextModel[0]);
                        }
                        cimForUndertowWSSupport.getRelatedWebSocketModels().add(model);
                    }
                    if (cimForGenericWSSupport == null) {
                        ServletContainerInitializer sci;
                        try {
                            Class wsSCIClass = paxWebWS.loadClass("org.ops4j.pax.web.websocket.internal.PaxWebWebSocketsServletContainerInitializer");
                            sci = (ServletContainerInitializer)wsSCIClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                            throw new IllegalStateException("Can't create WebSocket SCI org.ops4j.pax.web.websocket.internal.PaxWebWebSocketsServletContainerInitializer using bundle " + paxWebWS);
                        }
                        cimForGenericWSSupport = new ContainerInitializerModel(sci, null);
                        cimForGenericWSSupport.setServiceId(0L);
                        cimForGenericWSSupport.setServiceRank(0);
                        model.getContextModels().forEach(arg_0 -> ((ContainerInitializerModel)cimForGenericWSSupport).addContextModel(arg_0));
                        cimForGenericWSSupport.setRegisteringBundle(model.getRegisteringBundle());
                        if (sci instanceof ContainerInitializerModelAware) {
                            ((ContainerInitializerModelAware)sci).setContainerInitializerModel(cimForGenericWSSupport);
                        }
                        batch.addContainerInitializerModel(cimForGenericWSSupport, new OsgiContextModel[0]);
                    } else {
                        batch.changeContainerInitializerModel(cimForGenericWSSupport);
                    }
                    cimForGenericWSSupport.getRelatedWebSocketModels().add(model);
                    this.serverModel.addWebSocketModel(model, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.DEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, model.isAsynchronusRegistration());
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    private ContainerInitializerModel createContainerSpecificWsSCIModel(Bundle bundle, WebSocketModel model, String className, String containerName) {
        ServletContainerInitializer sci;
        try {
            Class sciClass = bundle.loadClass(className);
            sci = (ServletContainerInitializer)sciClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Can't create " + containerName + " WebSocket SCI " + className + " using bundle " + bundle);
        }
        ContainerInitializerModel cim = new ContainerInitializerModel(sci, null);
        cim.setServiceId(0L);
        cim.setServiceRank(Integer.MAX_VALUE);
        model.getContextModels().forEach(arg_0 -> ((ContainerInitializerModel)cim).addContextModel(arg_0));
        cim.setRegisteringBundle(model.getRegisteringBundle());
        return cim;
    }

    public void unregisterWebSocket(Object webSocket, HttpContext httpContext) {
        if (Class.class == webSocket.getClass()) {
            this.doUnregisterWebSocket(new WebSocketModel(null, (Class)webSocket));
        } else {
            this.doUnregisterWebSocket(new WebSocketModel(webSocket, null));
        }
    }

    private void doUnregisterWebSocket(WebSocketModel model) {
        Object instance = model.getWebSocketEndpoint();
        Class endpointClass = model.getWebSocketEndpointClass();
        ServiceReference reference = model.getElementReference();
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        Bundle registeringBundle = model.getRegisteringBundle();
        this.event(WebElementEvent.State.UNDEPLOYING, (ElementModel<?, ?>)model);
        try {
            this.serverModel.run(() -> {
                try {
                    LinkedList<WebSocketModel> toUnregister = new LinkedList<WebSocketModel>();
                    for (WebSocketModel existing : this.serviceModel.getWebSocketModels()) {
                        if (existing != model) continue;
                        LOG.info("Unregistering web socket model \"{}\"", (Object)model);
                        toUnregister.add(existing);
                        break;
                    }
                    if (toUnregister.isEmpty()) {
                        if (endpointClass != null) {
                            LOG.info("Unregistering web socket by class \"{}\"", (Object)endpointClass);
                            for (WebSocketModel existing : this.serviceModel.getWebSocketModels()) {
                                if (!endpointClass.equals(existing.getWebSocketEndpointClass())) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Web Socket of \"" + endpointClass.getName() + "\" class was never registered by " + registeringBundle);
                            }
                        } else if (reference != null) {
                            LOG.info("Unregistering webs ocket by refernce \"{}\"", (Object)reference);
                            for (WebSocketModel existing : this.serviceModel.getWebSocketModels()) {
                                if (!existing.getElementReference().equals(reference)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Web Socket with reference \"" + reference + "\" was never registered by " + registeringBundle);
                            }
                        } else if (instance != null) {
                            LOG.info("Unregistering web socket \"{}\"", instance);
                            for (WebSocketModel existing : this.serviceModel.getWebSocketModels()) {
                                if (!existing.getWebSocketEndpoint().equals(instance)) continue;
                                toUnregister.add(existing);
                            }
                            if (toUnregister.size() == 0) {
                                throw new IllegalArgumentException("Web Socket \"" + instance + "\" was never registered by " + registeringBundle);
                            }
                        }
                    }
                    if (toUnregister.isEmpty()) {
                        throw new IllegalArgumentException("Can't find a web socket to unregister using criteria from " + model);
                    }
                    Batch batch = new Batch("Unregistration of web sockets: " + toUnregister);
                    ArrayList models = new ArrayList();
                    for (WebSocketModel wsm : toUnregister) {
                        models.addAll(wsm.getContextModels());
                    }
                    batch.clearDynamicRegistrations(models);
                    for (WebSocketModel wsm : toUnregister) {
                        for (ContainerInitializerModel cim : this.serverModel.getContainerInitializerModels()) {
                            if (!cim.getRelatedWebSocketModels().remove(wsm) || !cim.getRelatedWebSocketModels().isEmpty()) continue;
                            batch.removeContainerInitializerModels(Collections.singletonList(cim));
                        }
                    }
                    this.serverModel.removeWebSocketModels(toUnregister, batch);
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.UNDEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, false);
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void registerLoginConfig(String authMethod, String realmName, String formLoginPage, String formErrorPage, HttpContext httpContext) {
        SecurityConfigurationModel model = new SecurityConfigurationModel();
        LoginConfigModel lcm = new LoginConfigModel();
        lcm.setAuthMethod(authMethod);
        lcm.setRealmName(realmName);
        lcm.setFormLoginPage(formLoginPage);
        lcm.setFormErrorPage(formErrorPage);
        model.setLoginConfig(lcm);
        model.getSecurityConstraints().clear();
        model.getSecurityRoles().clear();
        this.doRegisterSecurityConfiguration(Collections.singletonList(httpContext), model);
    }

    public void registerConstraintMapping(String constraintName, String httpMethod, String url, String dataConstraint, boolean authentication, List<String> roles, HttpContext httpContext) {
        SecurityConfigurationModel model = new SecurityConfigurationModel();
        model.setLoginConfig(null);
        SecurityConstraintModel scm = new SecurityConstraintModel();
        scm.setName(constraintName);
        scm.setAuthRolesSet(true);
        if (dataConstraint == null) {
            scm.setTransportGuarantee(ServletSecurity.TransportGuarantee.NONE);
        } else {
            scm.setTransportGuarantee(ServletSecurity.TransportGuarantee.valueOf((String)dataConstraint.toUpperCase()));
        }
        SecurityConstraintModel.WebResourceCollection wrc = new SecurityConstraintModel.WebResourceCollection();
        wrc.setName(constraintName);
        if (httpMethod != null) {
            wrc.getMethods().add(httpMethod);
        }
        wrc.getPatterns().add(url);
        scm.getWebResourceCollections().add(wrc);
        if (roles != null) {
            scm.getAuthRoles().addAll(roles);
            model.getSecurityRoles().addAll(roles);
        }
        model.getSecurityConstraints().add(scm);
        this.doRegisterSecurityConfiguration(Collections.singletonList(httpContext), model);
    }

    private void doRegisterSecurityConfiguration(List<HttpContext> httpContexts, SecurityConfigurationModel model) {
        LOG.debug("Passing registration of {} to configuration thread", (Object)model);
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        this.event(WebElementEvent.State.DEPLOYING, (ElementModel<?, ?>)model);
        Batch batch = new Batch("Registration of " + model);
        try {
            this.serverModel.run(() -> {
                try {
                    this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                    try {
                        model.performValidation();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    LOG.info("Registering {}", (Object)model);
                    for (OsgiContextModel ocm : model.getContextModels()) {
                        batch.getOperations().add(new ContextStopChange(OpCode.MODIFY, ocm));
                        batch.getOperations().add(new SecurityConfigChange(OpCode.ADD, ocm, model.getLoginConfig(), model.getSecurityConstraints(), new ArrayList(model.getSecurityRoles())));
                        batch.getOperations().add(new ContextStartChange(OpCode.MODIFY, ocm));
                    }
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.DEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, model.isAsynchronusRegistration());
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    public void unregisterLoginConfig(HttpContext httpContext) {
        SecurityConfigurationModel model = new SecurityConfigurationModel();
        model.setLoginConfig(new LoginConfigModel());
        this.doUnregisterSecurityConfiguration(Collections.singletonList(httpContext), model);
    }

    public void unregisterConstraintMapping(HttpContext httpContext) {
        SecurityConfigurationModel model = new SecurityConfigurationModel();
        model.setLoginConfig(null);
        this.doUnregisterSecurityConfiguration(Collections.singletonList(httpContext), model);
    }

    private void doUnregisterSecurityConfiguration(List<HttpContext> httpContexts, SecurityConfigurationModel model) {
        if (model.getRegisteringBundle() == null) {
            model.setRegisteringBundle(this.serviceBundle);
        }
        Bundle registeringBundle = model.getRegisteringBundle();
        Batch batch = new Batch("Unregistration of " + model);
        this.event(WebElementEvent.State.UNDEPLOYING, (ElementModel<?, ?>)model);
        try {
            this.serverModel.run(() -> {
                try {
                    this.translateContexts(httpContexts, (ElementModel<?, ?>)model, batch);
                    LOG.info("Unregistering {}", (Object)model);
                    for (OsgiContextModel ocm : model.getContextModels()) {
                        batch.getOperations().add(new ContextStopChange(OpCode.MODIFY, ocm));
                        batch.getOperations().add(new SecurityConfigChange(OpCode.DELETE, ocm, model.getLoginConfig(), model.getSecurityConstraints(), new ArrayList(model.getSecurityRoles())));
                        batch.getOperations().add(new ContextStartChange(OpCode.MODIFY, ocm));
                    }
                    this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)this.serviceModel);
                    this.event(WebElementEvent.State.UNDEPLOYED, (ElementModel<?, ?>)model);
                    return null;
                }
                catch (Exception e) {
                    this.event(WebElementEvent.State.FAILED, (ElementModel<?, ?>)model, e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }, false);
        }
        catch (ServletException | NamespaceException throwable) {
            // empty catch block
        }
    }

    private void event(WebElementEvent.State type, ElementModel<?, ?> model) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.registrationEvent(new WebElementEvent(type, model.asEventData()));
        }
    }

    private void event(WebElementEvent.State type, ElementModel<?, ?> model, Exception exception) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.registrationEvent(new WebElementEvent(type, model.asEventData(), exception));
        }
    }

    private void translateContexts(Collection<HttpContext> httpContexts, ElementModel<?, ?> model, Batch batch) {
        if (httpContexts.size() > 0 && !model.hasContextModels()) {
            Collection webContexts = httpContexts.stream().map(this::unify).collect(Collectors.toList());
            webContexts.forEach(wc -> {
                OsgiContextModel contextModel = this.serverModel.getOrCreateOsgiContextModel(wc, this.serviceBundle, "/", batch);
                model.addContextModel(contextModel);
            });
            model.getContextModels();
        }
    }

    private WebContainerContext unify(HttpContext httpContext) {
        Object context = httpContext == null ? this.createDefaultHttpContext() : (!(httpContext instanceof WebContainerContext) ? new WebContainerContextWrapper(this.serviceBundle, httpContext) : (WebContainerContext)httpContext);
        return context;
    }

    public String toString() {
        return "HttpService (enabled) for bundle " + this.serviceBundle;
    }

    private static class ResourceServlet {
        public final Supplier<Servlet> supplier;
        public final URL urlBase;
        public final String chrootBase;

        ResourceServlet(Supplier<Servlet> supplier, URL urlBase, String chrootBase) {
            this.supplier = supplier;
            this.urlBase = urlBase;
            this.chrootBase = chrootBase;
        }
    }

    private class ReportWebContainer
    implements ReportWebContainerView {
        private ReportWebContainer() {
        }

        public Set<WebApplicationInfo> listWebApplications() {
            TreeSet<WebApplicationInfo> webapps = new TreeSet<WebApplicationInfo>();
            HttpServiceEnabled.this.serverModel.collectWebApplications(webapps);
            return webapps;
        }

        public WebApplicationInfo getWebApplication(String contextPath) {
            return HttpServiceEnabled.this.serverModel.getWebApplication(contextPath);
        }

        public WebApplicationInfo getWebApplication(long bundleId) {
            return HttpServiceEnabled.this.serverModel.getWebApplication(bundleId);
        }

        public Set<ServletInfo> listServlets() {
            TreeSet<ServletInfo> servlets = new TreeSet<ServletInfo>();
            HttpServiceEnabled.this.serverModel.collectServlets(servlets);
            return servlets;
        }
    }

    private class WebAppWebContainer
    implements WebAppWebContainerView {
        private WebAppWebContainer() {
        }

        public void sendBatch(Batch batch) {
            HttpServiceEnabled.this.serverModel.runSilently(() -> {
                String name = Thread.currentThread().getName();
                try {
                    if (batch.getShortDescription() != null) {
                        Thread.currentThread().setName(name + " (" + batch.getShortDescription() + ")");
                    }
                    if (HttpServiceEnabled.this.stopped) {
                        LOG.info("WebContainer is already stopped.");
                        Object var3_3 = null;
                        return var3_3;
                    }
                    for (Change change : batch.getOperations()) {
                        if (change.getKind() != OpCode.ADD || !(change instanceof ServletModelChange)) continue;
                        ServletModel model = ((ServletModelChange)change).getServletModel();
                        if (model.isResourceServlet()) {
                            ResourceServlet rs = HttpServiceEnabled.this.createResourceServlet(model.getUrlPatterns(), "");
                            model.setElementSupplier(rs.supplier);
                        }
                        if (!model.isJspServlet() && (model.getServletClass() == null || !"org.ops4j.pax.web.jsp.JspServlet".equals(model.getServletClass().getName()))) continue;
                        model.configureJspServlet(HttpServiceEnabled.this.configuration.jsp());
                    }
                    HttpServiceEnabled.this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)HttpServiceEnabled.this.serviceModel);
                    Iterator iterator = null;
                    return iterator;
                }
                finally {
                    Thread.currentThread().setName(name);
                }
            }, false);
        }

        public WebAppWebContainerView.AllocationStatus allocateContext(Bundle wab, String contextPath) {
            return (WebAppWebContainerView.AllocationStatus)HttpServiceEnabled.this.serverModel.runSilently(() -> {
                if (HttpServiceEnabled.this.stopped) {
                    LOG.info("WebContainer is already stopped.");
                    return WebAppWebContainerView.AllocationStatus.SERVICE_STOPPED;
                }
                OsgiContextModel ocm = HttpServiceEnabled.this.serverModel.getWabContext(contextPath, wab, true);
                return ocm != null ? WebAppWebContainerView.AllocationStatus.ALLOCATED : WebAppWebContainerView.AllocationStatus.NOT_AVAILABLE;
            }, false);
        }

        public ServletContextModel getServletContext(Bundle wab, String contextPath) {
            OsgiContextModel ocm = HttpServiceEnabled.this.serverModel.getWabContext(contextPath, wab, false);
            return ocm == null ? null : HttpServiceEnabled.this.serverModel.getServletContextModel(ocm.getContextPath());
        }

        public OsgiContextModel getOsgiContext(Bundle wab, String contextPath) {
            return HttpServiceEnabled.this.serverModel.getWabContext(contextPath, wab, false);
        }

        public void releaseContext(Bundle wab, String contextPath) {
            HttpServiceEnabled.this.serverModel.runSilently(() -> {
                if (HttpServiceEnabled.this.stopped) {
                    LOG.info("WebContainer is already stopped.");
                    return null;
                }
                HttpServiceEnabled.this.serverModel.releaseWabContext(contextPath, wab);
                return null;
            }, false);
        }

        public void registerReportViewPlugin(ReportViewPlugin plugin) {
            HttpServiceEnabled.this.serverModel.registerReportViewPlugin(plugin);
        }

        public void unregisterReportViewPlugin(ReportViewPlugin plugin) {
            HttpServiceEnabled.this.serverModel.unregisterReportViewPlugin(plugin);
        }

        public Configuration getConfiguration() {
            return HttpServiceEnabled.this.configuration;
        }
    }

    private class ProcessingWebContainer
    implements ProcessingWebContainerView {
        private ProcessingWebContainer() {
        }

        @Override
        public OsgiContextModel getContextModel(Bundle bundle, String contextId) {
            return HttpServiceEnabled.this.serverModel.getContextModel(contextId, bundle);
        }

        @Override
        public void sendBatch(Batch batch) {
            HttpServiceEnabled.this.serverModel.runSilently(() -> {
                HttpServiceEnabled.this.serverController.sendBatch(batch);
                return null;
            }, true);
        }
    }

    private class DirectWebContainer
    implements DirectWebContainerView {
        private DirectWebContainer() {
        }

        @Override
        public void registerServlet(Collection<HttpContext> contexts, ServletModel model) throws ServletException, NamespaceException {
            HttpServiceEnabled.this.doRegisterServlet(contexts, model);
        }

        @Override
        public void unregisterServlet(ServletModel model) {
            HttpServiceEnabled.this.doUnregisterServlet(model);
        }

        @Override
        public void registerFilter(Collection<HttpContext> contexts, FilterModel model) throws ServletException {
            HttpServiceEnabled.this.doRegisterFilter(contexts, model);
        }

        @Override
        public void unregisterFilter(FilterModel model) {
            HttpServiceEnabled.this.doUnregisterFilter(model);
        }

        @Override
        public void registerErrorPages(Collection<HttpContext> contexts, ErrorPageModel model) {
            HttpServiceEnabled.this.doRegisterErrorPages(contexts, model);
        }

        @Override
        public void unregisterErrorPages(ErrorPageModel model) {
            HttpServiceEnabled.this.doUnregisterErrorPages(model);
        }
    }

    private class WhiteboardWebContainer
    implements WhiteboardWebContainerView,
    DynamicJEEWebContainerView {
        private WhiteboardWebContainer() {
        }

        public void registerServlet(ServletModel model) {
            try {
                HttpServiceEnabled.this.doRegisterServlet(Collections.emptyList(), model);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public void unregisterServlet(ServletModel servletModel) {
            HttpServiceEnabled.this.doUnregisterServlet(servletModel);
        }

        public void registerResources(ServletModel model) {
            String[] stringArray;
            if (model.getAlias() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = model.getAlias();
            } else {
                stringArray = model.getUrlPatterns();
            }
            String[] mapping = stringArray;
            ResourceServlet resourceServlet = HttpServiceEnabled.this.createResourceServlet(mapping, model.getRawPath());
            String name = Arrays.asList(mapping).contains("/") ? "default" : String.format("default-%s", UUID.randomUUID());
            model.setName(name);
            model.setElementSupplier(resourceServlet.supplier);
            try {
                HttpServiceEnabled.this.doRegisterServlet(Collections.emptyList(), model);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public void unregisterResources(ServletModel servletModel) {
            HttpServiceEnabled.this.doUnregisterServlet(servletModel);
        }

        public void registerFilter(FilterModel model) {
            try {
                HttpServiceEnabled.this.doRegisterFilter(Collections.emptyList(), model);
            }
            catch (ServletException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public void unregisterFilter(FilterModel filterModel) {
            HttpServiceEnabled.this.doUnregisterFilter(filterModel);
        }

        public void registerWelcomeFiles(WelcomeFileModel model) {
            HttpServiceEnabled.this.doRegisterWelcomeFiles(Collections.emptyList(), model);
        }

        public void unregisterWelcomeFiles(WelcomeFileModel model) {
            HttpServiceEnabled.this.doUnregisterWelcomeFiles(Collections.emptyList(), model);
        }

        public List<OsgiContextModel> getOsgiContextModels(Bundle bundle) {
            return HttpServiceEnabled.this.serverModel.getOsgiContextModels(bundle);
        }

        public void registerErrorPages(ErrorPageModel model) {
            HttpServiceEnabled.this.doRegisterErrorPages(Collections.emptyList(), model);
        }

        public void unregisterErrorPages(ErrorPageModel model) {
            HttpServiceEnabled.this.doUnregisterErrorPages(model);
        }

        public void registerListener(EventListenerModel model) {
            HttpServiceEnabled.this.doRegisterEventListener(Collections.emptyList(), model);
        }

        public void unregisterListener(EventListenerModel model) {
            HttpServiceEnabled.this.doUnregisterEventListener(model);
        }

        public void registerWabOsgiContextListener(WebContextEventListener whiteboardExtenderContext) {
            HttpServiceEnabled.this.serverModel.registerWabOsgiContextListener(whiteboardExtenderContext);
        }

        public void addWhiteboardOsgiContextModel(OsgiContextModel model) {
            HttpServiceEnabled.this.serverModel.runSilently(() -> {
                Batch batch = new Batch("Registration of " + model);
                HttpServiceEnabled.this.serverModel.registerOsgiContextModelIfNeeded(model, HttpServiceEnabled.this.serviceModel, batch);
                try {
                    HttpServiceEnabled.this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)HttpServiceEnabled.this.serviceModel);
                    this.handleReRegistrationEvents(WebElementEvent.State.DEPLOYED, batch, null);
                }
                catch (Exception e) {
                    this.handleReRegistrationEvents(WebElementEvent.State.FAILED, batch, e);
                }
                return null;
            }, model.isAsynchronusRegistration());
        }

        public void removeWhiteboardOsgiContextModel(OsgiContextModel model) {
            HttpServiceEnabled.this.serverModel.runSilently(() -> {
                Batch batch = new Batch("Unregistration of " + model);
                HttpServiceEnabled.this.serverModel.unregisterOsgiContextModel(model, HttpServiceEnabled.this.serviceModel, batch);
                try {
                    HttpServiceEnabled.this.serverController.sendBatch(batch);
                    batch.accept((BatchVisitor)HttpServiceEnabled.this.serviceModel);
                    this.handleReRegistrationEvents(WebElementEvent.State.DEPLOYED, batch, null);
                }
                catch (Exception e) {
                    this.handleReRegistrationEvents(WebElementEvent.State.FAILED, batch, e);
                }
                return null;
            }, model.isAsynchronusRegistration());
        }

        public void registerJsp(JspModel model) {
            String file = model.getJspFile();
            ServletModel jspServletModel = file != null ? HttpServiceEnabled.this.serverModel.createJspServletModel(HttpServiceEnabled.this.serviceBundle, file, file, model.getMappings(), model.getInitParams(), HttpServiceEnabled.this.configuration.jsp()) : HttpServiceEnabled.this.serverModel.createJspServletModel(HttpServiceEnabled.this.serviceBundle, "jsp", null, model.getMappings(), model.getInitParams(), HttpServiceEnabled.this.configuration.jsp());
            for (OsgiContextModel ocm : model.getContextModels()) {
                jspServletModel.addContextModel(ocm);
            }
            model.setServletModel(jspServletModel);
            this.registerServlet(jspServletModel);
        }

        public void unregisterJsp(JspModel model) {
            if (model.getServletModel() != null) {
                this.unregisterServlet(model.getServletModel());
            } else {
                HttpServiceEnabled.this.unregisterServlet(model.getJspFile() == null ? "jsp" : model.getJspFile());
            }
        }

        public void registerWebSocket(WebSocketModel model) {
            HttpServiceEnabled.this.doRegisterWebSocket(Collections.emptyList(), model);
        }

        public void unregisterWebSocket(WebSocketModel model) {
            HttpServiceEnabled.this.doUnregisterWebSocket(model);
        }

        public void registerSecurityConfiguration(SecurityConfigurationModel model) {
            HttpServiceEnabled.this.doRegisterSecurityConfiguration(Collections.emptyList(), model);
        }

        public void unregisterSecurityConfiguration(SecurityConfigurationModel model) {
            HttpServiceEnabled.this.doUnregisterSecurityConfiguration(Collections.emptyList(), model);
        }

        public void failedDTOInformation(ElementModel<?, ?> webElement) {
            HttpServiceEnabled.this.serverModel.runSilently(() -> {
                HttpServiceEnabled.this.serverModel.getFailedWhiteboardElements().add(webElement);
                return null;
            }, webElement.isAsynchronusRegistration());
        }

        public void failedDTOInformation(OsgiContextModel webContext) {
            HttpServiceEnabled.this.serverModel.runSilently(() -> {
                HttpServiceEnabled.this.serverModel.addWhiteboardContext(webContext);
                return null;
            }, webContext.isAsynchronusRegistration());
        }

        public void clearFailedDTOInformation(ElementModel<?, ?> webElement) {
            HttpServiceEnabled.this.serverModel.runSilently(() -> {
                HttpServiceEnabled.this.serverModel.getFailedWhiteboardElements().remove(webElement);
                return null;
            }, true);
        }

        public void clearFailedDTOInformation(OsgiContextModel webContext) {
            HttpServiceEnabled.this.serverModel.runSilently(() -> {
                HttpServiceEnabled.this.serverModel.removeWhiteboardContext(webContext);
                return null;
            }, true);
        }

        private void handleReRegistrationEvents(WebElementEvent.State state, Batch batch, Exception e) {
            if (e == null) {
                for (Change change : batch.getOperations()) {
                    if (change.getKind() != OpCode.ADD) continue;
                    if (change instanceof ContainerInitializerModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((ContainerInitializerModelChange)change).getContainerInitializerModel());
                        continue;
                    }
                    if (change instanceof EventListenerModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((EventListenerModelChange)change).getEventListenerModel());
                        continue;
                    }
                    if (change instanceof ServletModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((ServletModelChange)change).getServletModel());
                        continue;
                    }
                    if (change instanceof WelcomeFileModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((WelcomeFileModelChange)change).getWelcomeFileModel());
                        continue;
                    }
                    if (change instanceof ErrorPageModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((ErrorPageModelChange)change).getErrorPageModel());
                        continue;
                    }
                    if (!(change instanceof FilterModelChange)) continue;
                    HttpServiceEnabled.this.event(state, (ElementModel)((FilterModelChange)change).getFilterModel());
                }
            } else {
                for (Change change : batch.getOperations()) {
                    if (change.getKind() != OpCode.ADD) continue;
                    if (change instanceof ContainerInitializerModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((ContainerInitializerModelChange)change).getContainerInitializerModel(), e);
                        continue;
                    }
                    if (change instanceof EventListenerModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((EventListenerModelChange)change).getEventListenerModel(), e);
                        continue;
                    }
                    if (change instanceof ServletModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((ServletModelChange)change).getServletModel(), e);
                        continue;
                    }
                    if (change instanceof WelcomeFileModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((WelcomeFileModelChange)change).getWelcomeFileModel(), e);
                        continue;
                    }
                    if (change instanceof ErrorPageModelChange) {
                        HttpServiceEnabled.this.event(state, (ElementModel)((ErrorPageModelChange)change).getErrorPageModel(), e);
                        continue;
                    }
                    if (!(change instanceof FilterModelChange)) continue;
                    HttpServiceEnabled.this.event(state, (ElementModel)((FilterModelChange)change).getFilterModel(), e);
                }
            }
        }
    }
}

