/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkApplicationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PAPPLICATIONNAME;
    public static final int APPLICATIONVERSION;
    public static final int PENGINENAME;
    public static final int ENGINEVERSION;
    public static final int APIVERSION;

    public VkApplicationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkApplicationInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkApplicationInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkApplicationInfo.npNext(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer pApplicationName() {
        return VkApplicationInfo.npApplicationName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String pApplicationNameString() {
        return VkApplicationInfo.npApplicationNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int applicationVersion() {
        return VkApplicationInfo.napplicationVersion(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer pEngineName() {
        return VkApplicationInfo.npEngineName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String pEngineNameString() {
        return VkApplicationInfo.npEngineNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int engineVersion() {
        return VkApplicationInfo.nengineVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int apiVersion() {
        return VkApplicationInfo.napiVersion(this.address());
    }

    public VkApplicationInfo sType(@NativeType(value="VkStructureType") int value) {
        VkApplicationInfo.nsType(this.address(), value);
        return this;
    }

    public VkApplicationInfo sType$Default() {
        return this.sType(0);
    }

    public VkApplicationInfo pNext(@NativeType(value="void const *") long value) {
        VkApplicationInfo.npNext(this.address(), value);
        return this;
    }

    public VkApplicationInfo pApplicationName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        VkApplicationInfo.npApplicationName(this.address(), value);
        return this;
    }

    public VkApplicationInfo applicationVersion(@NativeType(value="uint32_t") int value) {
        VkApplicationInfo.napplicationVersion(this.address(), value);
        return this;
    }

    public VkApplicationInfo pEngineName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        VkApplicationInfo.npEngineName(this.address(), value);
        return this;
    }

    public VkApplicationInfo engineVersion(@NativeType(value="uint32_t") int value) {
        VkApplicationInfo.nengineVersion(this.address(), value);
        return this;
    }

    public VkApplicationInfo apiVersion(@NativeType(value="uint32_t") int value) {
        VkApplicationInfo.napiVersion(this.address(), value);
        return this;
    }

    public VkApplicationInfo set(int sType, long pNext, @Nullable ByteBuffer pApplicationName, int applicationVersion, @Nullable ByteBuffer pEngineName, int engineVersion, int apiVersion) {
        this.sType(sType);
        this.pNext(pNext);
        this.pApplicationName(pApplicationName);
        this.applicationVersion(applicationVersion);
        this.pEngineName(pEngineName);
        this.engineVersion(engineVersion);
        this.apiVersion(apiVersion);
        return this;
    }

    public VkApplicationInfo set(VkApplicationInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkApplicationInfo malloc() {
        return (VkApplicationInfo)VkApplicationInfo.wrap(VkApplicationInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkApplicationInfo calloc() {
        return (VkApplicationInfo)VkApplicationInfo.wrap(VkApplicationInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkApplicationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkApplicationInfo)VkApplicationInfo.wrap(VkApplicationInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkApplicationInfo create(long address) {
        return (VkApplicationInfo)VkApplicationInfo.wrap(VkApplicationInfo.class, (long)address);
    }

    @Nullable
    public static VkApplicationInfo createSafe(long address) {
        return address == 0L ? null : (VkApplicationInfo)VkApplicationInfo.wrap(VkApplicationInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkApplicationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkApplicationInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkApplicationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkApplicationInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkApplicationInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkApplicationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkApplicationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkApplicationInfo mallocStack() {
        return VkApplicationInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkApplicationInfo callocStack() {
        return VkApplicationInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkApplicationInfo mallocStack(MemoryStack stack) {
        return VkApplicationInfo.malloc(stack);
    }

    @Deprecated
    public static VkApplicationInfo callocStack(MemoryStack stack) {
        return VkApplicationInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkApplicationInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkApplicationInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkApplicationInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkApplicationInfo.calloc(capacity, stack);
    }

    public static VkApplicationInfo malloc(MemoryStack stack) {
        return (VkApplicationInfo)VkApplicationInfo.wrap(VkApplicationInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkApplicationInfo calloc(MemoryStack stack) {
        return (VkApplicationInfo)VkApplicationInfo.wrap(VkApplicationInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkApplicationInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkApplicationInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    @Nullable
    public static ByteBuffer npApplicationName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PAPPLICATIONNAME)));
    }

    @Nullable
    public static String npApplicationNameString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PAPPLICATIONNAME)));
    }

    public static int napplicationVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)APPLICATIONVERSION);
    }

    @Nullable
    public static ByteBuffer npEngineName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PENGINENAME)));
    }

    @Nullable
    public static String npEngineNameString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PENGINENAME)));
    }

    public static int nengineVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENGINEVERSION);
    }

    public static int napiVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)APIVERSION);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npApplicationName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PAPPLICATIONNAME), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void napplicationVersion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)APPLICATIONVERSION, value);
    }

    public static void npEngineName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PENGINENAME), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nengineVersion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENGINEVERSION, value);
    }

    public static void napiVersion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)APIVERSION, value);
    }

    static {
        Struct.Layout layout = VkApplicationInfo.__struct((Struct.Member[])new Struct.Member[]{VkApplicationInfo.__member((int)4), VkApplicationInfo.__member((int)POINTER_SIZE), VkApplicationInfo.__member((int)POINTER_SIZE), VkApplicationInfo.__member((int)4), VkApplicationInfo.__member((int)POINTER_SIZE), VkApplicationInfo.__member((int)4), VkApplicationInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PAPPLICATIONNAME = layout.offsetof(2);
        APPLICATIONVERSION = layout.offsetof(3);
        PENGINENAME = layout.offsetof(4);
        ENGINEVERSION = layout.offsetof(5);
        APIVERSION = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkApplicationInfo, Buffer>
    implements NativeResource {
        private static final VkApplicationInfo ELEMENT_FACTORY = VkApplicationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkApplicationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkApplicationInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkApplicationInfo.npNext(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer pApplicationName() {
            return VkApplicationInfo.npApplicationName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String pApplicationNameString() {
            return VkApplicationInfo.npApplicationNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int applicationVersion() {
            return VkApplicationInfo.napplicationVersion(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer pEngineName() {
            return VkApplicationInfo.npEngineName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String pEngineNameString() {
            return VkApplicationInfo.npEngineNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int engineVersion() {
            return VkApplicationInfo.nengineVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int apiVersion() {
            return VkApplicationInfo.napiVersion(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkApplicationInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(0);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkApplicationInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pApplicationName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            VkApplicationInfo.npApplicationName(this.address(), value);
            return this;
        }

        public Buffer applicationVersion(@NativeType(value="uint32_t") int value) {
            VkApplicationInfo.napplicationVersion(this.address(), value);
            return this;
        }

        public Buffer pEngineName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            VkApplicationInfo.npEngineName(this.address(), value);
            return this;
        }

        public Buffer engineVersion(@NativeType(value="uint32_t") int value) {
            VkApplicationInfo.nengineVersion(this.address(), value);
            return this;
        }

        public Buffer apiVersion(@NativeType(value="uint32_t") int value) {
            VkApplicationInfo.napiVersion(this.address(), value);
            return this;
        }
    }
}

