/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.event.CounterListener;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.TransportType;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.util.WorkerTask;

public class MultiThreadedMessageDispatcher
implements MessageDispatcher {
    private final MessageDispatcher dispatcher;
    private final WorkerPool threadPool;

    public MultiThreadedMessageDispatcher(WorkerPool workerPool, MessageDispatcher decoratedDispatcher) {
        this.threadPool = workerPool;
        this.dispatcher = decoratedDispatcher;
    }

    public MessageDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public int getNextRequestID() {
        return this.dispatcher.getNextRequestID();
    }

    @Override
    public void addMessageProcessingModel(MessageProcessingModel model) {
        this.dispatcher.addMessageProcessingModel(model);
    }

    @Override
    public void removeMessageProcessingModel(MessageProcessingModel model) {
        this.dispatcher.removeMessageProcessingModel(model);
    }

    @Override
    public MessageProcessingModel getMessageProcessingModel(int messageProcessingModel) {
        return this.dispatcher.getMessageProcessingModel(messageProcessingModel);
    }

    @Override
    public void addTransportMapping(TransportMapping<? extends Address> transport) {
        this.dispatcher.addTransportMapping(transport);
    }

    public TransportMapping<?> removeTransportMapping(TransportMapping<? extends Address> transport) {
        return this.dispatcher.removeTransportMapping(transport);
    }

    @Override
    public void addCounterListener(CounterListener counterListener) {
        this.dispatcher.addCounterListener(counterListener);
    }

    @Override
    public CounterListener removeCounterListener(CounterListener counterListener) {
        return this.dispatcher.removeCounterListener(counterListener);
    }

    @Override
    public Collection<TransportMapping<? extends Address>> getTransportMappings() {
        return this.dispatcher.getTransportMappings();
    }

    @Override
    public void addCommandResponder(CommandResponder listener) {
        this.dispatcher.addCommandResponder(listener);
    }

    @Override
    public void removeCommandResponder(CommandResponder listener) {
        this.dispatcher.removeCommandResponder(listener);
    }

    @Override
    public <A extends Address> PduHandle sendPdu(Target<A> target, PDU pdu, boolean expectResponse) throws MessageException {
        return this.dispatcher.sendPdu(target, pdu, expectResponse);
    }

    @Override
    public <A extends Address> PduHandle sendPdu(TransportMapping<? super A> transportMapping, Target<A> target, PDU pdu, boolean expectResponse) throws MessageException {
        return this.dispatcher.sendPdu(transportMapping, target, pdu, expectResponse);
    }

    @Override
    public <A extends Address> PduHandle sendPdu(TransportMapping<? super A> transportMapping, Target<A> target, PDU pdu, boolean expectResponse, PduHandleCallback<PDU> callback) throws MessageException {
        return this.dispatcher.sendPdu(transportMapping, target, pdu, expectResponse, callback);
    }

    @Override
    public <A extends Address> int returnResponsePdu(int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, int maxSizeResponseScopedPDU, StateReference<A> stateReference, StatusInformation statusInformation) throws MessageException {
        return this.dispatcher.returnResponsePdu(messageProcessingModel, securityModel, securityName, securityLevel, pdu, maxSizeResponseScopedPDU, stateReference, statusInformation);
    }

    @Override
    public void releaseStateReference(int messageProcessingModel, PduHandle pduHandle) {
        this.dispatcher.releaseStateReference(messageProcessingModel, pduHandle);
    }

    @Override
    @Deprecated
    public <A extends Address> TransportMapping<? super A> getTransport(A destAddress) {
        TransportMapping<A> transportMapping = this.getTransport(destAddress, TransportType.receiver);
        if (transportMapping == null) {
            transportMapping = this.getTransport(destAddress, TransportType.sender);
        }
        return transportMapping;
    }

    @Override
    public <A extends Address> TransportMapping<? super A> getTransport(A destAddress, TransportType transportType) {
        return this.dispatcher.getTransport(destAddress, transportType);
    }

    @Override
    public <A extends Address> void processMessage(TransportMapping<? super A> sourceTransport, A incomingAddress, ByteBuffer wholeMessage, TransportStateReference tmStateReference) {
        MessageTask task = new MessageTask(this, sourceTransport, incomingAddress, wholeMessage, tmStateReference);
        this.threadPool.execute(task);
    }

    @Override
    public void stop() {
        this.threadPool.stop();
    }

    static class MessageTask<A extends Address>
    implements WorkerTask {
        private final TransportMapping<? super A> sourceTransport;
        private final A incomingAddress;
        private final ByteBuffer wholeMessage;
        private final TransportStateReference tmStateReference;
        final /* synthetic */ MultiThreadedMessageDispatcher this$0;

        public MessageTask(TransportMapping<? super A> sourceTransport, A incomingAddress, ByteBuffer wholeMessage, TransportStateReference tmStateReference) {
            this.this$0 = this$0;
            this.sourceTransport = sourceTransport;
            this.incomingAddress = incomingAddress;
            this.wholeMessage = wholeMessage;
            this.tmStateReference = tmStateReference;
        }

        @Override
        public void run() {
            this.this$0.dispatcher.processMessage(this.sourceTransport, this.incomingAddress, this.wholeMessage, this.tmStateReference);
        }

        @Override
        public void terminate() {
        }

        @Override
        public void join() throws InterruptedException {
        }

        @Override
        public void interrupt() {
        }
    }
}

