/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonParser;
import com.jrjackson.IParseHandler;
import com.jrjackson.JavaConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class JavaHandler
implements IParseHandler<Object, ArrayList<Object>, HashMap<String, Object>> {
    private Object _result;
    private final JavaConverter _intConv;
    private final JavaConverter _floatConv;

    public JavaHandler(JavaConverter intConverter, JavaConverter floatConverter) {
        this._intConv = intConverter;
        this._floatConv = floatConverter;
    }

    @Override
    public void addValue(Object value) {
        this._result = value;
    }

    @Override
    public Object hashStart() {
        return new HashMap();
    }

    @Override
    public void hashEnd() {
    }

    @Override
    public Object hashKey(String key) {
        return key;
    }

    @Override
    public void hashSet(HashMap<String, Object> hash, Object key, Object value) {
        hash.put((String)key, value);
    }

    @Override
    public Object arrayStart() {
        return new ArrayList();
    }

    @Override
    public void arrayEnd() {
    }

    @Override
    public void arrayAppend(ArrayList<Object> array, Object value) {
        array.add(value);
    }

    @Override
    public Object treatNull() {
        return null;
    }

    @Override
    public Object treatInt(JsonParser jp) throws IOException {
        return this._intConv.convert(jp);
    }

    @Override
    public Object treatFloat(JsonParser jp) throws IOException {
        return this._floatConv.convert(jp);
    }

    @Override
    public Object treatString(JsonParser jp) throws IOException {
        return jp.getText();
    }

    @Override
    public Object trueValue() {
        return true;
    }

    @Override
    public Object falseValue() {
        return false;
    }

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void raiseError(String e) {
    }
}

