/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import co.elastic.logstash.api.TimerMetric;
import co.elastic.logstash.api.UserMetric;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.logstash.ackedqueue.RelativeSpendMetric;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.UptimeMetric;
import org.logstash.instrument.metrics.timer.TimerMetric;
import org.logstash.instrument.metrics.timer.TimerMetricFactory;

class CalculatedRelativeSpendMetric
extends AbstractMetric<Double>
implements RelativeSpendMetric {
    private static final MathContext LIMITED_PRECISION = new MathContext(4, RoundingMode.HALF_UP);
    private final TimerMetric spendMetric;
    private final UptimeMetric uptimeMetric;
    public static UserMetric.Factory<RelativeSpendMetric> FACTORY = RelativeSpendMetric.PROVIDER.getFactory(CalculatedRelativeSpendMetric::new);

    public CalculatedRelativeSpendMetric(String name) {
        this(name, TimerMetricFactory.getInstance().create(name + ":spend"), new UptimeMetric(name + ":uptime"));
    }

    CalculatedRelativeSpendMetric(String name, TimerMetric spendMetric, UptimeMetric uptimeMetric) {
        super(name);
        this.spendMetric = spendMetric;
        this.uptimeMetric = uptimeMetric;
    }

    @Override
    public <T, E extends Throwable> T time(TimerMetric.ExceptionalSupplier<T, E> exceptionalSupplier) throws E {
        return this.spendMetric.time(exceptionalSupplier);
    }

    @Override
    public void reportUntrackedMillis(long untrackedMillis) {
        this.spendMetric.reportUntrackedMillis(untrackedMillis);
    }

    @Override
    public Double getValue() {
        BigDecimal spend = BigDecimal.valueOf(this.spendMetric.getValue());
        BigDecimal uptime = BigDecimal.valueOf(this.uptimeMetric.getValue());
        if (uptime.signum() == 0) {
            switch (spend.signum()) {
                case -1: {
                    return Double.NEGATIVE_INFINITY;
                }
                case 0: {
                    return 0.0;
                }
                case 1: {
                    return Double.POSITIVE_INFINITY;
                }
            }
        }
        return spend.divide(uptime, LIMITED_PRECISION).doubleValue();
    }
}

