/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import java.util.ArrayList;
import org.logstash.ackedqueue.CompressionCodec;
import org.logstash.ackedqueue.QueueRuntimeException;
import org.logstash.ackedqueue.Queueable;

public interface Settings {
    public Class<? extends Queueable> getElementClass();

    public String getDirPath();

    public int getCapacity();

    public long getQueueMaxBytes();

    public int getMaxUnread();

    public int getCheckpointMaxAcks();

    public int getCheckpointMaxWrites();

    public boolean getCheckpointRetry();

    public CompressionCodec.Factory getCompressionCodecFactory();

    public static Settings ensureValid(Settings settings) {
        ArrayList<String> errors = new ArrayList<String>();
        if (settings == null) {
            errors.add("settings cannot be null");
        } else {
            if (settings.getDirPath() == null) {
                errors.add("dirPath cannot be null");
            }
            if (settings.getElementClass() == null) {
                errors.add("elementClass cannot be null");
            }
        }
        if (!errors.isEmpty()) {
            throw new QueueRuntimeException(String.format("Invalid Queue Settings: %s", errors));
        }
        return settings;
    }

    public static interface Builder {
        public Builder elementClass(Class<? extends Queueable> var1);

        public Builder capacity(int var1);

        public Builder queueMaxBytes(long var1);

        public Builder maxUnread(int var1);

        public Builder checkpointMaxAcks(int var1);

        public Builder checkpointMaxWrites(int var1);

        public Builder checkpointRetry(boolean var1);

        public Builder compressionCodecFactory(CompressionCodec.Factory var1);

        public Settings build();
    }
}

