/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import java.util.Objects;

public class BaseLease
implements Comparable<BaseLease> {
    private final String partitionId;
    private String owner = "";
    private transient boolean isOwned = false;

    protected BaseLease() {
        this.partitionId = "-1";
    }

    public BaseLease(String partitionId) {
        Objects.requireNonNull(partitionId, "'partitionId' cannot be null.");
        if (partitionId.isEmpty()) {
            throw new IllegalArgumentException("partitionId is Empty");
        }
        this.partitionId = partitionId;
    }

    public BaseLease(String partitionId, String owner, boolean isOwned) {
        Objects.requireNonNull(partitionId, "'partitionId' cannot be null.");
        if (partitionId.isEmpty()) {
            throw new IllegalArgumentException("partitionId is Empty");
        }
        this.partitionId = partitionId;
        this.owner = owner;
        this.isOwned = isOwned;
    }

    public BaseLease(BaseLease source) {
        Objects.requireNonNull(source.partitionId, "'source.partitionId' cannot be null.");
        if (source.partitionId.isEmpty()) {
            throw new IllegalArgumentException("partitionId is Empty");
        }
        this.partitionId = source.partitionId;
        this.owner = source.owner;
        this.isOwned = source.isOwned;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setIsOwned(boolean newState) {
        this.isOwned = newState;
    }

    public boolean getIsOwned() {
        return this.isOwned;
    }

    public boolean isOwnedBy(String possibleOwner) {
        boolean retval = false;
        if (this.owner != null) {
            retval = this.owner.compareTo(possibleOwner) == 0;
        }
        return retval;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    @Override
    public int compareTo(BaseLease other) {
        return this.partitionId.compareTo(other.getPartitionId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseLease baseLease = (BaseLease)o;
        return Objects.equals(this.partitionId, baseLease.partitionId);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId);
    }

    String getStateDebug() {
        return "N/A";
    }
}

