/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SequenceDescriptor
extends PrivilegedSQLObject
implements Provider,
Dependent {
    private UUID sequenceUUID;
    private String sequenceName;
    private final SchemaDescriptor schemaDescriptor;
    private UUID schemaId;
    private DataTypeDescriptor dataType;
    private Long currentValue;
    private long startValue;
    private long minimumValue;
    private long maximumValue;
    private long increment;
    private boolean canCycle;

    public SequenceDescriptor(DataDictionary dataDictionary, SchemaDescriptor sd, UUID sequenceUUID, String sequenceName, DataTypeDescriptor dataType, Long currentValue, long startValue, long minimumValue, long maximumValue, long increment, boolean canCycle) {
        super(dataDictionary);
        if (sd.getSchemaName() == null) {
            SanityManager.THROWASSERT((String)("new SequenceDescriptor() schema name is null for Sequence " + sequenceName));
        }
        this.sequenceUUID = sequenceUUID;
        this.schemaDescriptor = sd;
        this.sequenceName = sequenceName;
        this.schemaId = sd.getUUID();
        this.dataType = dataType;
        this.currentValue = currentValue;
        this.startValue = startValue;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.increment = increment;
        this.canCycle = canCycle;
    }

    @Override
    public UUID getUUID() {
        return this.sequenceUUID;
    }

    @Override
    public String getObjectTypeName() {
        return "SEQUENCE";
    }

    public String toString() {
        return "sequenceUUID: " + String.valueOf(this.sequenceUUID) + "\nsequenceName: " + this.sequenceName + "\nschemaId: " + String.valueOf(this.schemaId) + "\ndataType: " + this.dataType.getTypeName() + "\ncurrentValue: " + this.currentValue + "\nstartValue: " + this.startValue + "\nminimumValue: " + this.minimumValue + "\nmaximumValue: " + this.maximumValue + "\nincrement: " + this.increment + "\ncanCycle: " + this.canCycle + "\n";
    }

    public void drop(LanguageConnectionContext lcc) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dm.invalidateFor(this, 49, lcc);
        dd.dropSequenceDescriptor(this, tc);
        dm.clearDependencies(lcc, this);
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            default: 
        }
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 14: {
                DependencyManager dm = this.getDataDictionary().getDependencyManager();
                dm.invalidateFor(this, 11, lcc);
                break;
            }
        }
    }

    @Override
    public String getName() {
        return this.sequenceName;
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.schemaDescriptor;
    }

    @Override
    public String getDescriptorType() {
        return "Sequence";
    }

    @Override
    public String getDescriptorName() {
        return this.sequenceName;
    }

    @Override
    public UUID getObjectID() {
        return this.sequenceUUID;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public String getObjectName() {
        return this.sequenceName;
    }

    @Override
    public String getClassType() {
        return "Sequence";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(472);
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public UUID getSchemaId() {
        return this.schemaId;
    }

    public DataTypeDescriptor getDataType() {
        return this.dataType;
    }

    public Long getCurrentValue() {
        return this.currentValue;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public long getMinimumValue() {
        return this.minimumValue;
    }

    public long getMaximumValue() {
        return this.maximumValue;
    }

    public long getIncrement() {
        return this.increment;
    }

    public boolean canCycle() {
        return this.canCycle;
    }
}

