/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.common.io.DeadLetterQueueReader;

interface SinceDB {
    public Path getPath();

    public void flush();

    public Path getCurrentSegment();

    public long getOffset();

    public boolean isAssigned();

    public static SinceDB fromPath(Path sinceDbPath) throws IOException {
        if (sinceDbPath == null) {
            throw new IllegalArgumentException("sinceDbPath can't be null");
        }
        if (!sinceDbPath.toFile().exists()) {
            return new UnassignedDB(sinceDbPath);
        }
        byte[] bytes = Files.readAllBytes(sinceDbPath);
        if (bytes.length == 0) {
            return new UnassignedDB(sinceDbPath);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        SinceDB.verifyVersion(buffer);
        Path segmentPath = SinceDB.decodePath(buffer);
        long offset = buffer.getLong();
        return new AssignedDB(sinceDbPath, segmentPath, offset);
    }

    public static Path decodePath(ByteBuffer buffer) {
        int segmentPathStringLength = buffer.getInt();
        byte[] segmentPathBytes = new byte[segmentPathStringLength];
        buffer.get(segmentPathBytes);
        return Paths.get(new String(segmentPathBytes), new String[0]);
    }

    public static void verifyVersion(ByteBuffer buffer) {
        char version = buffer.getChar();
        if ('1' != version) {
            throw new RuntimeException("Sincedb version:" + version + " does not match: " + '1');
        }
    }

    public static SinceDB getUpdated(SinceDB oldSinceDb, DeadLetterQueueReader reader) {
        return new AssignedDB(oldSinceDb.getPath(), reader.getCurrentSegment(), reader.getCurrentPosition());
    }

    public static SinceDB tryUpdate(SinceDB oldSinceDb, DeadLetterQueueReader reader) {
        try {
            return SinceDB.getUpdated(oldSinceDb, reader);
        }
        catch (NullPointerException e) {
            return new UnassignedDB(oldSinceDb.getPath());
        }
    }

    public static final class UnassignedDB
    implements SinceDB {
        private final Path sinceDbPath;

        UnassignedDB(Path sinceDbPath) {
            this.sinceDbPath = sinceDbPath;
        }

        @Override
        public Path getPath() {
            return this.sinceDbPath;
        }

        @Override
        public boolean isAssigned() {
            return false;
        }

        @Override
        public void flush() {
        }

        @Override
        public Path getCurrentSegment() {
            throw new IllegalStateException("Unassigned SinceDB doesn't have currentSegment");
        }

        @Override
        public long getOffset() {
            throw new IllegalStateException("Unassigned SinceDB doesn't have offset");
        }
    }

    public static final class AssignedDB
    implements SinceDB {
        private static final Logger logger = LogManager.getLogger(AssignedDB.class);
        private final Path sinceDbPath;
        private final Path currentSegment;
        private final long offset;

        AssignedDB(Path sinceDbPath, Path currentSegment, long offset) {
            this.sinceDbPath = sinceDbPath;
            this.currentSegment = currentSegment;
            this.offset = offset;
        }

        @Override
        public Path getPath() {
            return this.sinceDbPath;
        }

        @Override
        public void flush() {
            if (this.currentSegment == null) {
                return;
            }
            logger.debug("Flushing DLQ last read position");
            String path = this.currentSegment.toAbsolutePath().toString();
            ByteBuffer buffer = ByteBuffer.allocate(path.length() + 1 + 64);
            buffer.putChar('1');
            buffer.putInt(path.length());
            buffer.put(path.getBytes());
            buffer.putLong(this.offset);
            try {
                Files.write(this.sinceDbPath, buffer.array(), new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error("failed to write DLQ offset state to " + this.sinceDbPath, (Throwable)e);
            }
        }

        @Override
        public Path getCurrentSegment() {
            return this.currentSegment;
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        @Override
        public boolean isAssigned() {
            return true;
        }
    }
}

