/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.mutation.internal.Handler;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public abstract class AbstractMutationHandler
implements Handler {
    private final SqmDmlStatement<?> sqmDmlStatement;
    private final SessionFactoryImplementor sessionFactory;
    private final EntityPersister entityDescriptor;

    public AbstractMutationHandler(SqmDmlStatement<?> sqmDmlStatement, SessionFactoryImplementor sessionFactory) {
        this.sqmDmlStatement = sqmDmlStatement;
        this.sessionFactory = sessionFactory;
        String entityName = ((SqmRoot)sqmDmlStatement.getTarget()).getModel().getHibernateEntityName();
        this.entityDescriptor = sessionFactory.getMappingMetamodel().getEntityDescriptor(entityName);
    }

    public SqmDmlStatement<?> getSqmStatement() {
        return this.sqmDmlStatement;
    }

    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

