/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToOneImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.ManyToOneJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PropertyRefAnnotation;
import org.hibernate.boot.models.annotations.internal.TargetXmlAnnotation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class ManyToOneAttributeProcessing {
    public static MutableMemberDetails processManyToOneAttribute(JaxbManyToOneImpl jaxbManyToOne, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbManyToOne.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbManyToOne.getName(), accessType, declarer);
        ManyToOneJpaAnnotation manyToOneAnn = ManyToOneAttributeProcessing.applyManyToOne(memberDetails, jaxbManyToOne, xmlDocumentContext);
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbManyToOne, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyFetching(jaxbManyToOne, memberDetails, manyToOneAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyOptionality(jaxbManyToOne, manyToOneAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyOptimisticLock(jaxbManyToOne, memberDetails, xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbManyToOne.getJoinTable(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyJoinColumnsOrFormulas(jaxbManyToOne.getJoinColumnOrJoinFormula(), memberDetails, xmlDocumentContext);
        if (jaxbManyToOne.getPropertyRef() != null) {
            PropertyRefAnnotation propertyRefUsage = (PropertyRefAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.PROPERTY_REF, xmlDocumentContext.getModelBuildingContext());
            propertyRefUsage.value(jaxbManyToOne.getPropertyRef().getName());
        }
        XmlAnnotationHelper.applyNotFound(jaxbManyToOne, memberDetails, xmlDocumentContext);
        ManyToOneAttributeProcessing.applyOnDelete(memberDetails, jaxbManyToOne, manyToOneAnn, xmlDocumentContext);
        ManyToOneAttributeProcessing.applyTarget(memberDetails, jaxbManyToOne, manyToOneAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbManyToOne.getCascade(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    private static ManyToOneJpaAnnotation applyManyToOne(MutableMemberDetails memberDetails, JaxbManyToOneImpl jaxbManyToOne, XmlDocumentContext xmlDocumentContext) {
        ManyToOneJpaAnnotation manyToOneUsage = (ManyToOneJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.MANY_TO_ONE, xmlDocumentContext.getModelBuildingContext());
        if (jaxbManyToOne.isId() == Boolean.TRUE) {
            memberDetails.applyAnnotationUsage(JpaAnnotations.ID, xmlDocumentContext.getModelBuildingContext());
        }
        CommonAttributeProcessing.applyMapsId(jaxbManyToOne.getMapsId(), memberDetails, xmlDocumentContext);
        return manyToOneUsage;
    }

    private static void applyOnDelete(MutableMemberDetails memberDetails, JaxbManyToOneImpl jaxbManyToOne, ManyToOneJpaAnnotation manyToOneAnn, XmlDocumentContext xmlDocumentContext) {
        CommonAttributeProcessing.applyOnDelete(jaxbManyToOne.getOnDelete(), memberDetails, xmlDocumentContext);
    }

    private static void applyTarget(MutableMemberDetails memberDetails, JaxbManyToOneImpl jaxbManyToOne, ManyToOneJpaAnnotation manyToOneAnn, XmlDocumentContext xmlDocumentContext) {
        String targetEntityName = jaxbManyToOne.getTargetEntity();
        if (StringHelper.isEmpty(targetEntityName)) {
            return;
        }
        TargetXmlAnnotation targetAnn = (TargetXmlAnnotation)memberDetails.applyAnnotationUsage(XmlAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
        targetAnn.value(xmlDocumentContext.resolveClassName(targetEntityName));
    }
}

