/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Maskavas ziemas laiks",
               "",
               "Maskavas vasaras laiks",
               "",
               "Maskavas laiks",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakist\u0101nas ziemas laiks",
               "",
               "Pakist\u0101nas vasaras laiks",
               "",
               "Pakist\u0101nas laiks",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadanas ziemas laiks",
               "",
               "Magadanas vasaras laiks",
               "",
               "Magadanas laiks",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Centr\u0101leiropas ziemas laiks",
               "CET",
               "Centr\u0101leiropas vasaras laiks",
               "CEST",
               "Centr\u0101leiropas laiks",
               "CET",
            };
        final String[] America_Eastern = new String[] {
               "Austrumu ziemas laiks",
               "",
               "Austrumu vasaras laiks",
               "",
               "Austrumu laiks",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lorda Hava salas ziemas laiks",
               "",
               "Lorda Hava salas vasaras laiks",
               "",
               "Lorda Hava salas laiks",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Jaunz\u0113landes ziemas laiks",
               "",
               "Jaunz\u0113landes vasaras laiks",
               "",
               "Jaunz\u0113landes laiks",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijas oke\u0101na laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutskas ziemas laiks",
               "",
               "Jakutskas vasaras laiks",
               "",
               "Jakutskas laiks",
               "",
            };
        final String[] East_Timor = new String[] {
               "Austrumtimoras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosrae laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Austrumeiropas ziemas laiks",
               "EET",
               "Austrumeiropas vasaras laiks",
               "EEST",
               "Austrumeiropas laiks",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "Rietumargent\u012bnas ziemas laiks",
               "",
               "Rietumargent\u012bnas vasaras laiks",
               "",
               "Rietumargent\u012bnas laiks",
               "",
            };
        final String[] Ponape = new String[] {
               "Ponap\u0113 laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bol\u012bvijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Senpj\u0113ras un Mikelonas ziemas laiks",
               "",
               "Senpj\u0113ras un Mikelonas vasaras laiks",
               "",
               "Senpj\u0113ras un Mikelonas laiks",
               "",
            };
        final String[] Indochina = new String[] {
               "Indo\u0137\u012bnas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgas ziemas laiks",
               "",
               "Jekaterinburgas vasaras laiks",
               "",
               "Jekaterinburgas laiks",
               "",
            };
        final String[] Maldives = new String[] {
               "Mald\u012bvijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Taiti laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Volisas un Futunas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Dienvid\u0101frikas ziemas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "\u0160ovas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lainas salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekist\u0101nas ziemas laiks",
               "",
               "Uzbekist\u0101nas vasaras laiks",
               "",
               "Uzbekist\u0101nas laiks",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatoras ziemas laiks",
               "",
               "Ulanbatoras vasaras laiks",
               "",
               "Ulanbatoras laiks",
               "",
            };
        final String[] America_Central = new String[] {
               "Centr\u0101lais ziemas laiks",
               "",
               "Centr\u0101lais vasaras laiks",
               "",
               "Centr\u0101lais laiks",
               "",
            };
        final String[] Niue = new String[] {
               "Niues laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Veika salas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklenda (Malvinu) salu ziemas laiks",
               "",
               "Folklenda (Malvinu) salu vasaras laiks",
               "",
               "Folklenda (Malvinu) salu laiks",
               "",
            };
        final String[] Apia = new String[] {
               "Apijas ziemas laiks",
               "",
               "Apijas vasaras laiks",
               "",
               "Apijas laiks",
               "",
            };
        final String[] Bhutan = new String[] {
               "But\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauru laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Rietumkazahst\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Ziemsv\u0113tku salas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "Reinjonas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Kokosu (K\u012blinga) salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u010cetemas ziemas laiks",
               "",
               "\u010cetemas vasaras laiks",
               "",
               "\u010cetemas laiks",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostokas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argent\u012bnas ziemas laiks",
               "",
               "Argent\u012bnas vasaras laiks",
               "",
               "Argent\u012bnas laiks",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambj\u0113 salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venecu\u0113las laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "F\u0113niksa salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kaboverdes ziemas laiks",
               "",
               "Kaboverdes vasaras laiks",
               "",
               "Kaboverdes laiks",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkas salas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa ziemas laiks",
               "",
               "Samoa vasaras laiks",
               "",
               "Samoa laiks",
               "",
            };
        final String[] Davis = new String[] {
               "Deivisas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubas ziemas laiks",
               "",
               "Kubas vasaras laiks",
               "",
               "Kubas laiks",
               "",
            };
        final String[] GMT = new String[] {
               "Grini\u010das laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Filip\u012bnu ziemas laiks",
               "",
               "Filip\u012bnu vasaras laiks",
               "",
               "Filip\u012bnu laiks",
               "",
            };
        final String[] French_Southern = new String[] {
               "Francijas Dienvidj\u016bru un Antarktikas teritorijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Jaunkaledonijas ziemas laiks",
               "",
               "Jaunkaledonijas vasaras laiks",
               "",
               "Jaunkaledonijas laiks",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunejas Darusalamas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Ir\u0101nas ziemas laiks",
               "",
               "Ir\u0101nas vasaras laiks",
               "",
               "Ir\u0101nas laiks",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikist\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongas ziemas laiks",
               "",
               "Tongas vasaras laiks",
               "",
               "Tongas laiks",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161as ziemas laiks",
               "",
               "Banglade\u0161as vasaras laiks",
               "",
               "Banglade\u0161as laiks",
               "",
            };
        final String[] Peru = new String[] {
               "Peru ziemas laiks",
               "",
               "Peru vasaras laiks",
               "",
               "Peru laiks",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Austrumgrenlandes ziemas laiks",
               "",
               "Austrumgrenlandes vasaras laiks",
               "",
               "Austrumgrenlandes laiks",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Austrumindon\u0113zijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizst\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Austr\u0101lijas austrumu ziemas laiks",
               "",
               "Austr\u0101lijas austrumu vasaras laiks",
               "",
               "Austr\u0101lijas austrumu laiks",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francijas Gvi\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolumbijas ziemas laiks",
               "",
               "Kolumbijas vasaras laiks",
               "",
               "Kolumbijas laiks",
               "",
            };
        final String[] Chile = new String[] {
               "\u010c\u012bles ziemas laiks",
               "",
               "\u010c\u012bles vasaras laiks",
               "",
               "\u010c\u012bles laiks",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberta salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskas ziemas laiks",
               "",
               "Irkutskas vasaras laiks",
               "",
               "Irkutskas laiks",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzijas ziemas laiks",
               "",
               "Gruzijas vasaras laiks",
               "",
               "Gruzijas laiks",
               "",
            };
        final String[] Choibalsan = new String[] {
               "\u010coibalsanas ziemas laiks",
               "",
               "\u010coibalsanas vasaras laiks",
               "",
               "\u010coibalsanas laiks",
               "",
            };
        final String[] China = new String[] {
               "\u0136\u012bnas ziemas laiks",
               "",
               "\u0136\u012bnas vasaras laiks",
               "",
               "\u0136\u012bnas laiks",
               "",
            };
        final String[] Armenia = new String[] {
               "Arm\u0113nijas ziemas laiks",
               "",
               "Arm\u0113nijas vasaras laiks",
               "",
               "Arm\u0113nijas laiks",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centr\u0101l\u0101frikas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Jap\u0101nas ziemas laiks",
               "",
               "Jap\u0101nas vasaras laiks",
               "",
               "Jap\u0101nas laiks",
               "",
            };
        final String[] Taipei = new String[] {
               "Taibei ziemas laiks",
               "",
               "Taibei vasaras laiks",
               "",
               "Taibei laiks",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdas ziemas laiks",
               "",
               "Hovdas vasaras laiks",
               "",
               "Hovdas laiks",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Austr\u0101lijas centr\u0101lais rietumu ziemas laiks",
               "",
               "Austr\u0101lijas centr\u0101lais rietumu vasaras laiks",
               "",
               "Austr\u0101lijas centr\u0101lais rietumu laiks",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahal\u012bnas ziemas laiks",
               "",
               "Sahal\u012bnas vasaras laiks",
               "",
               "Sahal\u012bnas laiks",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paragvajas ziemas laiks",
               "",
               "Paragvajas vasaras laiks",
               "",
               "Paragvajas laiks",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaizijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Univers\u0101lais koordin\u0113tais laiks",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Maur\u012bcijas ziemas laiks",
               "",
               "Maur\u012bcijas vasaras laiks",
               "",
               "Maur\u012bcijas laiks",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Austrum\u0101frikas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Z\u0101lamana salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "M\u0101r\u0161ala salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "\u0145\u016bfaundlendas ziemas laiks",
               "",
               "\u0145\u016bfaundlendas vasaras laiks",
               "",
               "\u0145\u016bfaundlendas laiks",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganist\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Honkongas ziemas laiks",
               "",
               "Honkongas vasaras laiks",
               "",
               "Honkongas laiks",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantijas ziemas laiks",
               "",
               "Atlantijas vasaras laiks",
               "",
               "Atlantijas laiks",
               "",
            };
        final String[] Israel = new String[] {
               "Izra\u0113las ziemas laiks",
               "",
               "Izra\u0113las vasaras laiks",
               "",
               "Izra\u0113las laiks",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Centr\u0101lindon\u0113zijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omskas ziemas laiks",
               "",
               "Omskas vasaras laiks",
               "",
               "Omskas laiks",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sei\u0161e\u013cu salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvajas ziemas laiks",
               "",
               "Urugvajas vasaras laiks",
               "",
               "Urugvajas laiks",
               "",
            };
        final String[] Nepal = new String[] {
               "Nep\u0101las laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "\u010c\u016bkas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu ziemas laiks",
               "",
               "Vanuatu vasaras laiks",
               "",
               "Vanuatu laiks",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskas ziemas laiks",
               "",
               "Novosibirskas vasaras laiks",
               "",
               "Novosibirskas laiks",
               "",
            };
        final String[] Singapore = new String[] {
               "Singap\u016bras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azoru salu ziemas laiks",
               "",
               "Azoru salu vasaras laiks",
               "",
               "Azoru salu laiks",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarskas ziemas laiks",
               "",
               "Krasnojarskas vasaras laiks",
               "",
               "Krasnojarskas laiks",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mjanmas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazones ziemas laiks",
               "",
               "Amazones vasaras laiks",
               "",
               "Amazones laiks",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Austrumkazahst\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei ziemas laiks",
               "",
               "Fid\u017ei vasaras laiks",
               "",
               "Fid\u017ei laiks",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovskas-Kam\u010datskas ziemas laiks",
               "",
               "Petropavlovskas-Kam\u010datskas vasaras laiks",
               "",
               "Petropavlovskas-Kam\u010datskas laiks",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Makvorija salas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaju\u2013Aleutu ziemas laiks",
               "",
               "Havaju\u2013Aleutu vasaras laiks",
               "",
               "Havaju\u2013Aleutu laiks",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Austr\u0101lijas centr\u0101lais ziemas laiks",
               "",
               "Austr\u0101lijas centr\u0101lais vasaras laiks",
               "",
               "Austr\u0101lijas centr\u0101lais laiks",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Klus\u0101 oke\u0101na ziemas laiks",
               "",
               "Klus\u0101 oke\u0101na vasaras laiks",
               "",
               "Klus\u0101 oke\u0101na laiks",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenist\u0101nas ziemas laiks",
               "",
               "Turkmenist\u0101nas vasaras laiks",
               "",
               "Turkmenist\u0101nas laiks",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Rietumeiropas ziemas laiks",
               "WET",
               "Rietumeiropas vasaras laiks",
               "WEST",
               "Rietumeiropas laiks",
               "WET",
            };
        final String[] Guyana = new String[] {
               "Gaj\u0101nas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitk\u0113rnas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Roteras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaid\u017e\u0101nas ziemas laiks",
               "",
               "Azerbaid\u017e\u0101nas vasaras laiks",
               "",
               "Azerbaid\u017e\u0101nas laiks",
               "",
            };
        final String[] Mawson = new String[] {
               "Mosonas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikas Klus\u0101 oke\u0101na piekrastes ziemas laiks",
               "",
               "Meksikas Klus\u0101 oke\u0101na piekrastes vasaras laiks",
               "",
               "Meksikas Klus\u0101 oke\u0101na piekrastes laiks",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Rietum\u0101frikas ziemas laiks",
               "",
               "Rietum\u0101frikas vasaras laiks",
               "",
               "Rietum\u0101frikas laiks",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Dienvidd\u017eord\u017eijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Lieldienu salas ziemas laiks",
               "",
               "Lieldienu salas vasaras laiks",
               "",
               "Lieldienu salas laiks",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Zieme\u013crietumu Meksikas ziemas laiks",
               "",
               "Zieme\u013crietumu Meksikas vasaras laiks",
               "",
               "Zieme\u013crietumu Meksikas laiks",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dimondirvilas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Rietumgrenlandes ziemas laiks",
               "",
               "Rietumgrenlandes vasaras laiks",
               "",
               "Rietumgrenlandes laiks",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvadoras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Persijas l\u012b\u010da laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Korejas ziemas laiks",
               "",
               "Korejas vasaras laiks",
               "",
               "Korejas laiks",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Austr\u0101lijas rietumu ziemas laiks",
               "",
               "Austr\u0101lijas rietumu vasaras laiks",
               "",
               "Austr\u0101lijas rietumu laiks",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Rietumindon\u0113zijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Kalnu ziemas laiks",
               "",
               "Kalnu vasaras laiks",
               "",
               "Kalnu laiks",
               "",
            };
        final String[] Marquesas = new String[] {
               "Mar\u0137\u012bza salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ar\u0101bijas pussalas ziemas laiks",
               "",
               "Ar\u0101bijas pussalas vasaras laiks",
               "",
               "Ar\u0101bijas pussalas laiks",
               "",
            };
        final String[] Alaska = new String[] {
               "A\u013caskas ziemas laiks",
               "",
               "A\u013caskas vasaras laiks",
               "",
               "A\u013caskas laiks",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokas ziemas laiks",
               "",
               "Vladivostokas vasaras laiks",
               "",
               "Vladivostokas laiks",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u010camorra ziemas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Jaungvinejas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernandu di Noro\u0146as ziemas laiks",
               "",
               "Fernandu di Noro\u0146as vasaras laiks",
               "",
               "Fernandu di Noro\u0146as laiks",
               "",
            };
        final String[] Brasilia = new String[] {
               "Braz\u012blijas ziemas laiks",
               "",
               "Braz\u012blijas vasaras laiks",
               "",
               "Braz\u012blijas laiks",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadiras ziemas laiks",
               "",
               "Anadiras vasaras laiks",
               "",
               "Anadiras laiks",
               "",
            };
        final String[] Samara = new String[] {
               "Samaras ziemas laiks",
               "",
               "Samaras vasaras laiks",
               "",
               "Samaras laiks",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Phenjanas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indijas ziemas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Kuka salu ziemas laiks",
               "",
               "Kuka salu vasaras laiks",
               "",
               "Kuka salu laiks",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "F\u012bniksa" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.America/Antigua", "Antigva" },
            { "timezone.excity.Europe/Ljubljana", "\u013bub\u013cana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Mar\u0137\u012bza salas" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenosairesa" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Denm\u0101rk\u0161avna" },
            { "timezone.excity.America/Anchorage", "Ankur\u0101\u017ea" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Grini\u010das laiks",
                    "",
                    "Lielbrit\u0101nijas vasaras laiks",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostoka" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Bjula, Zieme\u013cdakota" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Europe/Gibraltar", "Gibralt\u0101rs" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Librevila" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakara" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Adisabeba" },
            { "timezone.excity.Africa/Kinshasa", "Kin\u0161asa" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallina" },
            { "timezone.excity.Pacific/Truk", "\u010c\u016bka" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Guama" },
            { "timezone.excity.Europe/Vaduz", "Vaduca" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santaisabela" },
            { "timezone.excity.Asia/Barnaul", "Barnaula" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Londona" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitk\u0113rna" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarska" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Noma" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vank\u016bvera" },
            { "timezone.excity.America/Matamoros", "Matamorosa" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "\u010coibalsana" },
            { "timezone.excity.America/Inuvik", "Inuvika" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Sentl\u016bsija" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuz\u0146ecka" },
            { "timezone.excity.Europe/Berlin", "Berl\u012bne" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midvejs" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Godthab", "N\u016bka" },
            { "timezone.excity.America/Martinique", "Martinika" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "P\u0113rta" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longj\u0113rb\u012bene" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Africa/Windhoek", "Vindhuka" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Mad\u017euro" },
            { "timezone.excity.America/Lower_Princes", "Louerprinseskvotera" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Band\u017eula" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindemana" },
            { "timezone.excity.America/Miquelon", "Mikelona" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Huhuja" },
            { "timezone.excity.America/Argentina/Ushuaia", "U\u0161uaja" },
            { "timezone.excity.America/North_Dakota/Center", "Sentera, Zieme\u013cdakota" },
            { "timezone.excity.America/Cayenne", "Kajenna" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Beliza" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkoka" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "D\u017eonstona atols" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "D\u017e\u0113rsija" },
            { "timezone.excity.America/Pangnirtung", "Pannirtuna" },
            { "timezone.excity.Atlantic/South_Georgia", "Dienvidd\u017eord\u017eija" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "D\u017e\u016bba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madride" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroita" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Gren\u0101da" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnompe\u0146a" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Asia/Hebron", "Hebrona" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mosona" },
            { "timezone.excity.Asia/Karachi", "Kar\u0101\u010di" },
            { "timezone.excity.America/Resolute", "Rezol\u016bta" },
            { "timezone.excity.Africa/Nouakchott", "Nuak\u0161ota" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Maskata" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "Aj\u016bna" },
            { "timezone.excity.Australia/Hobart", "Hob\u0101rta" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "\u0145\u016bseilema, Zieme\u013cdakota" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161keka" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ohinaga" },
            { "timezone.excity.Europe/Zurich", "C\u012brihe" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "Sanpaulu" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "\u0145ujorka" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Etc/Unknown", "nezin\u0101ma pils\u0113ta" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Tule" },
            { "timezone.excity.America/Grand_Turk", "Grandtk\u0113rka" },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "timezone.excity.America/Indiana/Petersburg", "P\u012btersb\u0113rga, Indi\u0101na" },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Vinipega" },
            { "timezone.excity.Antarctica/Macquarie", "Makvori" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017ehoroda" },
            { "timezone.excity.America/Caracas", "Karakasa" },
            { "timezone.excity.America/Dawson_Creek", "Dousonkr\u012bka" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hovda" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blansablona" },
            { "timezone.excity.Africa/Algiers", "Al\u017e\u012bra" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Hart\u016bma" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galapagu salas" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tukumana" },
            { "timezone.excity.America/Rio_Branco", "Riobranko" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "U\u013cjanovska" },
            { "timezone.excity.Africa/Niamey", "Niameja" },
            { "timezone.excity.Indian/Mayotte", "Majota" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Grini\u010das laiks",
                    "",
                    "\u012arijas ziemas laiks",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Asia/Jakarta", "D\u017eakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratova" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aktebe" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Sv.Hel\u0113nas sala" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburga" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahreina" },
            { "timezone.excity.Indian/Mahe", "Mae" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "Menas sala" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Kirasao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pagopago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Gaj\u0101na" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Par\u012bze" },
            { "timezone.excity.Europe/Zagreb", "Zagreba" },
            { "timezone.excity.America/Scoresbysund", "Itokortormita" },
            { "timezone.excity.America/Indiana/Vevay", "V\u012bveja, Indi\u0101na" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Sviftkarenta" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budape\u0161ta" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Port_of_Spain", "Portofspeina" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankininleta" },
            { "timezone.excity.America/Santarem", "Santarena" },
            { "timezone.excity.Asia/Tomsk", "Tomska" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Jakutata" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadira" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.Africa/Lagos", "Lagosa" },
            { "timezone.excity.Africa/Bissau", "Bisava" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogad\u012b\u0161o" },
            { "timezone.excity.America/Bahia_Banderas", "Bajabanderasa" },
            { "timezone.excity.Asia/Jayapura", "D\u017eajapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Gvadalkanala" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.America/Nassau", "Naso" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuveita" },
            { "timezone.excity.America/Santo_Domingo", "Santodomingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Maskava" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taibei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Grini\u010das laiks",
                    "",
                    "Lielbrit\u0101nijas vasaras laiks",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fortnelsona" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Merigota" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.America/Kentucky/Monticello", "Monti\u010delo, Kentuki" },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumba\u0161i" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanbatora" },
            { "timezone.excity.Antarctica/McMurdo", "Makmerdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirska" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Sred\u0146ekolimska" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "timezone.excity.America/Indiana/Marengo", "Marengo, Indi\u0101na" },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokija" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburga" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublina" },
            { "timezone.excity.Antarctica/Casey", "Keisi" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kaboverde" },
            { "timezone.excity.Africa/Maputo", "Maputu" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "G\u016bsbeja" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Los_Angeles", "Losand\u017eelosa" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Kujaba" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azoru salas" },
            { "timezone.excity.Australia/Melbourne", "Melburna" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Angilja" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbena" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivu" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manausa" },
            { "timezone.excity.Asia/Vientiane", "Vjen\u010dana" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Ziemsv\u0113tku sala" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.America/Regina", "Rid\u017eaina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Tanderbeja" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "L\u016bivila" },
            { "timezone.excity.America/Cancun", "Kankuna" },
            { "timezone.excity.Australia/Broken_Hill", "Brokenhila" },
            { "timezone.excity.Europe/Kaliningrad", "Ka\u013ci\u0146ingrada" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kirisimasi" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tir\u0101na" },
            { "timezone.excity.Europe/Prague", "Pr\u0101ga" },
            { "timezone.excity.Pacific/Tarawa", "Tarava" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunsjona" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161i\u0146eva" },
            { "timezone.excity.America/Moncton", "Monktona" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vi\u013c\u0146a" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "\u010cik\u0101ga" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "Sanmar\u012bno" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Pacific/Ponape", "Ponpeja" },
            { "timezone.excity.Asia/Irkutsk", "Irkutska" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "\u010civava" },
            { "America/Belize", America_Central },
            { "timezone.excity.America/Indiana/Winamac", "Vinamaka, Indi\u0101na" },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reikjavika" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakutska" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibutija" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Resifi" },
            { "timezone.excity.Pacific/Wallis", "Volisa" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Portonovo" },
            { "timezone.excity.Antarctica/Palmer", "P\u0101lmera" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kenta" },
            { "timezone.excity.America/Argentina/San_Juan", "Sanhuana" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Shanghai", "\u0160anhaja" },
            { "timezone.excity.America/Juneau", "D\u017euno" },
            { "timezone.excity.Pacific/Bougainville", "Bugenvila sala" },
            { "timezone.excity.Pacific/Apia", "Apija" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salvadora" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Lieldienu sala" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menomin\u012b" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lordhava" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadana" },
            { "timezone.excity.Pacific/Wake", "Veika sala" },
            { "timezone.excity.Atlantic/Canary", "Kan\u0101riju salas" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Gleisbeja" },
            { "timezone.excity.Africa/Casablanca", "Kasablanka" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kr\u0101lendeika" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Erev\u0101na" },
            { "timezone.excity.Europe/Kirov", "Kirova" },
            { "timezone.excity.America/Creston", "Krestona" },
            { "timezone.excity.Africa/Cairo", "Kaira" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.America/Indiana/Tell_City", "Telsitija, Indi\u0101na" },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmontona" },
            { "timezone.excity.Africa/Sao_Tome", "Santome" },
            { "timezone.excity.America/Dawson", "Dousona" },
            { "timezone.excity.Africa/Abidjan", "Abid\u017eana" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Gvadelupa" },
            { "timezone.excity.Africa/Freetown", "Fr\u012btauna" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatik\u0101ns" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Minsk", "Minska" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovija" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Reinirivera" },
            { "timezone.excity.America/Coral_Harbour", "Atikokana" },
            { "timezone.excity.Asia/Beirut", "Beir\u016bta" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianaka" },
            { "timezone.excity.America/Adak", "Adaka" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagd\u0101de" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dimondirvila" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Masejo" },
            { "timezone.excity.America/Guayaquil", "Gvajakila" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Sentvinsenta" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopole" },
            { "timezone.excity.Indian/Kerguelen", "Kergel\u0113na sala" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Volgograda" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "Lapasa" },
            { "timezone.excity.Africa/Tripoli", "Tripole" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderberija" },
            { "timezone.excity.Asia/Pyongyang", "Phenjana" },
            { "timezone.excity.Europe/Bucharest", "Bukareste" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "At\u0113nas" },
            { "Africa/Djibouti", Africa_Eastern },
            { "timezone.excity.America/Indiana/Knox", "Noksa, Indi\u0101na" },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Portuve\u013cu" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managva" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrata" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kopenh\u0101gena" },
            { "timezone.excity.Australia/Darwin", "D\u0101rvina" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jeruzaleme" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Rij\u0101da" },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangi" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ustj\u0146era" },
            { "timezone.excity.Asia/Damascus", "Damaska" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosraja" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazavila" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Riogaljegosa" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Baija" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teher\u0101na" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.America/St_Kitts", "Sentkitsa" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "D\u0101resal\u0101ma" },
            { "timezone.excity.America/Monterrey", "Monterreja" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Belena" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho\u0161imina" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makasara" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburga" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "Sofija" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astraha\u0146a" },
            { "timezone.excity.America/Yellowknife", "Jelounaifa" },
            { "timezone.excity.Europe/Belgrade", "Belgrada" },
            { "timezone.excity.America/Puerto_Rico", "Puertoriko" },
            { "timezone.excity.America/Denver", "Denvera" },
            { "timezone.excity.Asia/Calcutta", "Kalk\u0101ta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Trolla" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Honkonga" },
            { "timezone.excity.America/Port-au-Prince", "Portoprensa" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Jukla" },
            { "timezone.excity.America/Mexico_City", "Mehiko" },
            { "timezone.excity.Pacific/Kwajalein", "Kvad\u017ealeina" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisabona" },
            { "timezone.excity.Pacific/Gambier", "Gambj\u0113 salas" },
            { "timezone.excity.America/Boise", "Boisisitija" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporo\u017eje" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "\u010cetema" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Portmorsbi" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendosa" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noro\u0146a" },
            { "timezone.excity.Asia/Sakhalin", "Sahal\u012bna" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigona" },
            { "timezone.excity.Europe/Guernsey", "G\u0113rnsija" },
            { "timezone.excity.America/Argentina/San_Luis", "Sanluisa" },
            { "timezone.excity.Europe/Riga", "R\u012bga" },
            { "timezone.excity.America/Araguaina", "Aragvaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "Kordova" },
            { "timezone.excity.America/Cambridge_Bay", "Kembrid\u017ebeja" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Kampugrandi" },
            { "timezone.excity.Africa/Blantyre", "Blantaira" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sidneja" },
            { "timezone.excity.Asia/Qatar", "Katara" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Deivisa" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Maur\u012bcija" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "Larjoha" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamna" },
            { "timezone.excity.America/St_Johns", "Sentd\u017eonsa" },
            { "timezone.excity.America/St_Barthelemy", "Senbartelm\u012b" },
            { "timezone.excity.America/Santiago", "Santjago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Orala" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolisa" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Seula" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Sentomasa" },
            { "timezone.excity.Europe/Busingen", "B\u012bzingene" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Stambula" },
            { "timezone.excity.Europe/Sarajevo", "Sarajeva" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Nd\u017eamena" },
            { "timezone.excity.America/Punta_Arenas", "Puntaarenasa" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostoka" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunisa" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Samarkanda" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Asia/Singapore", "Singap\u016bra" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "V\u012bne" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Kaimanu salas" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbadosa" },
            { "timezone.excity.Asia/Nicosia", "Nikosija" },
            { "timezone.excity.Europe/Kiev", "Kijeva" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omska" },
            { "timezone.excity.Africa/Bujumbura", "Bu\u017eumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Masatlana" },
            { "timezone.excity.Asia/Brunei", "Bruneja" },
            { "timezone.excity.Atlantic/Faeroe", "F\u0113ru salas" },
            { "timezone.excity.America/Whitehorse", "Vaithorsa" },
            { "timezone.excity.Asia/Kuching", "Ku\u010dina" },
            { "timezone.excity.America/Halifax", "Helifeksa" },
            { "timezone.excity.America/Merida", "Merida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Oklenda" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolka" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "A\u0161gabata" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "\u0160ova" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.America/Hermosillo", "Ermosiljo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "Reinjona" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Asia/Aden", "Adena" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stenli" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Ranguna" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Dubai", "Dubaija" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kualalumpura" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Vagadugu" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "\u010cagosu arhipel\u0101gs" },
            { "timezone.excity.Asia/Kabul", "Kabula" },
            { "timezone.excity.America/Iqaluit", "Ikaluita" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdama" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Pacific/Saipan", "Saipana" },
            { "timezone.excity.Indian/Cocos", "Kokosu (K\u012blinga) sala" },
            { "timezone.excity.Australia/Currie", "Kari" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amm\u0101na" },
            { "timezone.excity.America/Indiana/Vincennes", "Vinsensa, Indi\u0101na" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Brisele" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Komoras" },
            { "timezone.excity.America/Boa_Vista", "Boavista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stokholma" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tihuana" },
            { "timezone.excity.Indian/Maldives", "Mald\u012bvija" },
        };
        return data;
    }
}
