/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.parcelize.ParcelizeNames;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.FirParcelizeClassCheckerKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.ReferenceFinder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\b*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\b*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeConstructorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorChecker;", "parcelizeAnnotations", "", "Lorg/jetbrains/kotlin/name/ClassId;", "experimentalCodeGeneration", "", "<init>", "(Ljava/util/List;Z)V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasParcelerCompanionInChain", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasCustomParceler", "parcelize.k2"})
@SourceDebugExtension(value={"SMAP\nFirParcelizeConstructorChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirParcelizeConstructorChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeConstructorChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n295#2,2:130\n1761#2,3:132\n1563#2:135\n1634#2,3:136\n1761#2,3:139\n1761#2,3:142\n*S KotlinDebug\n*F\n+ 1 FirParcelizeConstructorChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeConstructorChecker\n*L\n55#1:130,2\n67#1:132,3\n74#1:135\n74#1:136,3\n95#1:139,3\n102#1:142,3\n*E\n"})
public final class FirParcelizeConstructorChecker
extends FirDeclarationChecker<FirConstructor> {
    @NotNull
    private final List<ClassId> parcelizeAnnotations;
    private final boolean experimentalCodeGeneration;

    public FirParcelizeConstructorChecker(@NotNull List<ClassId> parcelizeAnnotations, boolean experimentalCodeGeneration) {
        Intrinsics.checkNotNullParameter(parcelizeAnnotations, (String)"parcelizeAnnotations");
        super(MppCheckerKind.Platform);
        this.parcelizeAnnotations = parcelizeAnnotations;
        this.experimentalCodeGeneration = experimentalCodeGeneration;
    }

    /*
     * WARNING - void declaration
     */
    public void check(@NotNull FirConstructor declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean allowBareValueArguments;
        Object it;
        boolean bl;
        List notValOrVarParameters;
        FirRegularClassSymbol containingClassSymbol;
        FirRegularClass containingClass;
        block20: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (!declaration.isPrimary()) {
                return;
            }
            KtSourceElement ktSourceElement = declaration.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            if (Intrinsics.areEqual((Object)source.getKind(), (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) {
                return;
            }
            Object object = CollectionsKt.last((List)context.getContainingDeclarations());
            FirRegularClass firRegularClass = object instanceof FirRegularClass ? (FirRegularClass)object : null;
            if (firRegularClass == null) {
                return;
            }
            containingClass = firRegularClass;
            containingClassSymbol = containingClass.getSymbol();
            if (!FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)containingClassSymbol, context.getSession(), this.parcelizeAnnotations) || FirParcelizeClassCheckerKt.hasCustomParceler(containingClass, context.getSession())) {
                return;
            }
            if (declaration.getValueParameters().isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)containingClass.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_PRIMARY_CONSTRUCTOR_IS_EMPTY(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                return;
            }
            notValOrVarParameters = new ArrayList();
            for (FirValueParameter valueParameter : declaration.getValueParameters()) {
                FirAnnotation illegalAnnotation;
                FirAnnotation firAnnotation;
                KtSourceElement ktSourceElement2 = valueParameter.getSource();
                if (!(ktSourceElement2 != null ? LightTreePositioningStrategiesKt.hasValOrVar((KtSourceElement)ktSourceElement2) : false)) {
                    notValOrVarParameters.add(valueParameter);
                    continue;
                }
                if (valueParameter.getDefaultValue() != null) continue;
                Object object2 = ClassMembersKt.getCorrespondingProperty((FirValueParameter)valueParameter);
                if (object2 != null && (object2 = object2.getAnnotations()) != null) {
                    Object v4;
                    block19: {
                        Iterable $this$firstOrNull$iv = (Iterable)object2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            FirAnnotation it2 = (FirAnnotation)element$iv;
                            boolean bl2 = false;
                            if (!CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getIGNORED_ON_PARCEL_CLASS_IDS(), (Object)FirAnnotationUtilsKt.toAnnotationClassId((FirAnnotation)it2, (FirSession)context.getSession()))) continue;
                            v4 = element$iv;
                            break block19;
                        }
                        v4 = null;
                    }
                    firAnnotation = v4;
                } else {
                    firAnnotation = null;
                }
                if ((illegalAnnotation = firAnnotation) == null) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)illegalAnnotation.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getINAPPLICABLE_IGNORED_ON_PARCEL_CONSTRUCTOR_PROPERTY(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
            Iterable $this$any$iv = containingClass.getSuperTypeRefs();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (FirTypeRef)element$iv;
                    boolean bl3 = false;
                    FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol((FirTypeRef)it, (FirSession)context.getSession());
                    boolean bl4 = firRegularClassSymbol != null ? FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)firRegularClassSymbol, context.getSession(), this.parcelizeAnnotations) : false;
                    if (!bl4) continue;
                    bl = true;
                    break block20;
                }
                bl = false;
            }
        }
        boolean superIsParcelize = bl;
        boolean bl5 = allowBareValueArguments = this.experimentalCodeGeneration && superIsParcelize && !this.hasParcelerCompanionInChain(containingClassSymbol, context.getSession());
        if (allowBareValueArguments) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = notValOrVarParameters;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                FirValueParameter bl2 = (FirValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(it3.getSymbol());
            }
            Set lookingFor = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            ReferenceFinder referenceFinder = new ReferenceFinder(lookingFor, reporter, context);
            for (FirDeclaration decl : containingClass.getDeclarations()) {
                FirDeclaration firDeclaration = decl;
                if (!(firDeclaration instanceof FirAnonymousInitializer) && !(firDeclaration instanceof FirProperty)) continue;
                decl.accept((FirVisitorVoid)referenceFinder);
            }
        } else {
            for (FirValueParameter valueParameter : notValOrVarParameters) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)valueParameter.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_CONSTRUCTOR_PARAMETER_SHOULD_BE_VAL_OR_VAR(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasParcelerCompanionInChain(FirRegularClassSymbol $this$hasParcelerCompanionInChain, FirSession session) {
        boolean bl;
        if (!FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)$this$hasParcelerCompanionInChain, session, this.parcelizeAnnotations)) {
            return false;
        }
        if (this.hasCustomParceler($this$hasParcelerCompanionInChain, session)) return true;
        Iterable $this$any$iv = $this$hasParcelerCompanionInChain.getResolvedSuperTypeRefs();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
            boolean bl2 = false;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol((FirTypeRef)((FirTypeRef)it), (FirSession)session);
            if (firRegularClassSymbol != null) {
                if (this.hasParcelerCompanionInChain(firRegularClassSymbol, session)) {
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean hasCustomParceler(FirRegularClassSymbol $this$hasCustomParceler, FirSession session) {
        boolean bl;
        block4: {
            FirRegularClassSymbol firRegularClassSymbol = $this$hasCustomParceler.getCompanionObjectSymbol();
            if (firRegularClassSymbol == null) {
                return false;
            }
            FirRegularClassSymbol companion = firRegularClassSymbol;
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes((FirClassLikeSymbol)((FirClassLikeSymbol)companion), (boolean)true, (boolean)true, (FirSession)session);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getPARCELER_CLASS_IDS(), (Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)((ConeKotlinType)it)))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

