/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.util.containers.MultiMap;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.update.GitPostUpdateHandler;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateSessionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0016J#\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u000b\u0010\u0019\u001a\u00070\u000b\u00a2\u0006\u0002\b\u001aH\u0002J(\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n0\u001c2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0016J'\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010!H\u0002\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lgit4idea/update/GitUpdateSession;", "Lcom/intellij/openapi/vcs/update/UpdateSession;", "project", "Lcom/intellij/openapi/project/Project;", "notificationData", "Lgit4idea/update/GitUpdateInfoAsLog$NotificationData;", "result", "", "skippedRoots", "", "Lgit4idea/repo/GitRepository;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/update/GitUpdateInfoAsLog$NotificationData;ZLjava/util/Map;)V", "getExceptions", "", "Lcom/intellij/openapi/vcs/VcsException;", "onRefreshFilesCompleted", "", "isCanceled", "getAdditionalNotificationContent", "mentionSkippedRoots", "Lcom/intellij/openapi/util/text/HtmlChunk;", "repos", "", "reason", "Lorg/jetbrains/annotations/Nls;", "groupByReasons", "Lcom/intellij/util/containers/MultiMap;", "showNotification", "prepareNotification", "Lcom/intellij/notification/Notification;", "updatedFilesNumber", "", "updatedCommitsNumber", "filteredCommitsNumber", "(IILjava/lang/Integer;)Lcom/intellij/notification/Notification;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitUpdateSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUpdateSession.kt\ngit4idea/update/GitUpdateSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1563#2:139\n1634#2,3:140\n1869#2,2:145\n216#3,2:143\n1#4:147\n*S KotlinDebug\n*F\n+ 1 GitUpdateSession.kt\ngit4idea/update/GitUpdateSession\n*L\n62#1:139\n62#1:140,3\n85#1:145,2\n72#1:143,2\n*E\n"})
public final class GitUpdateSession
implements UpdateSession {
    @NotNull
    private final Project project;
    @Nullable
    private final GitUpdateInfoAsLog.NotificationData notificationData;
    private final boolean result;
    @NotNull
    private final Map<GitRepository, String> skippedRoots;

    public GitUpdateSession(@NotNull Project project, @Nullable GitUpdateInfoAsLog.NotificationData notificationData, boolean result2, @NotNull Map<GitRepository, String> skippedRoots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(skippedRoots, (String)"skippedRoots");
        this.project = project;
        this.notificationData = notificationData;
        this.result = result2;
        this.skippedRoots = skippedRoots;
    }

    @NotNull
    public List<VcsException> getExceptions() {
        return CollectionsKt.emptyList();
    }

    public void onRefreshFilesCompleted() {
    }

    public boolean isCanceled() {
        return !this.result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getAdditionalNotificationContent() {
        Collection<HtmlChunk> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.skippedRoots.isEmpty()) {
            return null;
        }
        if (this.skippedRoots.size() == 1) {
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)this.skippedRoots.entrySet());
            GitRepository repo = (GitRepository)entry.getKey();
            String reason = (String)entry.getValue();
            Object[] objectArray = new Object[]{HtmlChunk.text((String)DvcsUtil.getShortRepositoryName((Repository)repo)), HtmlChunk.text((String)reason)};
            return GitBundle.message((String)"git.update.repo.was.skipped", (Object[])objectArray);
        }
        Object reason = new Object[]{this.skippedRoots.size()};
        HtmlChunk htmlChunk = HtmlChunk.text((String)GitBundle.message((String)"git.update.skipped.repositories", (Object[])reason));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(...)");
        HtmlChunk prefix = htmlChunk;
        MultiMap<String, GitRepository> grouped = this.groupByReasons(this.skippedRoots);
        if (grouped.entrySet().size() == 1) {
            Set set = grouped.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
            reason = (Map.Entry)CollectionsKt.first((Iterable)set);
            Intrinsics.checkNotNull((Object)reason);
            String reason2 = (String)reason.getKey();
            Collection repos = (Collection)reason.getValue();
            HtmlBuilder htmlBuilder = new HtmlBuilder().append(prefix).br();
            Intrinsics.checkNotNull((Object)repos);
            Intrinsics.checkNotNull((Object)reason2);
            return htmlBuilder.append(this.mentionSkippedRoots(repos, reason2)).toString();
        }
        HtmlBuilder htmlBuilder = new HtmlBuilder().append(prefix).br();
        HtmlChunk htmlChunk2 = (HtmlChunk)HtmlChunk.br();
        Set set = grouped.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        reason = set;
        HtmlChunk htmlChunk3 = htmlChunk2;
        HtmlBuilder htmlBuilder2 = htmlBuilder;
        boolean $i$f$map = false;
        void repos = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            String reason3 = (String)entry.getKey();
            Collection repos2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)repos2);
            Intrinsics.checkNotNull((Object)reason3);
            collection.add(this.mentionSkippedRoots(repos2, reason3));
        }
        collection = (List)destination$iv$iv;
        return htmlBuilder2.appendWithSeparators(htmlChunk3, (Iterable)collection).toString();
    }

    private final HtmlChunk mentionSkippedRoots(Collection<? extends GitRepository> repos, String reason) {
        HtmlChunk htmlChunk = HtmlChunk.text((String)(DvcsUtil.getShortNames(repos) + " (" + reason + ")"));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(...)");
        return htmlChunk;
    }

    private final MultiMap<String, GitRepository> groupByReasons(Map<GitRepository, String> skippedRoots) {
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        MultiMap result2 = multiMap;
        Map<GitRepository, String> $this$forEach$iv = skippedRoots;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<GitRepository, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<GitRepository, String> element$iv;
            Map.Entry<GitRepository, String> entry = element$iv = iterator.next();
            boolean bl = false;
            GitRepository file = entry.getKey();
            String s = entry.getValue();
            result2.putValue((Object)s, (Object)file);
        }
        return result2;
    }

    public void showNotification() {
        if (this.notificationData != null) {
            Notification notification = this.prepareNotification(this.notificationData.getUpdatedFilesCount(), this.notificationData.getReceivedCommitsCount(), this.notificationData.getFilteredCommitsCount());
            notification.addAction((AnAction)NotificationAction.createSimple(GitUpdateSession::showNotification$lambda$2, (Runnable)this.notificationData.getViewCommitAction()));
            Iterable $this$forEach$iv = GitPostUpdateHandler.Companion.getActions(this.project, this.notificationData.getRanges());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NotificationAction it = (NotificationAction)element$iv;
                boolean bl = false;
                notification.addAction((AnAction)it);
            }
            VcsNotifier.getInstance((Project)this.project).notify(notification);
        }
    }

    private final Notification prepareNotification(int updatedFilesNumber, int updatedCommitsNumber, Integer filteredCommitsNumber) {
        Notification notification;
        String title = null;
        Object content = null;
        NotificationType type = null;
        String displayId = null;
        String mainMessage = GitUpdateSessionKt.getTitleForUpdateNotification(updatedFilesNumber, updatedCommitsNumber);
        if (this.isCanceled()) {
            String string = GitBundle.message((String)"git.update.project.partially.updated.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            title = string;
            content = mainMessage;
            type = NotificationType.WARNING;
            displayId = "git.project.partially.updated";
        } else {
            title = mainMessage;
            content = GitUpdateSessionKt.getBodyForUpdateNotification(filteredCommitsNumber);
            type = NotificationType.INFORMATION;
            displayId = "git.project.updated";
        }
        String additionalContent = this.getAdditionalNotificationContent();
        if (additionalContent != null) {
            if (((CharSequence)content).length() > 0) {
                content = (String)content + "<br/>";
            }
            content = (String)content + additionalContent;
        }
        Notification it = notification = VcsNotifier.standardNotification().createNotification(title, (String)content, type);
        boolean bl = false;
        it.setDisplayId(displayId);
        return notification;
    }

    private static final String showNotification$lambda$2() {
        return GitBundle.message((String)"action.NotificationAction.GitUpdateSession.text.view.commits", (Object[])new Object[0]);
    }
}

