/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.StorageException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
@ApiStatus.Internal
public interface UpdatedEntryProcessor<Key, Value> {
    default public void added(Key key, Value value, int inputId) throws StorageException {
        this.process(UpdateKind.ADDED, key, value, inputId);
    }

    default public void updated(Key key, Value value, int inputId) throws StorageException {
        this.process(UpdateKind.UPDATED, key, value, inputId);
    }

    default public void removed(Key key, int inputId) throws StorageException {
        this.process(UpdateKind.REMOVED, key, null, inputId);
    }

    public void process(@NotNull UpdateKind var1, Key var2, Value var3, int var4) throws StorageException;

    public static enum UpdateKind {
        ADDED,
        UPDATED,
        REMOVED;

    }
}

