/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.text.DateFormatUtil;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001d\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\u000b\u001a\u00020\t*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"createOutdatedVersionPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "changeList", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getOutdatedVersionText", "", "Lorg/jetbrains/annotations/Nls;", "getSubject", "intellij.platform.vcs.impl"})
public final class OutdatedVersionNotifierKt {
    private static final EditorNotificationPanel createOutdatedVersionPanel(CommittedChangeList changeList, Change change, FileEditor fileEditor) {
        EditorNotificationPanel editorNotificationPanel;
        EditorNotificationPanel $this$createOutdatedVersionPanel_u24lambda_u240 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
        boolean bl = false;
        $this$createOutdatedVersionPanel_u24lambda_u240.createActionLabel(VcsBundle.message((String)"outdated.version.show.diff.action", (Object[])new Object[0]), "Compare.LastVersion");
        $this$createOutdatedVersionPanel_u24lambda_u240.createActionLabel(VcsBundle.message((String)"outdated.version.update.project.action", (Object[])new Object[0]), "Vcs.UpdateProject");
        $this$createOutdatedVersionPanel_u24lambda_u240.setText(OutdatedVersionNotifierKt.getOutdatedVersionText(changeList, change));
        return editorNotificationPanel;
    }

    private static final String getOutdatedVersionText(CommittedChangeList changeList, Change change) {
        String string = DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatPrettyDateTime(...)");
        String formattedDate = string;
        Object[] objectArray = new Object[4];
        objectArray[0] = changeList.getCommitterName();
        objectArray[1] = formattedDate;
        String string2 = changeList.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getComment(...)");
        objectArray[2] = OutdatedVersionNotifierKt.getSubject(string2);
        objectArray[3] = change.getType() == Change.Type.DELETED ? 1 : 0;
        String string3 = VcsBundle.message((String)"outdated.version.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return string3;
    }

    private static final String getSubject(String $this$getSubject) {
        Object object;
        int newLineIndex = StringsKt.indexOf$default((CharSequence)$this$getSubject, (char)'\n', (int)0, (boolean)false, (int)6, null);
        if (newLineIndex < 0) {
            object = $this$getSubject;
        } else {
            String string = $this$getSubject.substring(0, newLineIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = ((Object)StringsKt.trim((CharSequence)string)).toString() + "...";
        }
        return object;
    }

    public static final /* synthetic */ EditorNotificationPanel access$createOutdatedVersionPanel(CommittedChangeList changeList, Change change, FileEditor fileEditor) {
        return OutdatedVersionNotifierKt.createOutdatedVersionPanel(changeList, change, fileEditor);
    }
}

