/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.dynatrace.hash4j.hashing.HashSink;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetHashSupplier;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceRootDescriptor;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTargetType;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Internal
public final class MavenResourcesTarget
extends ModuleBasedTarget<MavenResourceRootDescriptor>
implements BuildTargetHashSupplier {
    MavenResourcesTarget(@NotNull MavenResourcesTargetType type, @NotNull JpsModule module) {
        if (type == null) {
            MavenResourcesTarget.$$$reportNull$$$0(0);
        }
        if (module == null) {
            MavenResourcesTarget.$$$reportNull$$$0(1);
        }
        super((ModuleBasedBuildTargetType)type, module);
    }

    @NotNull
    public String getId() {
        String string = this.myModule.getName();
        if (string == null) {
            MavenResourcesTarget.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Collection<BuildTarget<?>> computeDependencies(@NotNull BuildTargetRegistry targetRegistry, @NotNull TargetOutputIndex outputIndex) {
        if (targetRegistry == null) {
            MavenResourcesTarget.$$$reportNull$$$0(3);
        }
        if (outputIndex == null) {
            MavenResourcesTarget.$$$reportNull$$$0(4);
        }
        List<BuildTarget<?>> list = Collections.emptyList();
        if (list == null) {
            MavenResourcesTarget.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isCompiledBeforeModuleLevelBuilders() {
        return true;
    }

    @NotNull
    public List<MavenResourceRootDescriptor> computeRootDescriptors(@NotNull JpsModel model, @NotNull ModuleExcludeIndex index, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull BuildDataPaths dataPaths) {
        if (model == null) {
            MavenResourcesTarget.$$$reportNull$$$0(6);
        }
        if (index == null) {
            MavenResourcesTarget.$$$reportNull$$$0(7);
        }
        if (ignoredFileIndex == null) {
            MavenResourcesTarget.$$$reportNull$$$0(8);
        }
        if (dataPaths == null) {
            MavenResourcesTarget.$$$reportNull$$$0(9);
        }
        ArrayList<MavenResourceRootDescriptor> result = new ArrayList<MavenResourceRootDescriptor>();
        MavenModuleResourceConfiguration moduleConfig = this.getModuleResourcesConfiguration(dataPaths);
        if (moduleConfig == null) {
            List<MavenResourceRootDescriptor> list = Collections.emptyList();
            if (list == null) {
                MavenResourcesTarget.$$$reportNull$$$0(10);
            }
            return list;
        }
        int i = 0;
        for (ResourceRootConfiguration resource : this.getRootConfigurations(moduleConfig)) {
            result.add(new MavenResourceRootDescriptor(this, resource, i++, moduleConfig.overwrite));
        }
        ArrayList<MavenResourceRootDescriptor> arrayList = result;
        if (arrayList == null) {
            MavenResourcesTarget.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private Collection<ResourceRootConfiguration> getRootConfigurations(@Nullable MavenModuleResourceConfiguration moduleConfig) {
        if (moduleConfig != null) {
            return this.isTests() ? moduleConfig.testResources : moduleConfig.resources;
        }
        return Collections.emptyList();
    }

    @Nullable
    public MavenModuleResourceConfiguration getModuleResourcesConfiguration(BuildDataPaths dataPaths) {
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        if (projectConfig == null) {
            return null;
        }
        return projectConfig.moduleConfigurations.get(this.myModule.getName());
    }

    public boolean isTests() {
        return ((MavenResourcesTargetType)this.getTargetType()).isTests();
    }

    @Nullable
    public MavenResourceRootDescriptor findRootDescriptor(@NotNull String rootId, @NotNull BuildRootIndex rootIndex) {
        if (rootId == null) {
            MavenResourcesTarget.$$$reportNull$$$0(12);
        }
        if (rootIndex == null) {
            MavenResourcesTarget.$$$reportNull$$$0(13);
        }
        for (MavenResourceRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getTargetType().getTypeId() + ":" + this.myModule.getName();
        if (string == null) {
            MavenResourcesTarget.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(@NotNull CompileContext context) {
        MavenModuleResourceConfiguration configuration;
        if (context == null) {
            MavenResourcesTarget.$$$reportNull$$$0(15);
        }
        if ((configuration = this.getModuleResourcesConfiguration(context.getProjectDescriptor().dataManager.getDataPaths())) == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                MavenResourcesTarget.$$$reportNull$$$0(16);
            }
            return list;
        }
        Set result = FileCollectionFactory.createCanonicalFileSet();
        File moduleOutput = this.getModuleOutputDir();
        for (ResourceRootConfiguration resConfig : this.getRootConfigurations(configuration)) {
            File output = MavenResourcesTarget.getOutputDir(moduleOutput, resConfig, configuration.outputDirectory);
            if (output == null) continue;
            result.add(output);
        }
        Set set = result;
        if (set == null) {
            MavenResourcesTarget.$$$reportNull$$$0(17);
        }
        return set;
    }

    @Nullable
    public File getModuleOutputDir() {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, this.isTests());
    }

    @Nullable
    public static File getOutputDir(@Nullable File moduleOutput, ResourceRootConfiguration config, @Nullable String outputDirectory) {
        if (outputDirectory != null) {
            moduleOutput = JpsPathUtil.urlToFile((String)outputDirectory);
        }
        if (moduleOutput == null) {
            return null;
        }
        String targetPath = config.targetPath;
        if (targetPath == null || targetPath.isBlank()) {
            return moduleOutput;
        }
        File targetPathFile = new File(targetPath);
        File outputFile = targetPathFile.isAbsolute() ? targetPathFile : new File(moduleOutput, targetPath);
        return new File(FileUtilRt.toCanonicalPath((String)outputFile.getPath(), (char)File.separatorChar, (boolean)true));
    }

    public void computeConfigurationDigest(@NotNull ProjectDescriptor projectDescriptor, @NotNull HashSink hash) {
        BuildDataPaths dataPaths;
        MavenModuleResourceConfiguration configuration;
        if (projectDescriptor == null) {
            MavenResourcesTarget.$$$reportNull$$$0(18);
        }
        if (hash == null) {
            MavenResourcesTarget.$$$reportNull$$$0(19);
        }
        if ((configuration = this.getModuleResourcesConfiguration(dataPaths = projectDescriptor.dataManager.getDataPaths())) == null) {
            hash.putBoolean(false);
        } else {
            hash.putBoolean(true);
            configuration.computeConfigurationHash(this.isTests(), hash);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/maven/model/impl/MavenResourcesTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegistry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFileIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootIndex";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/maven/model/impl/MavenResourcesTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDependencies";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeDependencies";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeRootDescriptors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findRootDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOutputRoots";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeConfigurationDigest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

