/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import java.lang.reflect.Method;
import java.util.List;
import org.junit.AssumptionViolatedException;

public class IgnoreException
extends Exception {
    public static final IgnoreException INSTANCE = new IgnoreException();
    private static final String MULTIPLE_FAILURES_ERROR = "org.opentest4j.MultipleFailuresError";

    private IgnoreException() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isIgnoringThrowable(Throwable throwable) {
        if (throwable instanceof AssumptionViolatedException) {
            return true;
        }
        if (throwable instanceof IgnoreException) {
            return true;
        }
        if (!throwable.getClass().getName().equals(MULTIPLE_FAILURES_ERROR)) {
        }
        try {
            Method getFailuresMethod = Class.forName(MULTIPLE_FAILURES_ERROR).getDeclaredMethod("getFailures", new Class[0]);
            List failures = (List)getFailuresMethod.invoke((Object)throwable, new Object[0]);
            for (Throwable failure : failures) {
                if (!IgnoreException.isIgnoringThrowable(failure)) continue;
                return true;
            }
        }
        finally {
            return false;
        }
    }
}

